/*
 * Decompiled with CFR 0.152.
 */
package jespa.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import jespa.http.HttpRequest;
import jespa.io.ByteBuffer;

class HttpInputStream
extends FilterInputStream {
    static final int DEFAULT_BSIZE = 512;
    static final int REMAINING = Integer.MAX_VALUE;
    long remaining = -1L;
    long total = 0L;
    byte[] b1 = new byte[1];
    ByteBuffer bb = null;
    int bsize = 512;
    boolean isChunked = false;
    HttpRequest request;
    byte[] skipBuffer = null;

    HttpInputStream(InputStream in) {
        super(in);
    }

    void setChunked(boolean isChunked) {
        this.isChunked = isChunked;
        this.remaining = isChunked ? 0L : -1L;
    }

    void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    void setBufferSize(int bsize) {
        this.bsize = bsize;
    }

    long readChunkSize() throws IOException {
        long ret = 0L;
        if (this.total > 0L && (this._read() != 13 || this._read() != 10)) {
            throw new IOException("Invalid chunk separator");
        }
        int state = 1;
        while (state > 0) {
            int b = this._read();
            if (b < 0) {
                throw new IOException("Unexpected end-of-stream reading chunk size");
            }
            switch (state) {
                case 1: 
                case 2: {
                    int hval = Character.digit((char)b, 16);
                    if (hval >= 0) {
                        if (ret >= 0xFFFFFFFFFFFFFFFL) {
                            throw new IOException("Chunk size not supported");
                        }
                        ret = (ret << 4) + (long)hval;
                        state = 2;
                        break;
                    }
                    if (state == 1) {
                        throw new IOException("Invalid chunk size");
                    }
                    state = 3;
                }
                case 3: {
                    if (b != 10) break;
                    state = 0;
                }
            }
        }
        if (ret == 0L && (this._read() != 13 || this._read() != 10)) {
            throw new IOException("Unexpected trailer");
        }
        return ret;
    }

    ByteBuffer getByteBuffer() {
        if (this.bsize > 0) {
            if (this.bb == null) {
                this.bb = new ByteBuffer(new byte[this.bsize], 0, 0);
            }
        } else if (this.bb != null && this.bb.getRemaining() == 0) {
            this.bb = null;
        }
        return this.bb;
    }

    public int available() throws IOException {
        return 0;
    }

    int _read() throws IOException {
        if (this.getByteBuffer() == null) {
            return this.in.read();
        }
        if (this._read(this.b1, 0, 1) < 0) {
            return -1;
        }
        return this.b1[0] & 0xFF;
    }

    int _read(byte[] b) throws IOException {
        if (this.getByteBuffer() == null) {
            return this.in.read(b);
        }
        return this._read(b, 0, b.length);
    }

    int _read(byte[] b, int off, int len) throws IOException {
        if (this.getByteBuffer() == null) {
            return this.in.read(b, off, len);
        }
        int rem = this.bb.getRemaining();
        if (rem == 0) {
            this.bb.reset();
            rem = this.bb.read(this.in);
            if (rem < 0) {
                return -1;
            }
        }
        if (len > rem) {
            len = rem;
        }
        this.bb.decodeBytes(b, off, len);
        return len;
    }

    public int read() throws IOException {
        if (this.read(this.b1, 0, 1) < 0) {
            return -1;
        }
        return this.b1[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!(this.remaining != 0L || this.isChunked && (this.remaining = this.readChunkSize()) != 0L)) {
            this.request.requestComplete();
            return -1;
        }
        if (this.remaining != -1L && ((long)len & 0xFFFFFFFFL) > this.remaining) {
            len = (int)(this.remaining & 0xFFFFFFFFL);
        }
        if ((len = this._read(b, off, len)) > 0 && this.remaining != -1L) {
            this.remaining -= (long)len & 0xFFFFFFFFL;
            this.total += (long)len & 0xFFFFFFFFL;
        }
        if (len < 0) {
            this.request.requestComplete();
        }
        return len;
    }

    public long skip(long n) throws IOException {
        long rem = n;
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[512];
        }
        while (rem > 0L) {
            int rn = (int)Math.min(512L, rem);
            if ((rn = this.read(this.skipBuffer, 0, rn)) < 0) break;
            rem -= (long)rn;
        }
        return n - rem;
    }

    public void close() throws IOException {
        if (this.request != null && this.request.state == 7) {
            this.request.getPeer().disconnect();
        } else {
            long l = this.skip(Integer.MAX_VALUE);
        }
    }

    String readLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            char ch;
            if ((ch = (char)(this._read() & 0xFF)) == '\uffff') {
                return null;
            }
            if (ch == '\n') break;
            if (ch == '\r') continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

