/*
 * Decompiled with CFR 0.152.
 */
package jespa.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import jespa.http.HttpRequest;
import jespa.io.ByteBuffer;
import jespa.util.LogStream;

class HttpOutputStream
extends FilterOutputStream {
    static final int DEFAULT_BSIZE = 512;
    static final byte[] HEXDIGITS = "0123456789ABCDEF".getBytes();
    static final byte[] ZEROLBLB = "0\r\n\r\n".getBytes();
    ByteBuffer bb;
    byte[] b2 = new byte[2];
    boolean isChunked = false;
    int chunkMax = 4095;
    HttpRequest request = null;

    HttpOutputStream(OutputStream out) {
        super(out);
        this.bb = new ByteBuffer(new byte[512], 0, 0);
    }

    void setChunked(boolean isChunked) throws IOException {
        this.isChunked = isChunked;
        if (isChunked) {
            if (this.bb == null || this.bb.getIndex() > 0) {
                throw new IOException("Cannot set chunked after writing data");
            }
            this.bb.setIndex(8);
            this.bb.setStart();
        } else {
            this.bb = new ByteBuffer(new byte[512], 0, 0);
        }
    }

    public void write(int b) throws IOException {
        this.b2[0] = (byte)b;
        this.write(this.b2, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bb != null) {
            if (!this.isChunked) {
                this.bb.encodeBytes(b, off, len);
            } else {
                while (len > 0) {
                    int n = Math.min(len, this.chunkMax - this.bb.getIndex());
                    this.bb.encodeBytes(b, off, n);
                    off += n;
                    len -= n;
                    if (this.bb.getIndex() != this.chunkMax) continue;
                    this.flush(false);
                }
            }
        } else {
            this.out.write(b, off, len);
        }
    }

    public void writeLine(String line) throws IOException {
        byte[] a = line.getBytes("US-ASCII");
        this.write(a, 0, a.length);
        this.b2[0] = 13;
        this.b2[1] = 10;
        this.write(this.b2, 0, 2);
    }

    void encodeChunkEnvelope(boolean isLast) throws IOException {
        int n = this.bb.getIndex();
        if (n > 0 || isLast) {
            int si = 8;
            if (n > 0) {
                byte[] cbuf = this.bb.getBuffer();
                cbuf[--si] = 10;
                cbuf[--si] = 13;
                do {
                    if (si == 0) {
                        throw new IOException("Chunk size not supported");
                    }
                    cbuf[--si] = HEXDIGITS[n & 0xF];
                } while ((n >>= 4) > 0);
                this.bb.encodeBytes(ZEROLBLB, 1, 2);
            }
            if (isLast) {
                this.bb.encodeBytes(ZEROLBLB, 0, 5);
            }
            this.bb.shift(si - this.bb.getStart(), false);
        }
    }

    public void flush(boolean isLast) throws IOException {
        if (this.bb != null) {
            if (this.isChunked) {
                this.encodeChunkEnvelope(isLast);
            }
            if (this.request != null) {
                int flags = 0;
                if (this.isChunked) {
                    flags |= 2;
                }
                if (isLast || !this.isChunked) {
                    flags |= 4;
                }
                this.request.getPeer().sendrecv(this.request, this.bb, flags);
            } else {
                this.bb.write(this.out, this.bb.getIndex(), false);
            }
            if (!this.isChunked) {
                this.bb = null;
            }
            if (this.bb != null) {
                this.bb.reset();
                this.bb.setIndex(0);
            }
        }
        this.out.flush();
    }

    public void flush() throws IOException {
        this.flush(false);
    }

    public void close() throws IOException {
        block3: {
            try {
                this.flush(true);
            }
            catch (SocketException se) {
                LogStream log = LogStream.getInstance();
                if (LogStream.level >= 5) {
                    se.printStackTrace(log);
                }
                if (LogStream.level < 4) break block3;
                log.println("HttpOutputStream: " + se.getMessage());
            }
        }
    }
}

