/*
 * Decompiled with CFR 0.152.
 */
package jespa.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import jcifs.util.Base64;
import jespa.dns.Dns;
import jespa.http.CookieException;
import jespa.http.CookieList;
import jespa.http.HeaderList;
import jespa.http.HttpException;
import jespa.http.HttpInputStream;
import jespa.http.HttpOutputStream;
import jespa.http.HttpRequest;
import jespa.http.HttpRetryException;
import jespa.io.ByteBuffer;
import jespa.ntlm.NtlmSecurityProvider;
import jespa.security.Properties;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.CacheMap;
import jespa.util.LogStream;

class HttpPeer
extends Properties {
    static final String[] HTTP_PEER_KEYS = new String[]{"domain.dns.name", "http.redirect.limit", "dns.servers", "dns.records.path", "dns.cache.ttl", "dns.site", "dns.jndifactory.classname", "service.acctname", "service.password", "http.tls.sslsocketfactory.classname", "ntlmssp.flags"};
    static final int FLAGS_NO_WAIT = 1;
    static final int FLAGS_IS_CHUNKED = 2;
    static final int FLAGS_IS_LAST = 4;
    static HttpPeerPool<Map, HttpPeer> peers = new HttpPeerPool(300L, 60L);
    boolean isAcquired = false;
    Socket socket = null;
    OutputStream outputStream = null;
    InputStream inputStream = null;
    HttpOutputStream httpOutputStream = null;
    HttpInputStream httpInputStream = null;
    CookieList cookieList = null;
    boolean connectionClose = false;
    LogStream log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HttpPeer acquireInstance(Map properties, URL url) throws HttpException {
        HttpPeerPool<Map, HttpPeer> httpPeerPool = peers;
        synchronized (httpPeerPool) {
            HttpPeer peer = new HttpPeer(properties, url);
            HttpPeer epeer = (HttpPeer)peers.get(peer);
            if (epeer == null) {
                peers.put(peer, peer);
            } else if (!epeer.isAcquired) {
                peer = epeer;
            }
            peer.reset();
            peer.isAcquired = true;
            return peer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseInstance(HttpPeer peer, boolean disco) {
        HttpPeerPool<Map, HttpPeer> httpPeerPool = peers;
        synchronized (httpPeerPool) {
            peer.isAcquired = false;
            if (peers.get(peer) == peer) {
                if (!disco && peer.socket != null) {
                    return;
                }
                peers.remove(peer);
            }
            peer.disconnect();
        }
    }

    HttpPeer(Map properties, URL url) throws HttpException {
        super(HttpPeer.getFilteredProperties(properties, HTTP_PEER_KEYS));
        this.setURL(url);
        this.log = LogStream.getInstance();
        if (LogStream.level >= 4) {
            try {
                url = this.getURL(null);
                this.log.println("HttpPeer(" + this.getURL(null) + ")");
            }
            catch (MalformedURLException mue) {
                throw new HttpException(0, mue.getMessage(), mue);
            }
        }
    }

    void setURL(URL url) {
        String proto = url.getProtocol().toLowerCase();
        String host = url.getHost().toLowerCase();
        int port = url.getPort();
        if (port < 1) {
            port = proto.equals("https") ? 443 : 80;
        }
        this.put("http.proto", proto);
        this.put("http.host", host);
        this.put("http.port", "" + port);
    }

    URL getURL(String path) throws MalformedURLException {
        String proto = ((String)this.get("http.proto")).toLowerCase();
        String host = ((String)this.get("http.host")).toLowerCase();
        int port = Integer.parseInt((String)this.get("http.port"));
        String urlstr = proto + "://" + host;
        if (port != 80 || proto.equals("https") && port != 443) {
            urlstr = urlstr + ":" + port;
        }
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        urlstr = path != null ? urlstr + (path.charAt(0) == '/' ? "" : "/") + path : urlstr + "/";
        return new URL(urlstr);
    }

    void connect() throws IOException {
        if (this.socket != null) {
            return;
        }
        String proto = ((String)this.get("http.proto")).toLowerCase();
        String host = ((String)this.get("http.host")).toLowerCase();
        int port = Integer.parseInt((String)this.get("http.port"));
        String ipaddress = (String)this.get("http.host.ipaddress");
        Dns dns = Dns.getInstance(this);
        Dns.DnsRecordA[] dr = (Dns.DnsRecordA[])dns.getRecordsByName(host, "A");
        Throwable ioe = null;
        int si = 0;
        if (ipaddress != null) {
            this.remove("http.host.ipaddress");
            for (si = 0; si < dr.length && ipaddress.equals(dr[si].address); ++si) {
            }
        }
        for (int di = 0; di < dr.length; ++di) {
            ipaddress = dr[(si + di) % dr.length].address;
            try {
                if (proto.equals("http")) {
                    this.socket = new Socket(ipaddress, port);
                } else if (proto.equals("https")) {
                    SSLSocketFactory ssf = null;
                    String htsc = (String)this.getProperty("http.tls.sslsocketfactory.classname", null);
                    if (htsc != null) {
                        if (LogStream.level >= 4) {
                            this.log.println("HttpPeer: Using custom SSLSocketFactory: " + htsc);
                        }
                        Method m = Class.forName(htsc).getDeclaredMethod("getDefault", new Class[0]);
                        ssf = (SSLSocketFactory)m.invoke(null, new Object[0]);
                    }
                    if (ssf == null) {
                        ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    }
                    this.socket = ssf.createSocket(ipaddress, port);
                } else {
                    throw new IOException("Protocol not supported: " + proto);
                }
                this.outputStream = this.socket.getOutputStream();
                this.inputStream = this.socket.getInputStream();
                this.reset();
                this.put("http.host.ipaddress", ipaddress);
                return;
            }
            catch (IOException _ioe) {
                ioe = _ioe;
                continue;
            }
            catch (Exception e) {
                ioe = new IOException(e.getMessage());
                ioe.initCause(e);
            }
        }
        if (LogStream.level >= 1) {
            ioe.printStackTrace(this.log);
        }
        throw ioe;
    }

    int getLocalPort() {
        return this.socket == null ? -1 : this.socket.getLocalPort();
    }

    void reset() {
        this.httpOutputStream = null;
        this.httpInputStream = null;
        this.connectionClose = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        if (this.socket == null) {
            return;
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException ioe) {
            this.outputStream = null;
            this.inputStream = null;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
                this.remove("http.host.address");
                this.reset();
            }
        }
        finally {
            this.outputStream = null;
            this.inputStream = null;
            try {
                this.socket.close();
            }
            catch (IOException ioe) {
            }
            finally {
                this.socket = null;
                this.remove("http.host.address");
                this.reset();
            }
        }
    }

    HttpOutputStream getHttpOutputStream() throws IOException {
        if (this.socket == null) {
            this.connect();
        }
        if (this.httpOutputStream == null) {
            this.httpOutputStream = new HttpOutputStream(this.outputStream);
        }
        return this.httpOutputStream;
    }

    HttpInputStream getHttpInputStream() throws IOException {
        if (this.socket == null) {
            this.connect();
        }
        if (this.httpInputStream == null) {
            this.httpInputStream = new HttpInputStream(this.inputStream);
        }
        return this.httpInputStream;
    }

    void send(HttpRequest req, ByteBuffer body, int flags) throws IOException {
        if (this.socket == null) {
            this.connect();
        }
        if (req.state < 2) {
            if (this.connectionClose) {
                throw new IOException("Connect is set to close");
            }
            HeaderList headerList = req.getHeaderList();
            if (headerList.getHeader("User-Agent") == null) {
                headerList.set("User-Agent", "Java/" + System.getProperty("java.version") + " Jespa/1.1");
            }
            String host = (String)this.get("http.host");
            int port = Integer.parseInt((String)this.get("http.port"));
            headerList.set("Host", host + (port == 80 ? "" : ":" + port));
            if (headerList.getHeader("Connection") == null) {
                headerList.append("Connection", "keep-alive");
            }
            if (this.cookieList != null) {
                try {
                    String cookie = this.cookieList.getCookieHeader(req.getUri(), CookieList.EXCLUDES_REQUEST);
                    if (cookie != null) {
                        headerList.append("Cookie", cookie);
                    }
                }
                catch (CookieException ce) {
                    throw new HttpException(0, "Failed to build Cookie header", ce);
                }
            }
            if (body != null) {
                if ((flags & 2) == 2) {
                    headerList.set("Transfer-Encoding", "chunked");
                } else if ((flags & 4) == 4) {
                    headerList.set("Content-Length", "" + body.getLength());
                }
            }
            HttpOutputStream out = new HttpOutputStream(this.outputStream);
            req.write(out);
            if (body != null) {
                body.write(out, body.getIndex(), false);
            }
            out.close();
            req.state = (flags & 4) == 0 ? 2 : 4;
        } else if (req.state < 4) {
            if (body != null) {
                body.write(this.outputStream, body.getIndex(), false);
            }
            req.state = (flags & 4) == 0 ? 2 : 3;
        }
        this.outputStream.flush();
    }

    void recv(HttpRequest req) throws IOException {
        if (this.socket != null && req.state > 2) {
            HttpInputStream in = this.getHttpInputStream();
            req.state = 5;
            req.read(in);
            for (HeaderList.Header header : req.getHeaderList()) {
                if (header.key == null || !header.key.equalsIgnoreCase("Set-Cookie")) continue;
                try {
                    if (this.cookieList == null) {
                        this.cookieList = new CookieList();
                    }
                    this.cookieList.addAll(HeaderList.toAsciiString(header.val));
                }
                catch (CookieException ce) {
                    throw new HttpException(0, "Failed to parse Set-Cookie header", ce);
                }
            }
            this.connectionClose = req.getHeaderList().getHeaderString("Connection", "close", true) != null;
            req.state = this.connectionClose ? 7 : 6;
        }
    }

    void sendrecv(HttpRequest req, ByteBuffer content, int flags) throws IOException {
        SecurityProvider provider = null;
        boolean again = false;
        int nlimit = 3;
        int rlimit = 5;
        String hrl = (String)this.get("http.redirect.limit");
        if (hrl != null) {
            rlimit = Integer.parseInt(hrl);
        }
        boolean followRedirects = rlimit > 0;
        boolean isStreamed = false;
        do {
            again = false;
            this.send(req, content, flags);
            if (LogStream.level >= 4) {
                this.log.println("HttpPeer: state=" + HttpRequest.stateNames[req.state]);
            }
            isStreamed = req.state == 3;
            this.recv(req);
            if (LogStream.level >= 4) {
                this.log.println("HttpPeer: state=" + HttpRequest.stateNames[req.state] + " status=" + req.status);
            }
            if (req.status == 401) {
                if (isStreamed) {
                    throw new HttpRetryException(req.status, req.statusMessage + ": Cannot automatically handle " + req.status + " after streaming more than one block");
                }
                if (nlimit-- == 0) {
                    throw new HttpException(req.status, "Too many requests in NTLMSSP handshake");
                }
                String mech = "NTLM";
                byte[] token = req.getHeaderList().getHeaderBytesBase64("WWW-Authenticate", mech, true);
                if (token == null || token.length == 0 && provider != null) continue;
                if (token.length != 0 && req.getHeaderList().getHeaderString("Connection", "close", true) != null) {
                    throw new IOException("NTLM requires keep-alive");
                }
                if (provider == null) {
                    if (!this.containsKey("ntlmssp.flags")) {
                        try {
                            this.setProperty("ntlmssp.flags", "0xa0088207");
                        }
                        catch (SecurityProviderException spe) {
                            throw new IOException("Failed to set ntlmssp.flags: " + spe.getMessage());
                        }
                    }
                    provider = new NtlmSecurityProvider((Map)this);
                }
                try {
                    token = provider.initSecContext(token, 0, token.length);
                }
                catch (SecurityProviderException spe) {
                    throw new HttpException(req.status, req.statusMessage, spe);
                }
                req.state = 1;
                req.getInputStream().skip(Integer.MAX_VALUE);
                req.reset();
                this.reset();
                if (token.length > 0) {
                    req.getHeaderList().append("Authorization", mech + ' ' + Base64.encode((byte[])token));
                }
                again = true;
                continue;
            }
            if (!followRedirects || req.status != 301 && req.status != 302) break;
            if (isStreamed) {
                throw new HttpRetryException(req.status, req.statusMessage + ": Cannot automatically handle " + req.status + " after streaming more than one block");
            }
            if (rlimit-- == 0) {
                throw new HttpException(req.status, "Too many redirects");
            }
            String location = req.getHeaderList().getHeaderString("Location");
            if (location == null) continue;
            if (LogStream.level >= 4) {
                this.log.println("HttpPeer: " + req.status + " redirect to " + location);
            }
            URL ourl = this.getURL(req.getUri());
            URL nurl = new URL(ourl, location);
            if (!ourl.getAuthority().equals(nurl.getAuthority()) || !ourl.getProtocol().equals(nurl.getProtocol())) {
                this.disconnect();
            }
            String path = nurl.getPath();
            String query = nurl.getQuery();
            String ref = nurl.getRef();
            String uri = path;
            if (query != null) {
                uri = uri + "?" + query;
            }
            if (ref != null) {
                uri = uri + "#" + ref;
            }
            this.setURL(nurl);
            req.getInputStream().close();
            req.reset();
            req.setUri(uri);
            this.reset();
            nlimit = 2;
            again = true;
        } while (again);
        if (req.status > 201) {
            throw new HttpException(req.status, req.statusMessage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HttpPeerPool<K, V>
    extends CacheMap<K, V> {
        public HttpPeerPool(long expiration, long period) {
            super("HttpPeerPool", expiration, period);
        }

        @Override
        protected void dispose(V val) {
            if (val instanceof HttpPeer) {
                HttpPeer peer = (HttpPeer)val;
                peer.disconnect();
            }
        }
    }
}

