/*
 * Decompiled with CFR 0.152.
 */
package jespa.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jespa.http.HeaderList;
import jespa.http.HttpCallback;
import jespa.http.HttpException;
import jespa.http.HttpInputStream;
import jespa.http.HttpOutputStream;
import jespa.http.HttpPeer;
import jespa.util.LogStream;

class HttpRequest {
    static final int ST_START = 0;
    static final int ST_RESENDING = 1;
    static final int ST_SENDING = 2;
    static final int ST_STREAMED = 3;
    static final int ST_SENT = 4;
    static final int ST_RECEIVING = 5;
    static final int ST_RECEIVED = 6;
    static final int ST_CLOSE = 7;
    static final String[] stateNames = new String[]{"ST_START", "ST_RESENDING", "ST_SENDING", "ST_STREAMED", "ST_SENT", "ST_RECEIVING", "ST_RECEIVED", "ST_CLOSE"};
    String version;
    String method;
    String uri;
    HeaderList headers = null;
    HeaderList originalHeaders = null;
    HttpPeer peer = null;
    int status;
    String statusMessage;
    int state;
    HttpCallback requestCompleteCallback = null;

    HttpRequest(String method, String uri) {
        this.method = method;
        this.setUri(uri);
        this.reset();
    }

    void setUri(String uri) {
        if (uri != null && (uri = uri.trim()).length() == 0) {
            uri = null;
        }
        this.uri = uri == null ? "/" : uri;
    }

    String getUri() {
        return this.uri;
    }

    void setPeer(HttpPeer peer) {
        this.peer = peer;
    }

    HttpPeer getPeer() {
        return this.peer;
    }

    void setHeaderList(HeaderList headers) {
        this.headers = headers;
    }

    HeaderList getHeaderList() {
        return this.headers;
    }

    void reset() {
        this.version = "HTTP/1.1";
        this.headers = this.originalHeaders != null ? (HeaderList)this.originalHeaders.clone() : new HeaderList();
        this.status = -1;
        this.statusMessage = null;
        this.state = 0;
    }

    void setRequestCompleteCallback(HttpCallback requestCompleteCallback) {
        this.requestCompleteCallback = requestCompleteCallback;
    }

    void requestComplete() throws IOException {
        if (this.peer != null && this.requestCompleteCallback != null) {
            this.requestCompleteCallback.requestComplete(this.peer, this);
        }
    }

    void write(HttpOutputStream out) throws IOException {
        out.writeLine(this.method + ' ' + this.uri + ' ' + this.version);
        this.headers.write(out);
        if (this.originalHeaders == null) {
            this.originalHeaders = (HeaderList)this.headers.clone();
        }
        out.writeLine("");
    }

    void read(HttpInputStream in) throws IOException {
        String command = in.readLine();
        if (command == null) {
            throw new IOException("The input stream has closed");
        }
        int ve = command.indexOf(32);
        if (ve > 0) {
            this.version = command.substring(0, ve++);
            int se = command.indexOf(32, ve);
            if (se > ve) {
                this.status = Integer.parseInt(command.substring(ve, se++));
                if (command.length() > se) {
                    this.statusMessage = command.substring(se);
                }
                this.headers = new HeaderList();
                this.headers.append(null, command);
                this.headers.read(in);
                return;
            }
        }
        LogStream log = LogStream.getInstance();
        if (LogStream.level >= 4) {
            log.println("HttpRequest: command[" + command + "]");
        }
        throw new HttpException(0, "Invalid HTTP response");
    }

    OutputStream getOutputStream() throws IOException {
        if (this.peer == null) {
            throw new IOException("HttpPeer must be set before OutputStream can be retrieved");
        }
        HttpOutputStream out = this.peer.getHttpOutputStream();
        out.request = this;
        return out;
    }

    InputStream getInputStream() throws IOException {
        if (this.peer == null) {
            throw new IOException("HttpPeer must be set before InputStream can be retrieved");
        }
        HttpInputStream in = this.peer.getHttpInputStream();
        in.request = this;
        String value = this.getHeaderList().getHeaderString("Content-Length");
        if (value != null) {
            long contentLength = Long.parseLong(value);
            in.setRemaining(contentLength);
        } else if (this.getHeaderList().getHeaderString("Transfer-Encoding", "chunked", true) != null) {
            in.setChunked(true);
        }
        return in;
    }

    public String toString() {
        String ret = "";
        if (this.status > 0) {
            ret = ret + this.version + ' ' + this.status;
            if (this.statusMessage != null) {
                ret = ret + ' ' + this.statusMessage;
            }
            ret = ret + ' ';
        }
        ret = ret + this.method + ' ' + this.uri + " [" + this.headers.toString() + "]";
        return ret;
    }
}

