/*
 * Decompiled with CFR 0.152.
 */
package jespa.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import jcifs.Config;
import jcifs.util.Base64;
import jespa.http.HttpSecurityServletRequest;
import jespa.http.TimestampedLogStream;
import jespa.security.Account;
import jespa.security.PasswordCredential;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.CacheMap;
import jespa.util.Csv;
import jespa.util.LogStream;

public class HttpSecurityService {
    static final String DEFAULT_SECURITY_PROVIDER = "jespa.ntlm.NtlmSecurityProvider";
    static final String JESPA_FILTER_PROVIDER_STATE = "jespa.provider.state";
    static LogStream log = null;
    jespa.security.Properties providerProperties;
    Constructor providerConstructor;
    String usernameParameter;
    String passwordParameter;
    String logoutParameter;
    String anonymousParameter;
    String fallbackLocation;
    String[] excludes = null;
    String[] groupsDenied = null;
    String[] groupsAllowed = null;
    AuthContextPool<String, AuthContext> authContexts;
    boolean capabilitiesAcceptNtlmssp = false;
    boolean capabilitiesAcceptSpnego = false;
    boolean disableWarning = false;
    String name;
    ServletContext servletContext;
    Map serviceProperties;
    String propertiesPath;
    long propertiesLastModified = 0L;
    long propertiesLastStat = 0L;
    FileOutputStream logStream = null;

    public void init(Map props) throws SecurityProviderException {
        this.init(this.getClass().getName(), null, props);
    }

    public void init(String name, ServletContext servletContext, Map props) throws SecurityProviderException {
        this.name = name;
        this.servletContext = servletContext;
        this.serviceProperties = props;
        this.propertiesPath = (String)this.serviceProperties.remove("properties.path");
        if (this.propertiesPath != null) {
            String path = null;
            if (this.propertiesPath.startsWith("file:/")) {
                path = this.propertiesPath.substring(6);
            }
            if (path == null) {
                if (servletContext == null) {
                    throw new SecurityProviderException(0, "ServletContext must be supplied for properties.path support");
                }
                path = servletContext.getRealPath("/");
                if (path != null) {
                    path = path + this.propertiesPath;
                }
                if (path == null) {
                    try {
                        URL resource = servletContext.getResource("/" + this.propertiesPath);
                        if (resource != null) {
                            path = resource.getFile();
                        }
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
            }
            if (path == null) {
                throw new SecurityProviderException(0, "Failed to resolve properties.path: " + this.propertiesPath);
            }
            this.propertiesPath = path;
        }
        this.init(true);
        this.authContexts = new AuthContextPool(60L, 30L);
    }

    public void destroy() {
        if (this.logStream != null) {
            try {
                this.logStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logStream = null;
        }
    }

    protected void onPropertiesUpdate(Map props) throws SecurityProviderException {
        String logPath = this.getProperty(props, "jespa.log.path", null);
        if (logPath != null) {
            try {
                if (this.logStream != null) {
                    try {
                        this.logStream.close();
                    }
                    catch (IOException ioe) {
                        this.logStream = null;
                    }
                }
                this.logStream = new FileOutputStream(logPath, true);
                LogStream.setInstance(new TimestampedLogStream(this.logStream));
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace(LogStream.getInstance());
            }
        }
        log = LogStream.getInstance();
        String logLevel = this.getProperty(props, "jespa.log.level", null);
        if (logLevel != null) {
            LogStream.setLevel(Integer.parseInt(logLevel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean isUpdate) throws SecurityProviderException {
        HashMap<Object, Object> props = this.serviceProperties;
        boolean isFirst = isUpdate;
        boolean isModified = false;
        if (this.propertiesPath != null) {
            File stat = new File(this.propertiesPath);
            if (!stat.canRead()) {
                throw new SecurityProviderException(0, "Failed to read properties.path file: " + this.propertiesPath);
            }
            long lastModified = stat.lastModified();
            boolean bl = isModified = lastModified > this.propertiesLastModified;
            if (isModified) {
                this.propertiesLastModified = lastModified;
                try {
                    Properties tmp = new Properties();
                    FileInputStream fin = new FileInputStream(this.propertiesPath);
                    try {
                        tmp.load(fin);
                        props = new HashMap<Object, Object>(this.serviceProperties);
                        props.putAll(tmp);
                        isUpdate = true;
                    }
                    finally {
                        fin.close();
                    }
                }
                catch (IOException ioe) {
                    throw new SecurityProviderException(0, "Failed to load properties: " + this.propertiesPath, ioe);
                }
            }
        }
        if (isUpdate) {
            this.onPropertiesUpdate(props);
            log = LogStream.getInstance();
            if (isModified) {
                if (LogStream.level >= 2) {
                    if (!isFirst) {
                        log.println("HttpSecurityService: *** Properties file has been modified, re-initializing HttpSecurityService ...");
                    }
                    log.println("HttpSecurityService: *** Loading properties file: " + this.propertiesPath);
                }
            }
            this.providerProperties = new jespa.security.Properties();
            for (String name : props.keySet()) {
                String value = ((String)props.get(name)).trim();
                if (name.startsWith("jcifs.")) {
                    Config.setProperty((String)name, (String)value);
                    continue;
                }
                if (!name.startsWith("jespa.")) continue;
                if (name.endsWith(".service.password")) {
                    this.providerProperties.setEncryptedProperty(name.substring(6), value, null);
                    continue;
                }
                this.providerProperties.setProperty(name.substring(6), value);
            }
            if (LogStream.level >= 4) {
                log.println("HttpSecurityService: " + this.providerProperties);
            }
            String classname = this.getProperty(props, "provider.classname", DEFAULT_SECURITY_PROVIDER);
            try {
                Class<?> klass = Class.forName(classname);
                this.providerConstructor = klass.getConstructor(Map.class);
            }
            catch (Exception ex) {
                throw new SecurityProviderException(0, "Failed to acquire Constructor for provide.classname: " + classname, ex);
            }
            SecurityProvider tsp = this.newSecurityProvider();
            try {
                this.capabilitiesAcceptNtlmssp = tsp.getFlag("capabilities.accept.ntlmssp");
                this.capabilitiesAcceptSpnego = tsp.getFlag("capabilities.accept.spnego");
            }
            finally {
                tsp.dispose();
            }
            this.usernameParameter = this.getProperty(props, "http.parameter.username.name", null);
            this.passwordParameter = this.getProperty(props, "http.parameter.password.name", null);
            this.logoutParameter = this.getProperty(props, "http.parameter.logout.name", null);
            this.anonymousParameter = this.getProperty(props, "http.parameter.anonymous.name", null);
            this.fallbackLocation = this.getProperty(props, "fallback.location", null);
            String disable = this.getProperty(props, "http.parameter.password.disableWarning", null);
            this.disableWarning = disable != null && disable.equals("true");
            try {
                this.excludes = this.getPropertyAsArray(props, "excludes");
                this.groupsDenied = this.getPropertyAsArray(props, "groups.denied");
                this.groupsAllowed = this.getPropertyAsArray(props, "groups.allowed");
            }
            catch (IOException ioe) {
                throw new SecurityProviderException(0, ioe.getMessage(), ioe);
            }
            if (LogStream.level >= 1) {
                log.println("HttpSecurityService: " + this.toString());
            }
        }
    }

    public ServletContext getServletContext() {
        if (this.servletContext == null) {
            throw new RuntimeException("ServletContext not provided to HttpSecurityService constructor");
        }
        return this.servletContext;
    }

    private String[] getPropertyAsArray(Map props, String name) throws IOException {
        String str = this.getProperty(props, name, null);
        if (str != null) {
            return Csv.parseRow(str, ',', 5);
        }
        return null;
    }

    private String getProperty(Map props, String name, String def) {
        String ret;
        if (props.containsKey(name) && (ret = ((String)props.get(name)).trim()).length() > 0) {
            return ret;
        }
        return def;
    }

    private String arrayToString(String[] arr) {
        if (arr != null && arr.length > 0) {
            String ret = "";
            for (int ai = 0; ai < arr.length; ++ai) {
                ret = ret + ", " + arr[ai];
            }
            return ret.substring(2);
        }
        return "";
    }

    public String toString() {
        return "name=" + this.name + ", http.parameter.username.name=" + this.usernameParameter + ", http.parameter.password.name=" + this.passwordParameter + ", http.parameter.logout.name=" + this.logoutParameter + ", http.parameter.anonymous.name=" + this.anonymousParameter + ", fallback.location=" + this.fallbackLocation + ", excludes[" + this.arrayToString(this.excludes) + "]" + ", groupsDenied[" + this.arrayToString(this.groupsDenied) + "]" + ", groupsAllowed[" + this.arrayToString(this.groupsAllowed) + "]" + ", propertiesPath=" + this.propertiesPath;
    }

    SecurityProvider newSecurityProvider() throws SecurityProviderException {
        try {
            return (SecurityProvider)this.providerConstructor.newInstance(this.providerProperties);
        }
        catch (Exception ex) {
            throw new SecurityProviderException(0, "Failed to instantiate SecurityProvider", ex);
        }
    }

    byte[] getToken(HttpServletRequest req) {
        String hdr = req.getHeader("Authorization");
        if (hdr != null) {
            if (LogStream.level >= 4) {
                log.println("HttpSecurityService:   Authorization: " + hdr);
            }
            if (hdr.startsWith("NTLM ")) {
                if (this.capabilitiesAcceptNtlmssp) {
                    return Base64.decode((String)hdr.substring(5));
                }
            } else if (hdr.startsWith("Negotiate ")) {
                if (this.capabilitiesAcceptSpnego) {
                    return Base64.decode((String)hdr.substring(10));
                }
            } else {
                if (LogStream.level >= 4) {
                    log.println("HttpSecurityService: Authentication mechanism not supported by HttpSecurityService");
                }
                return null;
            }
            if (LogStream.level >= 3) {
                log.println("HttpSecurityService: SecurityProvider does not accept token type supplied by client, ignoring token");
            }
        }
        return null;
    }

    protected Object getRequestCredential(HttpServletRequest request) throws SecurityProviderException {
        String acctname;
        if (this.usernameParameter != null && this.passwordParameter != null && (acctname = request.getParameter(this.usernameParameter)) != null && (acctname = acctname.trim()).length() > 0) {
            String password = request.getParameter(this.passwordParameter);
            char[] passwordChars = null;
            if (password != null) {
                password = password.trim();
                passwordChars = password.toCharArray();
                if (LogStream.level >= 1 && !request.isSecure() && !this.disableWarning) {
                    log.println("HttpSecurityService: WARNING: password submitted without HTTPS");
                }
                if (LogStream.level >= 4) {
                    log.println("HttpSecurityService: Username and password supplied: " + acctname);
                }
            }
            return new PasswordCredential(acctname, passwordChars);
        }
        return null;
    }

    protected boolean isLogout(HttpServletRequest request) throws ServletException {
        return this.logoutParameter != null && request.getParameter(this.logoutParameter) != null;
    }

    protected boolean isAnonymous(HttpServletRequest request) throws ServletException {
        return this.anonymousParameter != null && request.getParameter(this.anonymousParameter) != null;
    }

    static boolean wildcmp(String exp, String str) {
        int si;
        int slen = str.length();
        int elen = exp.length();
        int ep = 0;
        int sp = 0;
        int ei = 0;
        for (si = 0; si < slen && (ei == elen || exp.charAt(ei) != '*'); ++si, ++ei) {
            if (ei != elen && (exp.charAt(ei) == str.charAt(si) || exp.charAt(ei) == '?')) continue;
            return false;
        }
        while (si < slen) {
            if (ei < elen && exp.charAt(ei) == '*') {
                if (++ei == elen) {
                    return true;
                }
                ep = ei;
                sp = si + 1;
                continue;
            }
            if (ei < elen && (exp.charAt(ei) == str.charAt(si) || exp.charAt(ei) == '?')) {
                ++ei;
                ++si;
                continue;
            }
            ei = ep;
            si = sp++;
        }
        while (ei < elen && exp.charAt(ei) == '*') {
            ++ei;
        }
        return ei == elen;
    }

    protected String getRequestPath(HttpServletRequest request) throws ServletException {
        try {
            return new URI(request.getRequestURI()).normalize().getPath();
        }
        catch (URISyntaxException se) {
            if (LogStream.level >= 3) {
                se.printStackTrace(log);
            }
            throw new ServletException("Failed to compose request path", (Throwable)se);
        }
    }

    protected boolean isProtected(HttpServletRequest request) throws ServletException {
        if (this.excludes != null) {
            String cpath;
            String rpath = this.getRequestPath(request);
            if (!rpath.startsWith(cpath = request.getContextPath())) {
                if (LogStream.level >= 3) {
                    log.println("HttpSecurityService: Request path does not start with context path: " + cpath);
                }
            } else {
                rpath = rpath.substring(cpath.length());
                if (LogStream.level >= 5) {
                    log.println("HttpSecurityService: Excludes request path [" + rpath + "]");
                }
                for (int ei = 0; ei < this.excludes.length; ++ei) {
                    if (LogStream.level >= 6) {
                        log.println("HttpSecurityService: Checking excludes expression [" + this.excludes[ei] + "]");
                    }
                    if (HttpSecurityService.wildcmp(this.excludes[ei], rpath)) {
                        if (LogStream.level >= 4) {
                            log.println("HttpSecurityService: Protection bypassed by exclude: " + this.excludes[ei]);
                        }
                        return false;
                    }
                    if (LogStream.level < 6) continue;
                    log.println("HttpSecurityService: Exclude expression did not match");
                }
            }
        }
        return true;
    }

    protected void isAllowedAccess(SecurityProvider provider, HttpServletRequest req, HttpServletResponse rsp) throws SecurityProviderException {
        if (provider != null) {
            int gi;
            Account acct = provider.getAccount(null, null);
            if (acct == null) {
                if (this.groupsAllowed != null || this.groupsDenied != null) {
                    if (LogStream.level >= 4) {
                        log.println("HttpSecurityService: SecurityProvider does not have a default Account - group based access control will be ignored");
                    }
                }
                return;
            }
            if (this.groupsDenied != null) {
                for (gi = 0; gi < this.groupsDenied.length; ++gi) {
                    if (!acct.isMemberOf(this.groupsDenied[gi])) continue;
                    throw new SecurityProviderException(7, provider.getIdentity() + " denied access by groups.denied: " + this.groupsDenied[gi]);
                }
            }
            if (this.groupsAllowed == null) {
                return;
            }
            if (acct != null) {
                for (gi = 0; gi < this.groupsAllowed.length; ++gi) {
                    if (!acct.isMemberOf(this.groupsAllowed[gi])) continue;
                    return;
                }
            }
        }
        throw new SecurityProviderException(7, provider.getIdentity() + " denied access by groups.allowed");
    }

    String getRequestHeaders(HttpServletRequest req) {
        String str = "";
        Enumeration e1 = req.getHeaderNames();
        while (e1.hasMoreElements()) {
            String name = (String)e1.nextElement();
            Enumeration e2 = req.getHeaders(name);
            while (e2.hasMoreElements()) {
                String value = (String)e2.nextElement();
                str = str + " | " + name + "=" + value;
            }
        }
        if (str.length() > 0) {
            str = str.substring(3);
        }
        return str;
    }

    void logSessionAttributes(HttpServletRequest req) {
        HttpSession ssn = req.getSession(true);
        String str = "";
        if (ssn != null) {
            Enumeration e = ssn.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                str = str + " | " + name + ": ";
                Object value = ssn.getAttribute(name);
                if (value instanceof byte[]) {
                    str = str + "byte[" + ((byte[])value).length + "]";
                    continue;
                }
                str = str + "" + value;
            }
        }
        if (str.length() > 0) {
            str = str.substring(2);
        }
        log.println("HttpSecurityService: Session Attributes:" + str);
    }

    protected String getConnectionId(HttpServletRequest req) throws SecurityProviderException {
        String p;
        String cid = req.getHeader("Jespa-Connection-Id");
        if (cid != null) {
            return cid;
        }
        int remotePort = req.getRemotePort();
        if (!(remotePort >= 1 || (p = req.getHeader("REMOTE_PORT")) != null && (remotePort = Integer.parseInt(p)) >= 1 || (p = (String)req.getAttribute("REMOTE_PORT")) != null && (remotePort = Integer.parseInt(p)) >= 1)) {
            throw new SecurityProviderException(0, "Insufficient getRemotePort value: " + remotePort);
        }
        return req.getRemoteAddr() + ":" + remotePort;
    }

    String _getConnectionId(HttpServletRequest req) throws SecurityProviderException {
        return this.getConnectionId(req);
    }

    void storeProviderState(HttpSession ssn, SecurityProvider provider, String id) throws SecurityProviderException {
        int interval;
        if (LogStream.level >= 4) {
            log.println("HttpSecurityService: " + id + ": Installing SecurityProvider state");
        }
        if (LogStream.level >= 3 && (interval = ssn.getMaxInactiveInterval()) <= 30000) {
            log.println("HttpSecurityService: MaxInactiveInterval is short (" + interval / 60 + " minutes), session-timeout = 600 is recommended");
        }
        byte[] providerState = (byte[])provider.exportState();
        ssn.setAttribute(JESPA_FILTER_PROVIDER_STATE, (Object)providerState);
        if (LogStream.level >= 4) {
            log.println("HttpSecurityService: " + id + ": SecurityProvider state installed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthContext getAuthContext(String connectionId) throws SecurityProviderException {
        AuthContext ctx;
        AuthContextPool<String, AuthContext> authContextPool = this.authContexts;
        synchronized (authContextPool) {
            ctx = (AuthContext)this.authContexts.get(connectionId);
            if (ctx == null) {
                ctx = new AuthContext(connectionId);
                this.authContexts.put(connectionId, ctx);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthContext removeAuthContext(String connectionId) throws SecurityProviderException {
        AuthContextPool<String, AuthContext> authContextPool = this.authContexts;
        synchronized (authContextPool) {
            return (AuthContext)this.authContexts.remove(connectionId);
        }
    }

    protected void onException(SecurityProviderException spe, HttpServletRequest req, HttpServletResponse rsp, SecurityProvider provider) throws SecurityProviderException {
        if (LogStream.level >= 4) {
            String requestPath = null;
            boolean isAnonymous = false;
            boolean isLogout = false;
            try {
                requestPath = this.getRequestPath(req);
                isAnonymous = this.isAnonymous(req);
                isLogout = this.isLogout(req);
            }
            catch (ServletException se) {
                // empty catch block
            }
            log.println("HttpSecurityService: onException: " + spe.getMessage() + ": getConnectionId=" + this.getConnectionId(req) + ",getRequestCredential=" + this.getRequestCredential(req) + ",getRequestPath=" + requestPath + ",isAnonymous=" + isAnonymous + ",isLogout=" + isLogout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String connectionId;
        boolean isForbidden;
        Object credential;
        byte[] token;
        SecurityProvider provider;
        boolean isChallengeRequired;
        boolean isUnauthorized;
        boolean isAnonymous;
        boolean isLogout;
        boolean isProtected;
        HttpStatusServletResponse rsp;
        Object req;
        block83: {
            if (this.propertiesPath != null) {
                HttpSecurityService httpSecurityService = this;
                synchronized (httpSecurityService) {
                    if (System.currentTimeMillis() > this.propertiesLastStat) {
                        try {
                            this.init(false);
                        }
                        catch (SecurityProviderException spe) {
                            throw new ServletException("Failed to re-initialize HttpSecurityService", (Throwable)spe);
                        }
                        finally {
                            this.propertiesLastStat = System.currentTimeMillis() + 5000L;
                        }
                    }
                }
            }
            req = (HttpServletRequest)request;
            rsp = new HttpStatusServletResponse((HttpServletResponse)response);
            HttpSession ssn = req.getSession(true);
            isProtected = this.isProtected((HttpServletRequest)req);
            isLogout = false;
            isAnonymous = false;
            isUnauthorized = true;
            isChallengeRequired = false;
            provider = null;
            token = null;
            credential = null;
            isForbidden = !this.capabilitiesAcceptSpnego && !this.capabilitiesAcceptNtlmssp;
            if (LogStream.level >= 3) {
                log.println("HttpSecurityService: C: " + req.getMethod() + " " + this.getRequestPath((HttpServletRequest)req));
            }
            if (LogStream.level >= 4) {
                log.println("HttpSecurityService: Request Headers: " + this.getRequestHeaders((HttpServletRequest)req));
                if (LogStream.level >= 5) {
                    this.logSessionAttributes((HttpServletRequest)req);
                }
            }
            try {
                block82: {
                    block81: {
                        isLogout = this.isLogout((HttpServletRequest)req);
                        if (isLogout) {
                            if (LogStream.level >= 4) {
                                log.println("HttpSecurityService: isLogout=true, removing provider state");
                            }
                            ssn.removeAttribute(JESPA_FILTER_PROVIDER_STATE);
                            isChallengeRequired = isUnauthorized = isProtected;
                        } else {
                            byte[] providerState;
                            if (LogStream.level >= 4) {
                                log.println("HttpSecurityService: Loading session state from session " + ssn.getId());
                            }
                            if ((providerState = (byte[])ssn.getAttribute(JESPA_FILTER_PROVIDER_STATE)) != null) {
                                if (LogStream.level >= 4) {
                                    log.println("HttpSecurityService: Importing provider state");
                                }
                                try {
                                    provider = this.newSecurityProvider();
                                    provider.importState(providerState);
                                    isUnauthorized = false;
                                    isChallengeRequired = false;
                                }
                                catch (SecurityProviderException spe) {
                                    if (LogStream.level >= 1) {
                                        spe.printStackTrace(log);
                                    }
                                    provider = null;
                                    ssn.removeAttribute(JESPA_FILTER_PROVIDER_STATE);
                                }
                            } else {
                                isChallengeRequired = isUnauthorized = isProtected;
                                if (LogStream.level >= 4) {
                                    log.println("HttpSecurityService: No provider state: isProtected=" + isProtected);
                                }
                            }
                        }
                        if (provider == null && (isAnonymous = this.isAnonymous((HttpServletRequest)req))) {
                            if (LogStream.level >= 4) {
                                log.println("HttpSecurityService: isAnonymous=true, installing anonymous provider state");
                            }
                            try {
                                provider = this.newSecurityProvider();
                                provider.put("anonymous", "1");
                                this.storeProviderState(ssn, provider, this.getConnectionId((HttpServletRequest)req));
                                isUnauthorized = false;
                                isChallengeRequired = false;
                            }
                            catch (SecurityProviderException spe) {
                                if (LogStream.level >= 1) {
                                    spe.printStackTrace(log);
                                }
                                if (provider == null) break block81;
                                provider.dispose();
                                provider = null;
                            }
                        }
                    }
                    if (this.capabilitiesAcceptSpnego || this.capabilitiesAcceptNtlmssp) {
                        token = this.getToken((HttpServletRequest)req);
                        if (token != null) {
                            String connectionId2 = this.getConnectionId((HttpServletRequest)req);
                            if (LogStream.level >= 4) {
                                log.println("HttpSecurityService: " + connectionId2 + ": token.length=" + token.length);
                            }
                            AuthContext ctx = this.getAuthContext(connectionId2);
                            try {
                                token = ctx.provider.acceptSecContext(token, 0, token.length);
                                boolean bl = isChallengeRequired = token != null;
                                if (!ctx.provider.isComplete()) {
                                    if (LogStream.level >= 4) {
                                        log.println("HttpSecurityService: " + connectionId2 + ": provider.isComplete=false, isUnauthorized=true");
                                    }
                                    isUnauthorized = true;
                                    break block82;
                                }
                                if (LogStream.level >= 2) {
                                    log.println("HttpSecurityService: " + connectionId2 + ": " + ctx.provider.getIdentity() + " successfully authenticated");
                                }
                                this.removeAuthContext(connectionId2);
                                if (provider == null) {
                                    this.isAllowedAccess(ctx.provider, (HttpServletRequest)req, (HttpServletResponse)rsp);
                                    this.storeProviderState(ssn, ctx.provider, connectionId2);
                                    provider = ctx.provider;
                                    isUnauthorized = false;
                                    break block82;
                                }
                                if (LogStream.level >= 4) {
                                    log.println("HttpSecurityService: " + connectionId2 + ": Disposing auth context for existing provider: " + provider.getName());
                                }
                                ctx.provider.dispose();
                            }
                            catch (SecurityProviderException spe) {
                                if (LogStream.level >= 2) {
                                    log.println("HttpSecurityService: " + connectionId2 + ": Authentication failed: " + spe.getMessage());
                                    if (LogStream.level >= 4) {
                                        spe.printStackTrace(log);
                                    }
                                }
                                token = null;
                                this.removeAuthContext(connectionId2);
                                this.onException(spe, (HttpServletRequest)req, (HttpServletResponse)rsp, ctx.provider);
                            }
                        }
                    } else {
                        if (LogStream.level >= 4) {
                            log.println("HttpSecurityService: SecurityProvider does not support token authentication");
                        }
                        isChallengeRequired = false;
                    }
                }
                if (token == null) {
                    credential = this.getRequestCredential((HttpServletRequest)req);
                    if (LogStream.level >= 4 && credential != null) {
                        log.println("HttpSecurityService: credential=" + credential);
                    }
                    if (credential != null) {
                        SecurityProvider tprovider = this.newSecurityProvider();
                        connectionId = this.getConnectionId((HttpServletRequest)req);
                        try {
                            tprovider.authenticate(credential);
                            this.isAllowedAccess(tprovider, (HttpServletRequest)req, (HttpServletResponse)rsp);
                            if (LogStream.level >= 2) {
                                log.println("HttpSecurityService: " + tprovider.getIdentity() + " successfully logged in");
                            }
                            this.storeProviderState(ssn, tprovider, connectionId);
                            if (provider != null) {
                                provider.dispose();
                            }
                            provider = tprovider;
                            isUnauthorized = false;
                            isChallengeRequired = false;
                        }
                        catch (SecurityProviderException spe) {
                            if (LogStream.level >= 2) {
                                log.println("HttpSecurityService: " + connectionId + ": Login failed: " + spe.getMessage());
                                if (LogStream.level >= 4) {
                                    spe.printStackTrace(log);
                                }
                            }
                            ssn.removeAttribute(JESPA_FILTER_PROVIDER_STATE);
                            isUnauthorized = true;
                            isChallengeRequired = false;
                            this.onException(spe, (HttpServletRequest)req, (HttpServletResponse)rsp, tprovider);
                            tprovider.dispose();
                        }
                    }
                }
            }
            catch (SecurityProviderException spe1) {
                if (LogStream.level >= 4) {
                    spe1.printStackTrace(log);
                }
                isUnauthorized = true;
                isChallengeRequired = false;
                if (provider == null) break block83;
                try {
                    provider.dispose();
                }
                catch (SecurityProviderException spe2) {
                    // empty catch block
                }
            }
        }
        if (token == null && !isForbidden) {
            boolean bl = isForbidden = rsp.getStatus() == 403;
        }
        if (isForbidden) {
            isChallengeRequired = false;
        }
        if (LogStream.level >= 4) {
            int size = 0;
            AuthContextPool<String, AuthContext> spe2 = this.authContexts;
            synchronized (spe2) {
                size = this.authContexts.size();
            }
            connectionId = null;
            try {
                connectionId = this.getConnectionId((HttpServletRequest)req);
            }
            catch (SecurityProviderException spe) {
                // empty catch block
            }
            log.println("HttpSecurityService: isProtected=" + isProtected + ", token=" + (token != null) + ", credential=" + credential + ", provider=" + provider + ", isLogout=" + isLogout + ", isAnonymous=" + isAnonymous + ", isChallengeRequired=" + isChallengeRequired + ", isUnauthorized=" + isUnauthorized + ", isForbidden=" + isForbidden + ", connectionId=" + connectionId + ", authContexts.size=" + size);
        }
        String rhdr = null;
        if (isChallengeRequired) {
            if (this.capabilitiesAcceptNtlmssp) {
                rhdr = "NTLM";
            } else if (this.capabilitiesAcceptSpnego) {
                rhdr = "Negotiate";
            } else {
                throw new ServletException("Invalid state: isChallengeRequired = true but capabilitiesAcceptXxx = false");
            }
            if (token != null) {
                rhdr = rhdr + " " + Base64.encode((byte[])token);
            }
            rsp.setHeader("WWW-Authenticate", rhdr);
        }
        if (isUnauthorized) {
            String sm = isForbidden ? "403 Forbidden" : "401 Unauthorized";
            rsp.setStatus(isForbidden ? 403 : 401);
            if (this.fallbackLocation != null) {
                rsp.setContentType("text/html");
                String body = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\r\n<html><head>\r\n<script type='text/javascript'>\r\n<!--\r\nwindow.location='" + this.fallbackLocation + "';\r\n" + "//-->\r\n" + "</script>\r\n" + "</head><h3>" + sm + "</h3>\r\n" + "<p/>Please visit this link: <a href='" + this.fallbackLocation + "'>" + this.fallbackLocation + "</a>\r\n" + "</html>\r\n";
                ServletOutputStream os = rsp.getOutputStream();
                os.print(body);
                os.close();
                rsp.setContentLength(body.length());
            } else {
                rsp.setContentLength(0);
            }
            rsp.flushBuffer();
            if (LogStream.level >= 4) {
                log.println("HttpSecurityService: S: " + sm);
                if (rhdr != null) {
                    log.println("HttpSecurityService:   WWW-Authenticate: " + rhdr);
                }
            }
        } else {
            if (isChallengeRequired) {
                throw new ServletException("Invalid state: isUnauthorized = false but isChallengeRequired = true");
            }
            if (provider != null) {
                req = new HttpSecurityServletRequest((HttpServletRequest)req, this, provider);
            }
            if (LogStream.level >= 4) {
                log.println("HttpSecurityService: calling chain.doFilter");
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    class HttpStatusServletResponse
    extends HttpServletResponseWrapper {
        int sc;

        HttpStatusServletResponse(HttpServletResponse rsp) {
            super(rsp);
            this.sc = 200;
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.sc = sc;
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            this.sc = sc;
        }

        public int getStatus() {
            return this.sc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AuthContextPool<K, V>
    extends CacheMap<K, V> {
        public AuthContextPool(long expiration, long period) {
            super("HttpSecurityService: AuthContextPool", expiration, period);
        }

        @Override
        protected void dispose(V val) {
            if (val instanceof AuthContext) {
                AuthContext ctx = (AuthContext)val;
                if (ctx.provider != null) {
                    try {
                        ctx.provider.dispose();
                    }
                    catch (SecurityProviderException securityProviderException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class AuthContext {
        SecurityProvider provider;
        byte[] token;

        AuthContext(String name) throws SecurityProviderException {
            this.provider = HttpSecurityService.this.newSecurityProvider();
            if (LogStream.level >= 4) {
                log.println("HttpSecurityService: AuthContext: " + name);
            }
        }
    }
}

