/*
 * Decompiled with CFR 0.152.
 */
package jespa.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jcifs.util.Base64;
import jespa.http.HeaderList;
import jespa.http.HttpCallback;
import jespa.http.HttpOutputStream;
import jespa.http.HttpPeer;
import jespa.http.HttpRequest;

public class HttpURLConnection
extends java.net.HttpURLConnection
implements HttpCallback {
    HttpPeer peer;
    HeaderList headers = null;
    HttpRequest request = null;
    private Map props = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;

    public HttpURLConnection(URL url) {
        super(url);
    }

    public String getHeaderField(String name) {
        try {
            this.getInputStream();
            if (this.request != null) {
                return this.request.getHeaderList().getHeaderString(name);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
            if (this.request != null) {
                return this.request.getHeaderList().getHeaderMap();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
            if (this.request != null) {
                return this.request.getHeaderList().getHeaderString(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
            if (this.request != null) {
                return this.request.getHeaderList().getHeaderKeyString(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void requestComplete(HttpPeer p, HttpRequest r) throws IOException {
        if (r.state != 1) {
            HttpPeer.releaseInstance(p, false);
        }
    }

    private Map getProps() {
        if (this.props == null) {
            this.props = new HashMap();
        }
        return this.props;
    }

    public void connect() throws IOException {
        String dname;
        if (this.peer != null) {
            return;
        }
        this.getProps();
        if (!HttpURLConnection.getFollowRedirects()) {
            this.props.put("http.redirect.limit", "0");
        }
        if ((dname = System.getProperty("jespa.domain.dns.name")) == null) {
            dname = System.getProperty("http.auth.ntlm.domain");
        }
        if (dname != null) {
            this.props.put("domain.dns.name", dname);
        }
        this.peer = HttpPeer.acquireInstance(this.props, this.url);
        this.connected = true;
    }

    public void disconnect() {
        if (this.peer == null) {
            return;
        }
        HttpPeer.releaseInstance(this.peer, true);
        this.peer = null;
        this.connected = false;
        this.inputStream = null;
        this.outputStream = null;
        this.request = null;
    }

    public boolean usingProxy() {
        return false;
    }

    HeaderList getHeaderList() {
        if (this.headers == null) {
            this.headers = new HeaderList();
        }
        return this.headers;
    }

    private void setRequestProperty0(String key, String value, boolean overwrite) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key.startsWith("jespa.")) {
            Map props = this.getProps();
            key = key.substring(6).trim();
            if (!overwrite && props.containsKey(key)) {
                return;
            }
            try {
                value = new String(Base64.decode((String)value), "UTF-8").trim();
                if (key.length() > 0 && value.length() > 0) {
                    props.put(key, value);
                }
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            return;
        }
        HeaderList hlist = this.getHeaderList();
        if (!overwrite && hlist.getHeader(key) != null) {
            return;
        }
        hlist.append(key, value);
    }

    public void addRequestProperty(String key, String value) {
        this.setRequestProperty0(key, value, false);
    }

    public void setRequestProperty(String key, String value) {
        this.setRequestProperty0(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            if (this.request == null) {
                if (this.method.equals("GET")) {
                    if (this.peer == null) {
                        this.connect();
                    }
                    String path = this.url.getPath();
                    String query = this.url.getQuery();
                    if (query != null) {
                        path = path + '?' + query;
                    }
                    HttpRequest req = new HttpRequest(this.method, path);
                    req.setPeer(this.peer);
                    req.setRequestCompleteCallback(this);
                    req.setHeaderList(this.getHeaderList());
                    try {
                        this.peer.sendrecv(req, null, 4);
                    }
                    finally {
                        this.inputStream = req.getInputStream();
                    }
                    this.request = req;
                } else {
                    throw new IOException("Invalid call for method " + this.method);
                }
            }
            if (this.request.state <= 2) {
                throw new IOException("Request must be sent (by closing the stream) before the response can be received");
            }
            if (this.inputStream == null) {
                this.inputStream = this.request.getInputStream();
            }
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            if (this.request == null) {
                if (this.peer == null) {
                    this.connect();
                }
                if (this.method.equals("GET")) {
                    this.method = "POST";
                }
                String path = this.url.getPath();
                String query = this.url.getQuery();
                if (query != null) {
                    path = path + '?' + query;
                }
                HttpRequest req = new HttpRequest(this.method, path);
                req.setPeer(this.peer);
                req.setRequestCompleteCallback(this);
                req.setHeaderList(this.getHeaderList());
                if (this.method.equals("POST") && this.headers.getHeader("Content-Type") == null) {
                    this.headers.set("Content-Type", "application/x-www-form-urlencoded");
                }
                this.request = req;
            }
            HttpOutputStream out = (HttpOutputStream)this.request.getOutputStream();
            if (this.chunkLength > 0) {
                out.setChunked(true);
                out.chunkMax = this.chunkLength;
            }
            this.outputStream = out;
        }
        return this.outputStream;
    }
}

