/*
 * Decompiled with CFR 0.152.
 */
package jespa.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import jcifs.util.Encdec;
import jcifs.util.Hexdump;
import jespa.io.EncodingException;

public class ByteBuffer {
    protected ByteBuffer master = this;
    protected byte[] buf;
    protected int start;
    protected int db;
    protected int di;
    protected int de;
    protected int frame;

    public ByteBuffer(byte[] buf, int off, int len) {
        this.buf = buf == null ? new byte[64] : buf;
        this.start = 0;
        this.db = off;
        this.di = off;
        this.de = off + len;
        this.frame = 0;
    }

    public ByteBuffer() {
        this(null, 0, 0);
    }

    public void reset() {
        this.db = 0;
        this.di = 0;
        this.de = 0;
        this.frame = 0;
    }

    public ByteBuffer derive(int index) {
        ByteBuffer bb = new ByteBuffer(this.master.buf, this.master.start + index, 0);
        bb.master = this.master;
        return bb;
    }

    public byte[] getBuffer() {
        return this.master.buf;
    }

    public void setStart() {
        this.master.start = this.di;
    }

    public int getStart() {
        return this.master.start;
    }

    public void setIndex(int index) {
        this.di = this.master.start + index;
    }

    public int getIndex() {
        return this.di - this.master.start;
    }

    public void setFrame(int index) {
        this.master.frame = this.start + index;
    }

    public int getFrame() {
        return this.master.frame - this.start;
    }

    public int getLength() {
        return this.master.de - this.master.db;
    }

    public int getTailspace() {
        return this.master.buf.length - this.master.de;
    }

    public int getRemaining() {
        return this.master.de - this.di;
    }

    protected void ensureSpace(int len) {
        int newsize;
        for (newsize = this.master.buf.length; newsize < this.di + len; newsize *= 2) {
        }
        if (newsize > this.master.buf.length) {
            byte[] tmp = new byte[newsize];
            int n = this.master.de;
            if (this.master.buf.length < n) {
                n = this.master.buf.length;
            }
            System.arraycopy(this.master.buf, 0, tmp, 0, n);
            this.master.buf = tmp;
        }
    }

    public void advance(int n) {
        this.di += n;
        if (this.di > this.master.de) {
            this.master.de = this.di;
        }
    }

    public int align(int boundary) {
        int m = boundary - 1;
        int i = this.di - this.master.start;
        int n = (i + m & ~m) - i;
        this.advance(n);
        return n;
    }

    public int align(int boundary, byte value) {
        int n = this.align(boundary);
        this.ensureSpace(n);
        for (int i = n; i > 0; --i) {
            this.master.buf[this.di - i] = value;
        }
        return n;
    }

    public void encodeBytes(byte[] src, int off, int len) throws EncodingException {
        this.ensureSpace(len);
        System.arraycopy(src, off, this.master.buf, this.di, len);
        this.advance(len);
    }

    public void decodeBytes(byte[] dst, int off, int len) throws EncodingException {
        if (this.di + len > this.master.de) {
            throw new EncodingException("Cannot decode beyond the end of the buffer");
        }
        System.arraycopy(this.master.buf, this.di, dst, off, len);
        this.advance(len);
    }

    public void encodeUint8(int u8) {
        this.ensureSpace(1);
        this.master.buf[this.di] = (byte)u8;
        this.advance(1);
    }

    public void encodeUint16le(int u16) {
        this.ensureSpace(2);
        Encdec.enc_uint16le((short)((short)u16), (byte[])this.master.buf, (int)this.di);
        this.advance(2);
    }

    public void encodeUint16be(int u16) {
        this.ensureSpace(2);
        Encdec.enc_uint16be((short)((short)u16), (byte[])this.master.buf, (int)this.di);
        this.advance(2);
    }

    public void encodeUint32le(int u32) {
        this.ensureSpace(4);
        Encdec.enc_uint32le((int)u32, (byte[])this.master.buf, (int)this.di);
        this.advance(4);
    }

    public void encodeUint32be(int u32) {
        this.ensureSpace(4);
        Encdec.enc_uint32be((int)u32, (byte[])this.master.buf, (int)this.di);
        this.advance(4);
    }

    public void encodeUint64le(long u64) {
        this.ensureSpace(8);
        Encdec.enc_uint64le((long)u64, (byte[])this.master.buf, (int)this.di);
        this.advance(8);
    }

    public void encodeUint64be(long u64) {
        this.ensureSpace(8);
        Encdec.enc_uint64be((long)u64, (byte[])this.master.buf, (int)this.di);
        this.advance(8);
    }

    public byte decodeUint8() {
        int u8 = this.master.buf[this.di] & 0xFF;
        this.advance(1);
        return (byte)u8;
    }

    public int decodeUint16le() {
        int u16 = Encdec.dec_uint16le((byte[])this.master.buf, (int)this.di) & 0xFFFF;
        this.advance(2);
        return u16;
    }

    public int decodeUint16be() {
        int u16 = Encdec.dec_uint16be((byte[])this.master.buf, (int)this.di) & 0xFFFF;
        this.advance(2);
        return u16;
    }

    public int decodeUint32le() {
        int u32 = Encdec.dec_uint32le((byte[])this.master.buf, (int)this.di);
        this.advance(4);
        return u32;
    }

    public int decodeUint32be() {
        int u32 = Encdec.dec_uint32be((byte[])this.master.buf, (int)this.di);
        this.advance(4);
        return u32;
    }

    public long decodeUint64le() {
        long u64 = Encdec.dec_uint64le((byte[])this.master.buf, (int)this.di);
        this.advance(8);
        return u64;
    }

    public long decodeUint64be() {
        long u64 = Encdec.dec_uint64be((byte[])this.master.buf, (int)this.di);
        this.advance(8);
        return u64;
    }

    public void compact() {
        if (this.master.db > 0) {
            int off = this.master.db;
            int len = this.master.de - this.master.db;
            if (len > 0) {
                System.arraycopy(this.master.buf, off, this.master.buf, 0, len);
            }
            this.master.start -= off;
            this.master.db = 0;
            this.master.di -= off;
            this.master.de = len;
            this.master.frame -= off;
        }
    }

    public int write(OutputStream out, int index, boolean advance) throws IOException {
        int len = this.start + index - this.master.db;
        if (len > 0) {
            if (out != null) {
                out.write(this.master.buf, this.master.db, len);
            }
            if (advance) {
                this.master.db += len;
            }
        }
        return len;
    }

    public int shift(int index, boolean compact) {
        int len = this.start + index - this.master.db;
        if (len > 0) {
            this.master.db += len;
            if (compact) {
                this.compact();
            }
        }
        return len;
    }

    public int read(InputStream in) throws IOException {
        int len = this.master.buf.length - this.master.de;
        if (len > 0 && (len = in.read(this.master.buf, this.master.de, len)) > 0) {
            this.master.de += len;
        }
        return len;
    }

    public byte[] toByteArray() {
        int size = this.getLength();
        byte[] ret = new byte[size];
        System.arraycopy(this.master.buf, this.start, ret, 0, size);
        return ret;
    }

    public void hexdump(PrintStream out, int index, int len) {
        Hexdump.hexdump((PrintStream)out, (byte[])this.master.buf, (int)(this.start + index), (int)len);
    }

    public String toString() {
        return "start=" + this.master.start + ",db=" + this.master.db + ",di=" + this.di + ",de=" + this.master.de + ",frame=" + this.master.frame;
    }
}

