/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import jcifs.util.Base64;
import jespa.ldap.LdapEntry;
import jespa.ldap.LdapException;
import jespa.ldap.LdapSecurityProvider;
import jespa.security.Account;
import jespa.security.PasswordCredential;
import jespa.security.SecurityPrincipal;
import jespa.security.SecurityProviderException;
import jespa.util.CacheMap;
import jespa.util.LogStream;
import jespa.util.SID;

public class LdapAccount
extends LdapEntry
implements Account {
    static final Object LOCK = new Object();
    static final SecureRandom RANDOM = new SecureRandom();
    static final SID NOSID = new SID(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, 0);
    static final String[] NOMEMBERS = new String[]{null, null};
    static CacheMap<String, SID> sidCache = null;
    static CacheMap<String, String[]> membersCache = null;
    public static String EXPIRES_NEVER = "<never>";
    LogStream log = LogStream.getInstance();

    LdapAccount(LdapSecurityProvider provider, String distinguishedName, Attributes attrs) throws SecurityProviderException {
        super(provider, distinguishedName, attrs);
    }

    public LdapAccount(LdapSecurityProvider provider, String distinguishedName) throws SecurityProviderException {
        this(provider, distinguishedName, new BasicAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SID getGroupSid(String gname) throws SecurityProviderException {
        SID ret;
        block20: {
            SecurityPrincipal p = new SecurityPrincipal(gname);
            int canonicalForm = p.getCanonicalForm();
            String[] attrs = new String[]{"objectSid"};
            ret = NOSID;
            try {
                if (canonicalForm == 1) {
                    ret = (SID)((Object)this.provider.getLdapEntry(gname, null, attrs, false).get("objectSid"));
                    break block20;
                }
                if (canonicalForm == 2 || this.provider.isPossibleAuthority(p.getDomain())) {
                    String dname = (String)this.provider.getProperty("domain.dns.name");
                    String uname = p.getUsername();
                    String cname = (dname + "\\" + uname).toUpperCase();
                    Object object = LOCK;
                    synchronized (object) {
                        if (sidCache == null) {
                            sidCache = new CacheMap("LdapAccount: sidCache", 3600L, 300L);
                        }
                        if ((ret = sidCache.get(cname)) != null) {
                            return ret;
                        }
                    }
                    try {
                        String filter = "(&(|(objectCategory=person)(objectCategory=group))(sAMAccountName=" + LdapSecurityProvider.escapeFilterValue(uname) + "))";
                        LdapEntry gentry = this.provider.getLdapEntry(gname, filter, attrs, false);
                        ret = (SID)((Object)gentry.get("objectSid"));
                    }
                    catch (SecurityProviderException spe) {
                        if (LogStream.level >= 3) {
                            this.log.println("LdapAccount: Failed to retrieve objectSid for " + gname);
                            if (LogStream.level >= 4) {
                                spe.printStackTrace(this.log);
                            }
                        }
                        ret = NOSID;
                    }
                    object = LOCK;
                    synchronized (object) {
                        sidCache.put(cname, ret);
                        break block20;
                    }
                }
                if (canonicalForm == 4) {
                    if (LogStream.level >= 3) {
                        this.log.println("LdapAccount: Invalid group name canonical form for group: " + gname);
                    }
                } else if (LogStream.level >= 3) {
                    this.log.println("LdapAccount: SecurityProvider is not an authority for domain: " + gname);
                }
            }
            catch (SecurityProviderException spe) {
                if (LogStream.level < 3) break block20;
                this.log.println("LdapAccount: Failed to retrieve objectSid for group: " + gname);
                if (LogStream.level < 4) break block20;
                spe.printStackTrace(this.log);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getGroupMembers(String gname) throws SecurityProviderException {
        String[] ret;
        SecurityPrincipal p = new SecurityPrincipal(gname);
        if (p.getCanonicalForm() != 1) {
            throw new SecurityProviderException(0, "Group name must be in DN form");
        }
        gname = gname.toLowerCase();
        Object object = LOCK;
        synchronized (object) {
            if (membersCache == null) {
                membersCache = new CacheMap("LdapAccount: membersCache", 3600L, 300L);
            }
            if ((ret = membersCache.get(gname)) != null) {
                return ret;
            }
        }
        try {
            String[] attrs = new String[]{"objectClass", "gidNumber", "memberUid", "uidNumber"};
            LdapEntry group = this.provider.getLdapEntry(gname, null, attrs, false);
            List list = (List)group.get("memberUid");
            List objectClass = (List)group.get("objectClass");
            if (objectClass.contains("posixAccount")) {
                list.add(0, "");
                list.add(1, (String)group.get("uidNumber"));
            } else if (objectClass.contains("posixGroup")) {
                list.add(0, (String)group.get("gidNumber"));
                list.add(1, "");
            } else {
                throw new SecurityProviderException(0, "Not posixAccount or posixGroup");
            }
            ret = list.toArray(new String[list.size()]);
        }
        catch (SecurityProviderException spe) {
            if (LogStream.level >= 3) {
                this.log.println("LdapAccount: Failed to retrieve group data for " + gname);
                if (LogStream.level >= 4) {
                    spe.printStackTrace(this.log);
                }
            }
            ret = NOMEMBERS;
        }
        object = LOCK;
        synchronized (object) {
            membersCache.put(gname, ret);
        }
        return ret;
    }

    public boolean isMemberOf(String group) throws SecurityProviderException {
        if (LogStream.level >= 4) {
            this.log.println("LdapAccount: isMemberOf(" + group + ")");
        }
        if (group == null || group.trim().length() == 0) {
            if (LogStream.level >= 3) {
                this.log.println("LdapAccount: isMemberOf: Group name is empty string");
            }
            return false;
        }
        String disposition = (String)this.provider.getProperty("ldap.disposition");
        if (disposition.startsWith("ADS")) {
            SID objectSid = this.getGroupSid(group);
            if (objectSid == NOSID) {
                return false;
            }
            if (!this.containsKey("tokenGroups") || !this.containsKey("objectSid")) {
                try {
                    Attributes _tattrs = this.provider.getLdapContext().getAttributes(this.distinguishedName, new String[]{"tokenGroups", "objectSid"});
                    Attribute _attr = _tattrs.remove("tokenGroups");
                    if (_attr == null) {
                        throw new SecurityProviderException(0, "Failed to retrieve tokenGroups");
                    }
                    this._attrs.put(_attr);
                    _attr = _tattrs.remove("objectSid");
                    if (_attr == null) {
                        throw new SecurityProviderException(0, "Failed to retrieve objectSid");
                    }
                    this._attrs.put(_attr);
                }
                catch (NamingException ne) {
                    throw new SecurityProviderException(0, "Failed to retrieve tokenGroups or objectSid", ne);
                }
            }
            List tokenGroups = (List)this.get("tokenGroups");
            SID userObjectSid = (SID)((Object)this.get("objectSid"));
            if (LogStream.level >= 4) {
                this.log.println("LdapAccount: isMemberOf: user[objectSid=" + (Object)((Object)userObjectSid) + ",tokenGroups.size=" + tokenGroups.size() + ",group[objectSid=" + (Object)((Object)objectSid) + "]");
            }
            for (SID sid : tokenGroups) {
                if (!sid.equals((Object)objectSid)) continue;
                return true;
            }
            if (userObjectSid.equals((Object)objectSid)) {
                return true;
            }
        } else {
            if (!(this.containsKey("uid") && this.containsKey("gidNumber") && this.containsKey("uidNumber"))) {
                try {
                    String[] _sattrs = new String[]{"uid", "gidNumber", "uidNumber"};
                    Attributes _tattrs = this.provider.getLdapContext().getAttributes(this.distinguishedName, _sattrs);
                    Attribute _attr = _tattrs.remove("uid");
                    if (_attr == null) {
                        throw new SecurityProviderException(0, "Failed to retrieve uid");
                    }
                    this._attrs.put(_attr);
                    _attr = _tattrs.remove("gidNumber");
                    if (_attr == null) {
                        throw new SecurityProviderException(0, "Failed to retrieve gidNumber");
                    }
                    this._attrs.put(_attr);
                    _attr = _tattrs.remove("uidNumber");
                    if (_attr == null) {
                        throw new SecurityProviderException(0, "Failed to retrieve uidNumber");
                    }
                    this._attrs.put(_attr);
                }
                catch (NamingException ne) {
                    throw new SecurityProviderException(0, "Failed to retrieve attributes", ne);
                }
            }
            String uid = (String)this.get("uid");
            String gidNumber = (String)this.get("gidNumber");
            String uidNumber = (String)this.get("uidNumber");
            String[] members = this.getGroupMembers(group);
            if (LogStream.level >= 4) {
                this.log.println("LdapAccount: isMemberOf: " + this);
            }
            if (gidNumber.equals(members[0])) {
                return true;
            }
            for (int gi = 2; gi < members.length; ++gi) {
                if (LogStream.level >= 4) {
                    this.log.println("LdapAccount: isMemberOf: " + members[gi]);
                }
                if (!uid.equals(members[gi])) continue;
                return true;
            }
            if (uidNumber.equals(members[1])) {
                return true;
            }
            if (LogStream.level >= 4) {
                this.log.println("LdapAccount: isMemberOf: No matches");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object encodePassword(String encoding, char[] password) throws SecurityProviderException {
        try {
            String userPassword = new String(password);
            if (encoding.equals("UNICODEPWD")) {
                return ("\"" + userPassword + "\"").getBytes("UTF-16LE");
            }
            if (!encoding.equals("CLEAR")) {
                if (encoding.equals("MD5") || encoding.equals("SHA") || encoding.equals("SHA256") || encoding.equals("SHA384") || encoding.equals("SHA512")) {
                    String algo = encoding.equals("SHA256") ? "SHA-256" : (encoding.equals("SHA384") ? "SHA-384" : (encoding.equals("SHA512") ? "SHA-512" : encoding));
                    byte[] bytes = userPassword.getBytes("UTF-8");
                    MessageDigest md = MessageDigest.getInstance(algo);
                    md.update(bytes, 0, bytes.length);
                    userPassword = "{" + encoding + "}" + Base64.encode((byte[])md.digest());
                } else if (encoding.equals("SMD5") || encoding.equals("SSHA") || encoding.equals("SSHA256") || encoding.equals("SSHA384") || encoding.equals("SSHA512")) {
                    String algo = encoding.equals("SSHA256") ? "SHA-256" : (encoding.equals("SSHA384") ? "SHA-384" : (encoding.equals("SSHA512") ? "SHA-512" : encoding.substring(1)));
                    byte[] pass = userPassword.getBytes("UTF-8");
                    byte[] salt = new byte[8];
                    SecureRandom secureRandom = RANDOM;
                    synchronized (secureRandom) {
                        RANDOM.nextBytes(salt);
                    }
                    MessageDigest md = MessageDigest.getInstance(algo);
                    md.update(pass);
                    md.update(salt);
                    byte[] hash = md.digest();
                    byte[] tmp = new byte[hash.length + salt.length];
                    System.arraycopy(hash, 0, tmp, 0, hash.length);
                    System.arraycopy(salt, 0, tmp, hash.length, salt.length);
                    userPassword = "{" + encoding + "}" + Base64.encode((byte[])tmp);
                } else {
                    throw new SecurityProviderException(0, "Unsupported password encoding: " + encoding);
                }
            }
            return userPassword;
        }
        catch (GeneralSecurityException gse) {
            throw new SecurityProviderException(0, "Failed to encode password", gse);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SecurityProviderException(0, "Failed to encode password", uee);
        }
    }

    public void setPassword(char[] password) throws SecurityProviderException {
        String encoding;
        String attrname;
        String disposition = (String)this.provider.getProperty("ldap.disposition");
        if (disposition.startsWith("ADS")) {
            attrname = "unicodePwd";
            encoding = "UNICODEPWD";
        } else {
            attrname = "userPassword";
            encoding = (String)this.provider.getProperty("ldap.password.encoding", "SSHA");
        }
        Object value = this.encodePassword(encoding, password);
        try {
            ModificationItem[] tmp = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(attrname, value))};
            InitialLdapContext ilc = this.provider.getLdapContext();
            ilc.modifyAttributes(this.distinguishedName, tmp);
            if (LogStream.level >= 3) {
                this.log.println("LdapAccount: setPassword successful for " + this.distinguishedName);
            }
        }
        catch (NamingException ne) {
            throw new LdapException("Failed to set " + attrname + ": " + this.distinguishedName, ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(char[] curpassword, char[] newpassword) throws SecurityProviderException {
        String disposition = (String)this.provider.getProperty("ldap.disposition");
        if (disposition.startsWith("ADS")) {
            try {
                byte[] unicodePwdOld = (byte[])this.encodePassword("UNICODEPWD", curpassword);
                byte[] unicodePwdNew = (byte[])this.encodePassword("UNICODEPWD", newpassword);
                ModificationItem[] tmp = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("unicodePwd", unicodePwdOld)), new ModificationItem(1, new BasicAttribute("unicodePwd", unicodePwdNew))};
                InitialLdapContext ilc = this.provider.getLdapContext();
                ilc.modifyAttributes(this.distinguishedName, tmp);
            }
            catch (NamingException ne) {
                LdapException le = new LdapException("Failed to set unicodePwd: " + this.distinguishedName, ne);
                if (le.getCode() == 19) {
                    throw new SecurityProviderException(2, "Invalid credentials: " + this.distinguishedName, ne);
                }
                throw le;
            }
        }
        LdapSecurityProvider tmp = new LdapSecurityProvider((Map)this.provider);
        try {
            tmp.setProperty("authority.dns.name", this.provider.getProperty("authority.dns.name"));
            tmp.authenticate(new PasswordCredential(this.distinguishedName, curpassword));
        }
        finally {
            tmp.dispose();
        }
        this.setPassword(newpassword);
        if (LogStream.level >= 3) {
            this.log.println("LdapAccount: changePassword successful for " + this.distinguishedName);
        }
    }
}

