/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import java.util.HashMap;
import jcifs.util.Hexdump;

public class LdapAttrDef {
    public static final int TYPE_STRING = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_BINARY = 3;
    public static final int TYPE_TIME = 4;
    public static final int TYPE_INT32 = 5;
    public static final int TYPE_INT64 = 6;
    public static final int FLAG_UNDEFINED = 2;
    public static final int FLAG_SINGLE_VALUED = 4;
    public static final int FLAG_CASE_EXACT = 8;
    public static final int FLAG_DN = 16;
    public static final int FLAG_PROTECTED = 32;
    public static final int FLAG_CONSTRUCTED = 64;
    public static final int CONV_INT32_X_STRING = 1;
    public static final int CONV_STRING_X_BINARY = 2;
    public static final int CONV_BASE64_X_BINARY = 3;
    public static final int CONV_SID_X_BINARY = 4;
    public static final int CONV_TIME1970M_X_TIMEUTC = 5;
    public static final int CONV_TIME1970M_X_TIME1601 = 6;
    public static final int CONV_HEXSTRING_X_BINARY = 7;
    public static final int CONV_DATESTR_X_TIMEUTC = 8;
    public static final int CONV_DATESTR_X_TIME1601 = 9;
    static final LdapAttrDef B = new LdapAttrDef(3, 0, 3);
    public int type;
    public int flags;
    public int conv;

    public static HashMap getDefaults(String disposition) {
        AttrDefMap ret = new AttrDefMap();
        LdapAttrDef ssv = new LdapAttrDef(1, 4, 0);
        LdapAttrDef tsv = new LdapAttrDef(4, 4, 5);
        LdapAttrDef bsv = new LdapAttrDef(3, 4, 3);
        LdapAttrDef i32sv = new LdapAttrDef(5, 4, 0);
        LdapAttrDef s = new LdapAttrDef(1, 0, 0);
        if (disposition != null && disposition.startsWith("RFC")) {
            ret.put("cn", ssv);
            ret.put("createTimestamp", tsv);
            ret.put("dc", ssv);
            ret.put("distinguishedName", new LdapAttrDef(1, 52, 0));
            ret.put("entryUUID", bsv);
            ret.put("gidNumber", i32sv);
            ret.put("givenName", ssv);
            ret.put("homeDirectory", ssv);
            ret.put("mail", ssv);
            ret.put("modifyTimestamp", tsv);
            ret.put("o", ssv);
            ret.put("objectClass", s);
            ret.put("ou", s);
            ret.put("sn", ssv);
            ret.put("title", ssv);
            ret.put("uidNumber", i32sv);
            ret.put("uid", ssv);
            ret.put("userPassword", new LdapAttrDef(3, 4, 3));
        } else {
            LdapAttrDef b = new LdapAttrDef(3, 0, 3);
            LdapAttrDef i64sv = new LdapAttrDef(6, 4, 0);
            LdapAttrDef ssvd = new LdapAttrDef(1, 20, 0);
            LdapAttrDef t64sv = new LdapAttrDef(4, 4, 6);
            LdapAttrDef sd = new LdapAttrDef(1, 16, 0);
            LdapAttrDef osv = new LdapAttrDef(2, 4, 0);
            ret.put("aNR", ssv);
            ret.put("accountExpires", t64sv);
            ret.put("adminCount", i32sv);
            ret.put("adminDescription", ssv);
            ret.put("adminDisplayName", ssv);
            ret.put("allowedAttributes", s);
            ret.put("allowedAttributesEffective", s);
            ret.put("allowedChildClasses", s);
            ret.put("allowedChildClassesEffective", s);
            ret.put("attributeID", ssv);
            ret.put("attributeSecurityGUID", bsv);
            ret.put("attributeSyntax", ssv);
            ret.put("attributeTypes", s);
            ret.put("auditingPolicy", bsv);
            ret.put("authoritativeDistinguishedName", ssvd);
            ret.put("badPasswordTime", t64sv);
            ret.put("badPwdCount", i32sv);
            ret.put("c", ssv);
            ret.put("canonicalName", s);
            ret.put("cn", ssv);
            ret.put("co", ssv);
            ret.put("codePage", i32sv);
            ret.put("comment", ssv);
            ret.put("company", ssv);
            ret.put("countryCode", i32sv);
            ret.put("createTimeStamp", tsv);
            ret.put("creationTime", t64sv);
            ret.put("dITContentRules", s);
            ret.put("dNSHostName", ssv);
            ret.put("dSCorePropagationData", new LdapAttrDef(4, 0, 5));
            ret.put("dc", ssv);
            ret.put("department", ssv);
            ret.put("description", s);
            ret.put("directReports", sd);
            ret.put("displayName", ssv);
            ret.put("distinguishedName", new LdapAttrDef(1, 52, 0));
            ret.put("dnsHostName", ssv);
            ret.put("entryTTL", i32sv);
            ret.put("extendedAttributeInfo", s);
            ret.put("extendedClassInfo", s);
            ret.put("extensionName", s);
            ret.put("fRSMemberReference", ssvd);
            ret.put("fRSRootPath", ssv);
            ret.put("fRSStagingPath", ssv);
            ret.put("fRSWorkingPath", ssv);
            ret.put("fSMORoleOwner", ssvd);
            ret.put("facsimileTelephoneNumber", ssv);
            ret.put("forceLogoff", t64sv);
            ret.put("fromEntry", new LdapAttrDef(2, 0, 0));
            ret.put("frsComputerReferenceBL", sd);
            ret.put("gPLink", ssv);
            ret.put("givenName", ssv);
            ret.put("groupType", i32sv);
            ret.put("homeDirectory", ssv);
            ret.put("homeDrive", ssv);
            ret.put("homePhone", ssv);
            ret.put("info", ssv);
            ret.put("initials", ssv);
            ret.put("instanceType", i32sv);
            ret.put("ipPhone", ssv);
            ret.put("isCriticalSystemObject", osv);
            ret.put("isMemberOfPartialAttributeSet", osv);
            ret.put("isSingleValued", osv);
            ret.put("l", ssv);
            ret.put("lDAPDisplayName", ssv);
            ret.put("lastLogoff", t64sv);
            ret.put("lastLogon", t64sv);
            ret.put("lastLogonTimestamp", t64sv);
            ret.put("localPolicyFlags", i32sv);
            ret.put("lockOutObservationWindow", t64sv);
            ret.put("lockoutDuration", t64sv);
            ret.put("lockoutThreshold", i32sv);
            ret.put("logonCount", i32sv);
            ret.put("logonHours", bsv);
            ret.put("mail", ssv);
            ret.put("manager", ssvd);
            ret.put("masteredBy", sd);
            ret.put("maxPwdAge", t64sv);
            ret.put("member", sd);
            ret.put("memberOf", sd);
            ret.put("minPwdAge", t64sv);
            ret.put("minPwdLength", i32sv);
            ret.put("mobile", ssv);
            ret.put("modifiedCount", i64sv);
            ret.put("modifiedCountAtLastProm", i64sv);
            ret.put("modifyTimeStamp", tsv);
            ret.put("ms-DS-MachineAccountQuota", i32sv);
            ret.put("msDS-AllUsersTrustQuota", i32sv);
            ret.put("msDS-Approx-Immed-Subordinates", i32sv);
            ret.put("msDS-Auxiliary-Classes", s);
            ret.put("msDS-Behavior-Version", i32sv);
            ret.put("msDS-KeyVersionNumber", i32sv);
            ret.put("msDS-NCReplCursors", s);
            ret.put("msDS-NCReplInboundNeighbors", s);
            ret.put("msDS-NCReplOutboundNeighbors", s);
            ret.put("msDS-PerUserTrustQuota", i32sv);
            ret.put("msDS-PerUserTrustTombstonesQuota", i32sv);
            ret.put("msDS-QuotaEffective", i32sv);
            ret.put("msDS-QuotaUsed", i32sv);
            ret.put("msDS-ReplAttributeMetaData", s);
            ret.put("msDS-ReplValueMetaData", s);
            ret.put("msDS-TopQuotaUsage", s);
            ret.put("msDS-User-Account-Control-Computed", i32sv);
            ret.put("msDs-masteredBy", sd);
            ret.put("nTMixedDomain", i32sv);
            ret.put("nTSecurityDescriptor", bsv);
            ret.put("name", ssv);
            ret.put("nextRid", i32sv);
            ret.put("oMSyntax", i32sv);
            ret.put("objectCategory", ssvd);
            ret.put("objectClass", s);
            ret.put("objectClasses", s);
            ret.put("objectGUID", bsv);
            ret.put("objectSid", new LdapAttrDef(3, 4, 4));
            ret.put("operatingSystem", ssv);
            ret.put("operatingSystemServicePack", ssv);
            ret.put("operatingSystemVersion", ssv);
            ret.put("ou", s);
            ret.put("pager", ssv);
            ret.put("parentGUID", bsv);
            ret.put("physicalDeliveryOfficeName", ssv);
            ret.put("possibleInferiors", s);
            ret.put("postOfficeBox", s);
            ret.put("postalCode", ssv);
            ret.put("primaryGroupID", i32sv);
            ret.put("primaryGroupToken", i32sv);
            ret.put("profilePath", ssv);
            ret.put("pwdHistoryLength", i32sv);
            ret.put("pwdLastSet", t64sv);
            ret.put("pwdProperties", i32sv);
            ret.put("rIDAllocationPool", i64sv);
            ret.put("rIDManagerReference", ssvd);
            ret.put("rIDNextRID", i32sv);
            ret.put("rIDPreviousAllocationPool", i64sv);
            ret.put("rIDSetReferences", sd);
            ret.put("rIDUsedPool", i64sv);
            ret.put("rangeLower", i32sv);
            ret.put("rangeUpper", i32sv);
            ret.put("sAMAccountName", ssv);
            ret.put("sAMAccountType", i32sv);
            ret.put("sDRightsEffective", i32sv);
            ret.put("schemaIDGUID", bsv);
            ret.put("scriptPath", ssv);
            ret.put("searchFlags", i32sv);
            ret.put("serverName", ssv);
            ret.put("serverReferenceBL", sd);
            ret.put("serverState", i32sv);
            ret.put("servicePrincipalName", s);
            ret.put("showInAdvancedViewOnly", osv);
            ret.put("sn", ssv);
            ret.put("st", ssv);
            ret.put("streetAddress", ssv);
            ret.put("structuralObjectClass", s);
            ret.put("subRefs", sd);
            ret.put("subSchemaSubEntry", sd);
            ret.put("subschemaSubentry", sd);
            ret.put("systemFlags", i32sv);
            ret.put("systemOnly", osv);
            ret.put("telephoneNumber", ssv);
            ret.put("title", ssv);
            ret.put("tokenGroups", new LdapAttrDef(3, 64, 4));
            ret.put("tokenGroupsGlobalAndUniversal", b);
            ret.put("tokenGroupsNoGCAcceptable", b);
            ret.put("uASCompat", i32sv);
            ret.put("uSNChanged", i64sv);
            ret.put("uSNCreated", i64sv);
            ret.put("unicodePwd", new LdapAttrDef(3, 68, 0));
            ret.put("userAccountControl", i32sv);
            ret.put("userParameters", ssv);
            ret.put("userPrincipalName", ssv);
            ret.put("userWorkstations", ssv);
            ret.put("wWWHomePage", ssv);
            ret.put("wellKnownObjects", sd);
            ret.put("whenChanged", tsv);
            ret.put("whenCreated", tsv);
            ret.put("configurationNamingContext", ssvd);
            ret.put("currentTime", tsv);
            ret.put("defaultNamingContext", ssvd);
            ret.put("domainControllerFunctionality", i32sv);
            ret.put("domainFunctionality", i32sv);
            ret.put("dsServiceName", ssvd);
            ret.put("forestFunctionality", i32sv);
            ret.put("highestCommittedUSN", i64sv);
            ret.put("isGlobalCatalogReady", osv);
            ret.put("isSynchronized", osv);
            ret.put("ldapServiceName", ssv);
            ret.put("namingContexts", sd);
            ret.put("rootDomainNamingContext", ssvd);
            ret.put("schemaNamingContext", ssvd);
            ret.put("supportedCapabilities", s);
            ret.put("supportedControl", s);
            ret.put("supportedLDAPPolicies", s);
            ret.put("supportedLDAPVersion", new LdapAttrDef(5, 0, 0));
            ret.put("supportedSASLMechanisms", s);
        }
        return ret;
    }

    public LdapAttrDef(int type, int flags, int conv) {
        this.type = type;
        this.flags = flags;
        this.conv = conv;
    }

    public String toString() {
        return "type=" + this.type + ",flags=0x" + Hexdump.toHexString((int)this.flags, (int)2) + ",conv=0x" + Hexdump.toHexString((int)this.conv, (int)2);
    }

    static class AttrDefMap
    extends HashMap {
        AttrDefMap() {
            super(128);
        }

        AttrDefMap(HashMap m) {
            super(m);
        }

        public LdapAttrDef get(Object id) {
            LdapAttrDef ret = (LdapAttrDef)super.get(id);
            if (ret == null) {
                ret = B;
            }
            return ret;
        }

        public String toString() {
            return "{" + this.size() + " entries}";
        }
    }
}

