/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import jcifs.dcerpc.rpc;
import jcifs.util.Base64;
import jcifs.util.Hexdump;
import jespa.ldap.LdapAccount;
import jespa.ldap.LdapAttrDef;
import jespa.ldap.LdapException;
import jespa.ldap.LdapSecurityProvider;
import jespa.security.Account;
import jespa.security.Properties;
import jespa.security.SecurityProviderException;
import jespa.util.Csv;
import jespa.util.LogStream;
import jespa.util.SID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapEntry
extends Properties {
    public static final String[] ALL_ATTRS = Account.ALL_ATTRS;
    LdapSecurityProvider provider;
    String distinguishedName;
    Attributes _attrs;
    Map<String, LdapAttrDef> defs;
    String dateFormat;
    ArrayList ops;
    LogStream log;

    LdapEntry(LdapSecurityProvider provider, String distinguishedName, Attributes attrs) throws SecurityProviderException {
        String base = (String)provider.getProperty("ldap.base");
        int bn = base.length();
        String cdn = LdapSecurityProvider.canonicalizeDn(distinguishedName);
        if ("".equals(distinguishedName)) {
            cdn = "";
        } else {
            if (cdn == null) {
                throw new SecurityProviderException(0, "Invalid distinguishedName: " + distinguishedName);
            }
            int cdnlen = cdn.length();
            if (cdnlen < bn || !cdn.regionMatches(true, cdnlen - bn, base, 0, bn)) {
                cdn = cdn + ',' + base;
            }
        }
        this.provider = provider;
        this.distinguishedName = cdn;
        this._attrs = attrs;
        this.defs = (Map)provider.getProperty("ldap.attributes.definitions", LdapSecurityProvider.DEFAULT_ATTRIBUTE_DEFINITIONS);
        this.dateFormat = (String)provider.getProperty("ldap.attributes.date.format");
        this.ops = null;
        this.log = LogStream.getInstance();
    }

    public LdapEntry(LdapSecurityProvider provider, String distinguishedName) throws SecurityProviderException {
        this(provider, distinguishedName, new BasicAttributes());
    }

    ModificationItem addOp(int op, Object key, Object value) {
        if (this.ops == null) {
            this.ops = new ArrayList();
        }
        ModificationItem mi = new ModificationItem(op, new BasicAttribute((String)key, value));
        this.ops.add(mi);
        return mi;
    }

    int removeOp(Object key, int op, Object value) {
        int ret = -1;
        if (this.ops == null) {
            this.ops = new ArrayList();
        }
        Iterator iter = this.ops.iterator();
        while (iter.hasNext()) {
            ModificationItem mi = (ModificationItem)iter.next();
            Attribute attr = mi.getAttribute();
            if (!key.equals(attr.getID()) || op != -1 && (op != mi.getModificationOp() || !attr.contains(value))) continue;
            iter.remove();
            ret = mi.getModificationOp();
        }
        return ret;
    }

    int removeOps(Object key) {
        return this.removeOp(key, -1, null);
    }

    Object convertToInternal(String key, Object val) {
        block14: {
            if ("9223372036854775807".equals(val) && key.equals("accountExpires")) {
                return LdapAccount.EXPIRES_NEVER;
            }
            LdapAttrDef def = this.defs.get(key);
            if (def != LdapAttrDef.B) {
                try {
                    switch (def.conv) {
                        case 3: {
                            val = Base64.encode((byte[])((byte[])val));
                            break;
                        }
                        case 4: {
                            val = new SID((byte[])val, 0);
                            break;
                        }
                        case 5: 
                        case 8: {
                            String tm = (String)val;
                            int tm_year = Integer.parseInt(tm.substring(0, 4));
                            int tm_mon = Integer.parseInt(tm.substring(4, 6));
                            int tm_mday = Integer.parseInt(tm.substring(6, 8));
                            int tm_hour = Integer.parseInt(tm.substring(8, 10));
                            int tm_min = Integer.parseInt(tm.substring(10, 12));
                            int tm_sec = Integer.parseInt(tm.substring(12, 14));
                            GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                            gc.set(tm_year, tm_mon - 1, tm_mday, tm_hour, tm_min, tm_sec);
                            long millis = gc.getTime().getTime();
                            if (tm.charAt(14) == '.' && tm.length() > 15) {
                                int end = tm.indexOf(90, 15);
                                if (end < 15) {
                                    end = tm.length();
                                }
                                double tm_fsec = Double.parseDouble("0." + tm.substring(15, end));
                                millis += (long)(tm_fsec * 1000.0);
                            }
                            if (def.conv == 8) {
                                SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
                                val = sdf.format(new Date(millis));
                                break;
                            }
                            val = "" + millis;
                            break;
                        }
                        case 6: 
                        case 9: {
                            long t = Long.parseLong(val.toString());
                            t = t / 10000L - 11644473600000L;
                            if (def.conv == 9) {
                                SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
                                val = sdf.format(new Date(t));
                                break;
                            }
                            val = "" + t;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if (LogStream.level < 1) break block14;
                    this.log.println("LDAP: Failed to convert value: " + e.getMessage());
                }
            }
        }
        return val;
    }

    Object convertToExternal(String key, Object val) {
        block13: {
            LdapAttrDef def = this.defs.get(key);
            if (def != LdapAttrDef.B) {
                try {
                    switch (def.conv) {
                        case 3: {
                            val = Base64.decode((String)((String)val));
                            break;
                        }
                        case 4: {
                            val = SID.toByteArray((rpc.sid_t)((SID)((Object)val)));
                            break;
                        }
                        case 5: 
                        case 8: {
                            Date d;
                            SimpleDateFormat sdf;
                            if (def.conv == 8) {
                                sdf = new SimpleDateFormat(this.dateFormat);
                                d = sdf.parse((String)val);
                            } else {
                                long l = Long.parseLong((String)val);
                                d = new Date(l);
                            }
                            sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                            val = sdf.format(d) + ".0Z";
                            break;
                        }
                        case 6: 
                        case 9: {
                            long t;
                            if (def.conv == 9) {
                                SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
                                Date d = sdf.parse((String)val);
                                t = d.getTime();
                            } else {
                                t = Long.parseLong((String)val);
                            }
                            t = (t + 11644473600000L) * 10000L;
                            val = "" + t;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if (LogStream.level < 1) break block13;
                    this.log.println("LDAP: Failed to convert value: " + e.getMessage());
                }
            }
        }
        return val;
    }

    @Override
    public Object getProperty(String name, Object def) throws SecurityProviderException {
        if (this.containsKey(name) || "distinguishedName".equals(name)) {
            return this.get(name);
        }
        return def;
    }

    @Override
    public Object get(Object name) {
        String key;
        block5: {
            key = (String)name;
            LdapAttrDef def = this.defs.get(key);
            if ((def.flags & 4) == 0) {
                return new ValueList(this, key);
            }
            try {
                Attribute attr = this._attrs.get(key);
                if (attr != null) {
                    return this.convertToInternal(key, attr.get());
                }
            }
            catch (NamingException ne) {
                if (LogStream.level < 1) break block5;
                ne.printStackTrace(this.log);
            }
        }
        if (key.equals("distinguishedName")) {
            return this.distinguishedName;
        }
        return null;
    }

    @Override
    public Object put(Object name, Object value) {
        Object ret;
        String key;
        block10: {
            key = (String)name;
            ret = value;
            value = this.convertToExternal(key, value);
            Attribute attr = this._attrs.get(key);
            if (attr != null) {
                LdapAttrDef def = this.defs.get(key);
                if ((def.flags & 4) != 0) {
                    try {
                        if (value.equals(attr.get())) {
                            return ret;
                        }
                    }
                    catch (NamingException ne) {
                        if (LogStream.level < 1) break block10;
                        ne.printStackTrace(this.log);
                    }
                }
            }
        }
        if (LogStream.level >= 3) {
            this.log.println("LdapEntry: ADD: " + key);
        }
        ret = this._attrs.put(key, value);
        int eop = this.removeOps(key);
        int mod_op = 1;
        if (ret != null) {
            if (eop == -1 || eop != 1) {
                mod_op = 2;
            }
        } else if (eop != -1 && eop == 3) {
            mod_op = 2;
        }
        this.addOp(mod_op, key, value);
        return ret;
    }

    @Override
    public Object remove(Object name) {
        if (LogStream.level >= 3) {
            this.log.println("LdapEntry: REMOVE: " + name);
        }
        Attribute ret = this._attrs.remove((String)name);
        int eop = this.removeOps(name);
        if (ret != null) {
            if (eop == -1 || eop == 2) {
                this.addOp(3, name, null);
            }
        } else if (eop != -1) {
            this.addOp(3, name, null);
        }
        return ret;
    }

    private void printModificationItems(PrintStream out, ArrayList mis) throws SecurityProviderException {
        if (mis == null) {
            return;
        }
        try {
            for (ModificationItem mi : mis) {
                String s;
                switch (mi.getModificationOp()) {
                    case 1: {
                        s = "ADD: ";
                        break;
                    }
                    case 2: {
                        s = "REP: ";
                        break;
                    }
                    case 3: {
                        s = "DEL: ";
                        break;
                    }
                    default: {
                        throw new SecurityProviderException(0, "Unknown modification type");
                    }
                }
                Attribute attr = mi.getAttribute();
                s = s + attr.getID() + ": ";
                s = s + attr.get();
                out.println(s);
            }
        }
        catch (NamingException ne) {
            throw new LdapException(ne.getMessage(), ne);
        }
    }

    public void update(String[] attrs) throws SecurityProviderException {
        if (this.ops != null) {
            ArrayList<ModificationItem> updateOps = new ArrayList<ModificationItem>();
            if (attrs == ALL_ATTRS) {
                updateOps.addAll(this.ops);
            } else {
                if (attrs == null) {
                    String disposition = (String)this.provider.getProperty("ldap.disposition");
                    attrs = disposition.startsWith("ADS") ? LdapSecurityProvider.DEFAULT_ATTRIBUTES_ADS : LdapSecurityProvider.DEFAULT_ATTRIBUTES_RFC;
                }
                block2: for (ModificationItem mi : this.ops) {
                    String id = mi.getAttribute().getID();
                    for (int ai = 0; ai < attrs.length; ++ai) {
                        if (!id.equalsIgnoreCase(attrs[ai])) continue;
                        updateOps.add(mi);
                        continue block2;
                    }
                }
            }
            if (LogStream.level >= 3) {
                this.log.println("LdapEntry: UPDATE: " + updateOps);
                if (LogStream.level >= 4) {
                    this.printModificationItems(this.log, updateOps);
                }
            }
            ModificationItem[] tmp = new ModificationItem[updateOps.size()];
            updateOps.toArray(tmp);
            InitialLdapContext ilc = this.provider.getLdapContext();
            try {
                ilc.modifyAttributes(this.distinguishedName, tmp);
                this.ops.removeAll(updateOps);
                if (this.ops.size() == 0) {
                    this.ops = null;
                }
            }
            catch (NamingException ne) {
                throw new LdapException("Update failed: " + this.distinguishedName, ne);
            }
        }
    }

    public void update() throws SecurityProviderException {
        this.update(ALL_ATTRS);
    }

    public void create(String[] attrs) throws SecurityProviderException {
        Attributes createAttrs = new BasicAttributes();
        ArrayList<ModificationItem> createOps = new ArrayList<ModificationItem>();
        if (attrs == ALL_ATTRS) {
            createAttrs = this._attrs;
            createOps.addAll(this.ops);
        } else {
            if (attrs == null) {
                String disposition = (String)this.provider.getProperty("ldap.disposition");
                attrs = disposition.startsWith("ADS") ? LdapSecurityProvider.DEFAULT_ATTRIBUTES_ADS : LdapSecurityProvider.DEFAULT_ATTRIBUTES_RFC;
            }
            block2: for (ModificationItem mi : this.ops) {
                Attribute attr = mi.getAttribute();
                String id = attr.getID();
                for (int ai = 0; ai < attrs.length; ++ai) {
                    if (!id.equalsIgnoreCase(attrs[ai])) continue;
                    createAttrs.put(attr);
                    createOps.add(mi);
                    continue block2;
                }
            }
        }
        if (LogStream.level >= 3) {
            this.log.println("LdapEntry: CREATE: " + this);
            if (LogStream.level >= 4) {
                this.printModificationItems(this.log, createOps);
            }
        }
        InitialLdapContext ilc = this.provider.getLdapContext();
        try {
            ilc.createSubcontext(this.distinguishedName, createAttrs);
            this.ops.removeAll(createOps);
            if (this.ops.size() == 0) {
                this.ops = null;
            }
        }
        catch (NamingException ne) {
            SecurityProviderException se = new LdapException(this.distinguishedName, ne);
            if (se.getCode() == 68) {
                se = new SecurityProviderException(6, "The LDAP entry already exists: " + this.distinguishedName, se);
            }
            throw se;
        }
    }

    public void create() throws SecurityProviderException {
        this.create(ALL_ATTRS);
    }

    public void delete() throws SecurityProviderException {
        if (LogStream.level >= 3) {
            this.log.println("LdapEntry: DELETE: " + this.distinguishedName);
            if (LogStream.level >= 4) {
                this.printModificationItems(this.log, this.ops);
            }
        }
        InitialLdapContext ilc = this.provider.getLdapContext();
        try {
            ilc.destroySubcontext(this.distinguishedName);
        }
        catch (NamingException ne) {
            throw new LdapException("Delete failed: " + this.distinguishedName, ne);
        }
    }

    @Override
    public int size() {
        return this._attrs.size();
    }

    @Override
    public boolean isEmpty() {
        return this._attrs.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._attrs.get((String)key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void putAll(Map m) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void clear() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Set<String> keySet() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Collection<Object> values() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AttributeSet<Map.Entry<String, Object>>(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LdapEntry) {
            LdapEntry e = (LdapEntry)o;
            return e.distinguishedName.equalsIgnoreCase(this.distinguishedName) && this._attrs.equals(e._attrs);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._attrs == null ? 0 : this._attrs.hashCode() * 39916801;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueList<E>
    implements List<E> {
        LdapEntry entry;
        String attrID;

        ValueList(LdapEntry entry, String attrID) {
            this.entry = entry;
            this.attrID = attrID;
        }

        @Override
        public boolean add(E value) {
            this.add(-1, value);
            return true;
        }

        @Override
        public void add(int index, E value) {
            value = LdapEntry.this.convertToExternal(this.attrID, value);
            Attribute attr = this.entry._attrs.get(this.attrID);
            if (attr == null) {
                attr = new BasicAttribute(this.attrID, value);
                this.entry._attrs.put(attr);
            } else if (!attr.contains(value)) {
                if (index < 0) {
                    attr.add(value);
                } else {
                    attr.add(index, value);
                }
            }
            if (this.entry.removeOp(this.attrID, 3, value) == -1) {
                this.entry.addOp(1, this.attrID, value);
            }
        }

        @Override
        public boolean remove(Object value) {
            Attribute attr = this.entry._attrs.get(this.attrID);
            if (attr == null) {
                return false;
            }
            if (!attr.remove(value = LdapEntry.this.convertToExternal(this.attrID, value))) {
                return false;
            }
            if (this.entry.removeOp(this.attrID, 1, value) == -1) {
                this.entry.addOp(3, this.attrID, value);
            }
            return true;
        }

        @Override
        public int size() {
            Attribute attr = this.entry._attrs.get(this.attrID);
            if (attr != null) {
                return attr.size();
            }
            return 0;
        }

        @Override
        public boolean isEmpty() {
            Attribute attr = this.entry._attrs.get(this.attrID);
            return attr == null || attr.size() == 0;
        }

        @Override
        public boolean contains(Object value) {
            Attribute attr = this.entry._attrs.get(this.attrID);
            if (attr != null) {
                value = LdapEntry.this.convertToExternal(this.attrID, value);
                return attr.contains(value);
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new ValueIterator(this.attrID, this.entry._attrs.get(this.attrID));
        }

        @Override
        public Object[] toArray() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            block5: {
                Attribute attr = this.entry._attrs.get(this.attrID);
                if (attr != null) {
                    try {
                        if (a == null || a.length < attr.size()) {
                            a = new Object[attr.size()];
                        }
                        LdapAttrDef def = LdapEntry.this.defs.get(this.attrID);
                        NamingEnumeration<?> en = attr.getAll();
                        int ri = 0;
                        while (en.hasMoreElements()) {
                            a[ri] = def.conv != 0 ? LdapEntry.this.convertToInternal(this.attrID, en.next()) : en.next();
                            ++ri;
                        }
                        return a;
                    }
                    catch (NamingException ne) {
                        LogStream cfr_ignored_0 = LdapEntry.this.log;
                        if (LogStream.level < 1) break block5;
                        ne.printStackTrace(LdapEntry.this.log);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void clear() {
            Attribute attr = this.entry._attrs.get(this.attrID);
            if (attr != null) {
                attr.clear();
            }
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ValueList) {
                ValueList vl = (ValueList)o;
                if (this.attrID.equals(vl.attrID)) {
                    Attribute attr1;
                    Attribute attr0 = this.entry._attrs.get(this.attrID);
                    if (attr0 == (attr1 = vl.entry._attrs.get(vl.attrID))) {
                        return true;
                    }
                    if (attr0 != null) {
                        return attr0.equals(attr1);
                    }
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            Attribute attr = this.entry._attrs.get(this.attrID);
            return attr == null ? 0 : attr.hashCode() * 33;
        }

        @Override
        public E get(int index) {
            block4: {
                try {
                    Attribute attr = this.entry._attrs.get(this.attrID);
                    if (attr != null) {
                        LdapAttrDef def = LdapEntry.this.defs.get(this.attrID);
                        if (def.conv != 0) {
                            return (E)LdapEntry.this.convertToInternal(this.attrID, attr.get(index));
                        }
                        return (E)attr.get(index);
                    }
                }
                catch (NamingException ne) {
                    LogStream cfr_ignored_0 = LdapEntry.this.log;
                    if (LogStream.level < 1) break block4;
                    ne.printStackTrace(LdapEntry.this.log);
                }
            }
            return null;
        }

        @Override
        public E set(int index, E element) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public E remove(int index) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int indexOf(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public ListIterator<E> listIterator() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            throw new RuntimeException("Not implemented");
        }

        public String toString() {
            Attribute attr = this.entry._attrs.get(this.attrID);
            if (attr != null) {
                try {
                    String[] row = new String[attr.size()];
                    LdapAttrDef def = LdapEntry.this.defs.get(this.attrID);
                    NamingEnumeration<?> en = attr.getAll();
                    int ri = 0;
                    while (en.hasMoreElements()) {
                        if (def.conv != 0) {
                            row[ri] = LdapEntry.this.convertToInternal(this.attrID, en.next()).toString();
                        } else {
                            Object o = en.next();
                            if (o instanceof String) {
                                row[ri] = (String)o;
                            } else {
                                byte[] ba = (byte[])o;
                                row[ri] = Hexdump.toHexString((byte[])ba, (int)0, (int)ba.length);
                            }
                        }
                        ++ri;
                    }
                    char[] buf = new char[4096];
                    return "[" + Csv.formatRow(buf, buf.length, row, row.length, ',') + "]";
                }
                catch (IOException ioe) {
                    LogStream cfr_ignored_0 = LdapEntry.this.log;
                    if (LogStream.level >= 1) {
                        ioe.printStackTrace(LdapEntry.this.log);
                    }
                    return "[<IOException: " + ioe.getMessage() + ">]";
                }
                catch (NamingException ne) {
                    LogStream cfr_ignored_1 = LdapEntry.this.log;
                    if (LogStream.level >= 1) {
                        ne.printStackTrace(LdapEntry.this.log);
                    }
                    return "[<NamingException: " + ne.getMessage() + ">]";
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueIterator<E>
    implements Iterator<E> {
        String attrID;
        NamingEnumeration ne = null;

        ValueIterator(String attrID, Attribute attr) {
            this.attrID = attrID;
            if (attr != null) {
                try {
                    this.ne = attr.getAll();
                }
                catch (NamingException _ne) {
                    _ne.printStackTrace(LdapEntry.this.log);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.ne == null ? false : this.ne.hasMoreElements();
        }

        @Override
        public E next() {
            block3: {
                if (this.ne != null) {
                    try {
                        return (E)LdapEntry.this.convertToInternal(this.attrID, this.ne.next());
                    }
                    catch (NamingException _ne) {
                        LogStream cfr_ignored_0 = LdapEntry.this.log;
                        if (LogStream.level < 1) break block3;
                        _ne.printStackTrace(LdapEntry.this.log);
                    }
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AttributeSet<E>
    implements Set<E> {
        LdapEntry entry;

        AttributeSet(LdapEntry entry) {
            this.entry = entry;
        }

        @Override
        public int size() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean isEmpty() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public Iterator<E> iterator() {
            return new AttributeIterator(this.entry, this.entry._attrs.getAll());
        }

        @Override
        public Object[] toArray() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean add(E e) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void clear() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean equals(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int hashCode() {
            throw new RuntimeException("Not implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AttributeIterator<E>
    implements Iterator<E> {
        LdapEntry entry;
        NamingEnumeration ne;
        String id = null;

        AttributeIterator(LdapEntry entry, NamingEnumeration ne) {
            this.entry = entry;
            this.ne = ne;
        }

        @Override
        public boolean hasNext() {
            return this.ne.hasMoreElements();
        }

        @Override
        public E next() {
            try {
                Attribute attr = (Attribute)this.ne.next();
                this.id = attr.getID();
                LdapAttrDef def = LdapEntry.this.defs.get(this.id);
                ValueList val = (def.flags & 4) == 0 ? new ValueList(this.entry, this.id) : attr.get();
                return (E)new AttributeEntry(this.id, val);
            }
            catch (NamingException ne) {
                LogStream cfr_ignored_0 = LdapEntry.this.log;
                if (LogStream.level >= 1) {
                    ne.printStackTrace(LdapEntry.this.log);
                }
                return null;
            }
        }

        @Override
        public void remove() {
            if (this.id != null) {
                this.entry.remove(this.id);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AttributeEntry<K, V>
    implements Map.Entry {
        K key;
        V val;

        AttributeEntry(String key, Object val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            if (this.val instanceof ValueList) {
                return this.val;
            }
            return (V)LdapEntry.this.convertToInternal((String)this.key, this.val);
        }

        public V setValue(Object value) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean equals(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int hashCode() {
            throw new RuntimeException("Not implemented");
        }
    }
}

