/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import javax.naming.NamingException;
import jcifs.util.Hexdump;
import jespa.security.SecurityProviderException;

public class LdapException
extends SecurityProviderException {
    public static final int LDAP_SUCCESS = 0;
    public static final int LDAP_OPERATIONS_ERROR = 1;
    public static final int LDAP_PROTOCOL_ERROR = 2;
    public static final int LDAP_TIMELIMIT_EXCEEDED = 3;
    public static final int LDAP_SIZELIMIT_EXCEEDED = 4;
    public static final int LDAP_COMPARE_FALSE = 5;
    public static final int LDAP_COMPARE_TRUE = 6;
    public static final int LDAP_AUTH_METHOD_NOT_SUPPORTED = 7;
    public static final int LDAP_STRONG_AUTH_REQUIRED = 8;
    public static final int LDAP_PARTIAL_RESULTS = 9;
    public static final int LDAP_REFERRAL = 10;
    public static final int LDAP_ADMINLIMIT_EXCEEDED = 11;
    public static final int LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12;
    public static final int LDAP_CONFIDENTIALITY_REQUIRED = 13;
    public static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    public static final int LDAP_NO_SUCH_ATTRIBUTE = 16;
    public static final int LDAP_UNDEFINED_TYPE = 17;
    public static final int LDAP_INAPPROPRIATE_MATCHING = 18;
    public static final int LDAP_CONSTRAINT_VIOLATION = 19;
    public static final int LDAP_TYPE_OR_VALUE_EXISTS = 20;
    public static final int LDAP_INVALID_SYNTAX = 21;
    public static final int LDAP_NO_SUCH_OBJECT = 32;
    public static final int LDAP_ALIAS_PROBLEM = 33;
    public static final int LDAP_INVALID_DN_SYNTAX = 34;
    public static final int LDAP_IS_LEAF = 35;
    public static final int LDAP_ALIAS_DEREF_PROBLEM = 36;
    public static final int LDAP_PROXY_AUTHZ_FAILURE = 47;
    public static final int LDAP_INAPPROPRIATE_AUTH = 48;
    public static final int LDAP_INVALID_CREDENTIALS = 49;
    public static final int LDAP_INSUFFICIENT_ACCESS = 50;
    public static final int LDAP_BUSY = 51;
    public static final int LDAP_UNAVAILABLE = 52;
    public static final int LDAP_UNWILLING_TO_PERFORM = 53;
    public static final int LDAP_LOOP_DETECT = 54;
    public static final int LDAP_NAMING_VIOLATION = 64;
    public static final int LDAP_OBJECT_CLASS_VIOLATION = 65;
    public static final int LDAP_NOT_ALLOWED_ON_NONLEAF = 66;
    public static final int LDAP_NOT_ALLOWED_ON_RDN = 67;
    public static final int LDAP_ALREADY_EXISTS = 68;
    public static final int LDAP_NO_OBJECT_CLASS_MODS = 69;
    public static final int LDAP_RESULTS_TOO_LARGE = 70;
    public static final int LDAP_AFFECTS_MULTIPLE_DSAS = 71;
    public static final int LDAP_OTHER = 80;
    public static final int LDAP_SERVER_DOWN = 81;
    public static final int LDAP_LOCAL_ERROR = 82;
    public static final int LDAP_ENCODING_ERROR = 83;
    public static final int LDAP_DECODING_ERROR = 84;
    public static final int LDAP_TIMEOUT = 85;
    public static final int LDAP_AUTH_UNKNOWN = 86;
    public static final int LDAP_FILTER_ERROR = 87;
    public static final int LDAP_USER_CANCELLED = 88;
    public static final int LDAP_PARAM_ERROR = 89;
    public static final int LDAP_NO_MEMORY = 90;
    public static final int LDAP_CONNECT_ERROR = 91;
    public static final int LDAP_NOT_SUPPORTED = 92;
    public static final int LDAP_CONTROL_NOT_FOUND = 93;
    public static final int LDAP_NO_RESULTS_RETURNED = 94;
    public static final int LDAP_MORE_RESULTS_TO_RETURN = 95;
    public static final int LDAP_CLIENT_LOOP = 96;
    public static final int LDAP_REFERRAL_LIMIT_EXCEEDED = 97;
    public static final int LDAP_CUP_RESOURCES_EXHAUSTED = 113;
    public static final int LDAP_CUP_SECURITY_VIOLATION = 114;
    public static final int LDAP_CUP_INVALID_DATA = 115;
    public static final int LDAP_CUP_UNSUPPORTED_SCHEME = 116;
    public static final int LDAP_CUP_RELOAD_REQUIRED = 117;
    public static final int LDAP_CANCELLED = 118;
    public static final int LDAP_NO_SUCH_OPERATION = 119;
    public static final int LDAP_TOO_LATE = 120;
    public static final int LDAP_CANNOT_CANCEL = 121;
    public static final int LDAP_ASSERTION_FAILED = 122;
    public static final int LDAP_SYNC_REFRESH_REQUIRED = 4096;
    public static final int LDAP_X_SYNC_REFRESH_REQUIRED = 16640;
    public static final int LDAP_X_NO_OPERATION = 16654;
    public static final int LDAP_X_ASSERTION_FAILED = 16655;
    public static final int LDAP_X_NO_REFERRALS_FOUND = 16656;
    public static final int LDAP_X_CANNOT_CHAIN = 16657;
    static final int[] codes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 32, 33, 34, 35, 36, 47, 48, 49, 50, 51, 52, 53, 54, 64, 65, 66, 67, 68, 69, 70, 71, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 4096, 16640, 16654, 16655, 16656, 16657};
    static final String[] idents = new String[]{"LDAP_SUCCESS", "LDAP_OPERATIONS_ERROR", "LDAP_PROTOCOL_ERROR", "LDAP_TIMELIMIT_EXCEEDED", "LDAP_SIZELIMIT_EXCEEDED", "LDAP_COMPARE_FALSE", "LDAP_COMPARE_TRUE", "LDAP_AUTH_METHOD_NOT_SUPPORTED", "LDAP_STRONG_AUTH_REQUIRED", "LDAP_PARTIAL_RESULTS", "LDAP_REFERRAL", "LDAP_ADMINLIMIT_EXCEEDED", "LDAP_UNAVAILABLE_CRITICAL_EXTENSION", "LDAP_CONFIDENTIALITY_REQUIRED", "LDAP_SASL_BIND_IN_PROGRESS", "LDAP_NO_SUCH_ATTRIBUTE", "LDAP_UNDEFINED_TYPE", "LDAP_INAPPROPRIATE_MATCHING", "LDAP_CONSTRAINT_VIOLATION", "LDAP_TYPE_OR_VALUE_EXISTS", "LDAP_INVALID_SYNTAX", "LDAP_NO_SUCH_OBJECT", "LDAP_ALIAS_PROBLEM", "LDAP_INVALID_DN_SYNTAX", "LDAP_IS_LEAF", "LDAP_ALIAS_DEREF_PROBLEM", "LDAP_PROXY_AUTHZ_FAILURE", "LDAP_INAPPROPRIATE_AUTH", "LDAP_INVALID_CREDENTIALS", "LDAP_INSUFFICIENT_ACCESS", "LDAP_BUSY", "LDAP_UNAVAILABLE", "LDAP_UNWILLING_TO_PERFORM", "LDAP_LOOP_DETECT", "LDAP_NAMING_VIOLATION", "LDAP_OBJECT_CLASS_VIOLATION", "LDAP_NOT_ALLOWED_ON_NONLEAF", "LDAP_NOT_ALLOWED_ON_RDN", "LDAP_ALREADY_EXISTS", "LDAP_NO_OBJECT_CLASS_MODS", "LDAP_RESULTS_TOO_LARGE", "LDAP_AFFECTS_MULTIPLE_DSAS", "LDAP_OTHER", "LDAP_SERVER_DOWN", "LDAP_LOCAL_ERROR", "LDAP_ENCODING_ERROR", "LDAP_DECODING_ERROR", "LDAP_TIMEOUT", "LDAP_AUTH_UNKNOWN", "LDAP_FILTER_ERROR", "LDAP_USER_CANCELLED", "LDAP_PARAM_ERROR", "LDAP_NO_MEMORY", "LDAP_CONNECT_ERROR", "LDAP_NOT_SUPPORTED", "LDAP_CONTROL_NOT_FOUND", "LDAP_NO_RESULTS_RETURNED", "LDAP_MORE_RESULTS_TO_RETURN", "LDAP_CLIENT_LOOP", "LDAP_REFERRAL_LIMIT_EXCEEDED", "LDAP_CUP_RESOURCES_EXHAUSTED", "LDAP_CUP_SECURITY_VIOLATION", "LDAP_CUP_INVALID_DATA", "LDAP_CUP_UNSUPPORTED_SCHEME", "LDAP_CUP_RELOAD_REQUIRED", "LDAP_CANCELLED", "LDAP_NO_SUCH_OPERATION", "LDAP_TOO_LATE", "LDAP_CANNOT_CANCEL", "LDAP_ASSERTION_FAILED", "LDAP_SYNC_REFRESH_REQUIRED", "LDAP_X_SYNC_REFRESH_REQUIRED", "LDAP_X_NO_OPERATION", "LDAP_X_ASSERTION_FAILED", "LDAP_X_NO_REFERRALS_FOUND", "LDAP_X_CANNOT_CHAIN"};

    static int parseJndiStatus(String message) {
        int ei;
        if (message.startsWith("[LDAP: error code ") && (ei = message.indexOf(32, 18)) > 18) {
            try {
                return Integer.parseInt(message.substring(18, ei), 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    static String getIdent(int status) {
        int n = codes.length;
        int base = 0;
        while (n > 0) {
            int pivot = n >>> 1;
            int code = codes[base + pivot];
            if (status < code) {
                n = pivot;
                continue;
            }
            if (status > code) {
                base += ++pivot;
                n -= pivot;
                continue;
            }
            return idents[base + pivot];
        }
        return "0x" + Hexdump.toHexString((int)status, (int)8);
    }

    LdapException(int code, String message) {
        super(code, LdapException.getIdent(code < 0 ? 1 : code) + (message == null ? "" : ": " + message));
    }

    LdapException(int code, String message, Exception cause) {
        super(code, LdapException.getIdent(code < 0 ? 1 : code) + (message == null ? "" : ": " + message), cause);
    }

    LdapException(String message, NamingException cause) {
        this(LdapException.parseJndiStatus(cause.getMessage()), message, cause);
    }
}

