/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import java.io.FileInputStream;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jespa.ldap.LdapAttrDef;
import jespa.ldap.LdapSecurityProvider;
import jespa.security.PasswordCredential;
import jespa.security.RunAs;
import jespa.util.LogStream;

public class LdapSearch
implements PrivilegedExceptionAction {
    Map props;

    LdapSearch(Map props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() throws Exception {
        LogStream log = LogStream.getInstance();
        LdapSecurityProvider lsp = new LdapSecurityProvider(this.props);
        try {
            HashMap attrdefs = (HashMap)lsp.getProperty("ldap.attributes.definitions");
            for (String key : attrdefs.keySet()) {
                LdapAttrDef def = (LdapAttrDef)attrdefs.get(key);
                if (def.conv == 5) {
                    def.conv = 8;
                    continue;
                }
                if (def.conv != 6) continue;
                def.conv = 9;
            }
            lsp.setProperty("ldap.attributes.definitions", attrdefs);
            if (LogStream.level >= 2) {
                System.err.println("Querying server: " + lsp.getProperty("authority.dns.name"));
            }
            List results = lsp.search(null, null);
            for (Map e : results) {
                System.out.println(e.get("distinguishedName") + ":");
                for (Map.Entry a : e.entrySet()) {
                    System.out.println("  " + a.getKey() + ": " + a.getValue());
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            lsp.dispose();
            throw throwable;
        }
        lsp.dispose();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int ai;
        if (args.length < 1) {
            System.err.println("Usage: LdapSearch [-f <propfile>] [-v <level>] [-d ADS|RFC] [-x] [-t] [-a <authtype>] [-u <username> -p <password>] ldap://host/base?attrs?scope?filter");
            System.err.println("  -x  disable SASL integrity / confidentiality");
            System.err.println("  -t  use TLS confidentiality (requires -Djavax.net.ssl.trustStore)");
            System.exit(1);
        }
        Map<String, String> props = new HashMap();
        String loglevel = null;
        String securityAuthentication = null;
        String username = null;
        String password = null;
        for (ai = 0; ai < args.length; ++ai) {
            if (args[ai].equals("-f")) {
                Object var9_8;
                ++ai;
                props = new Properties();
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(args[ai]);
                    ((Properties)props).load(fin);
                    var9_8 = null;
                    if (fin == null) continue;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    if (fin != null) {
                        fin.close();
                    }
                    throw throwable;
                }
                fin.close();
                {
                    continue;
                }
            }
            if (!args[ai].equals("-v")) continue;
            loglevel = args[++ai];
        }
        if (loglevel == null && (loglevel = System.getenv("LOG_LEVEL")) == null && (loglevel = (String)props.get("log.level")) == null) {
            loglevel = "1";
        }
        LogStream.setLevel(Integer.parseInt(loglevel));
        for (ai = 0; ai < args.length; ++ai) {
            String arg = args[ai].trim();
            if (arg.equals("-a")) {
                arg = args[++ai].trim();
                props.put("java.naming.security.authentication", arg);
                securityAuthentication = arg;
                continue;
            }
            if (arg.equals("-d")) {
                arg = args[++ai].trim();
                props.put("ldap.disposition", arg);
                continue;
            }
            if (arg.equals("-u")) {
                arg = args[++ai].trim();
                props.put("service.acctname", arg);
                username = arg;
                continue;
            }
            if (arg.equals("-p")) {
                arg = args[++ai].trim();
                props.put("service.password", arg);
                password = arg;
                continue;
            }
            if (arg.equals("-t")) {
                props.put("flags.confidentiality", "true");
                continue;
            }
            if (arg.equals("-x")) {
                props.put("flags.confidentiality", "false");
                continue;
            }
            props.put("bindstr", arg);
        }
        LdapSearch ls = new LdapSearch(props);
        if ("GSSAPI".equals(securityAuthentication)) {
            HashMap<String, String> options = new HashMap<String, String>();
            PasswordCredential passwordCredential = null;
            if (username != null && password != null) {
                passwordCredential = new PasswordCredential(username, password.toCharArray());
            } else {
                options.put("useTicketCache", "true");
            }
            RunAs.runAs(ls, passwordCredential, "com.sun.security.auth.module.Krb5LoginModule", options);
        } else {
            ls.run();
        }
    }
}

