/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import jcifs.util.Hexdump;
import jespa.License;
import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.ldap.LdapAccount;
import jespa.ldap.LdapAttrDef;
import jespa.ldap.LdapEntry;
import jespa.ldap.LdapException;
import jespa.ldap.LdapUrl;
import jespa.ldap.StartTlsSocketFactory;
import jespa.security.Account;
import jespa.security.JCAProvider;
import jespa.security.PasswordCredential;
import jespa.security.SecurityPrincipal;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.LogStream;

public class LdapSecurityProvider
extends SecurityProvider {
    private static Map<String, String> userMap = new HashMap<String, String>(0);
    private int userLimit = -1;
    static final Map<String, LdapAttrDef> DEFAULT_ATTRIBUTE_DEFINITIONS_ADS = LdapAttrDef.getDefaults("ADS");
    static final Map<String, LdapAttrDef> DEFAULT_ATTRIBUTE_DEFINITIONS_RFC = LdapAttrDef.getDefaults("RFC");
    static final Object DEFAULT_ATTRIBUTE_DEFINITIONS = new Object();
    static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static Map<Thread, LdapSecurityProvider> socketCreators = new HashMap<Thread, LdapSecurityProvider>();
    static final String[] DEFAULT_ATTRIBUTES_ADS = new String[]{"accountExpires", "c", "cn", "co", "company", "countryCode", "createTimeStamp", "department", "description", "directReports", "displayName", "distinguishedName", "employeeID", "employeeNumber", "facsimileTelephoneNumber", "givenName", "homeDirectory", "homeDrive", "homePhone", "info", "initials", "ipPhone", "l", "mail", "manager", "middleName", "mobile", "modifyTimeStamp", "name", "o", "objectCategory", "objectClass", "objectGUID", "objectSid", "pager", "physicalDeliveryOfficeName", "postalCode", "postOfficeBox", "primaryGroupID", "sAMAccountName", "sAMAccountType", "servicePrincipalName", "sn", "st", "street", "streetAddress", "telephoneNumber", "title", "userAccountControl", "userPrincipalName", "whenChanged", "whenCreated", "wWWHomePage"};
    static final String[] DEFAULT_ATTRIBUTES_RFC = new String[]{"cn", "createTimestamp", "dc", "entryUUID", "gidNumber", "givenName", "homeDirectory", "mail", "modifyTimestamp", "o", "objectClass", "ou", "sn", "title", "uid", "uidNumber"};
    static PasswordCredential anonymousPasswordCredential = null;
    InitialLdapContext ldapContext = null;
    LdapAccount account = null;
    LogStream log = LogStream.getInstance();

    public static String escapeFilterValue(String str) {
        char[] str0 = str.toCharArray();
        char[] ret = new char[str0.length * 3];
        int ri = 0;
        block3: for (int si = 0; si < str0.length; ++si) {
            char ch = str0[si];
            switch (ch) {
                default: {
                    ret[ri++] = ch;
                    continue block3;
                }
                case '\u0000': 
                case '(': 
                case ')': 
                case '*': 
                case '/': 
                case '\\': {
                    ret[ri++] = 92;
                    Hexdump.toHexChars((int)ch, (char[])ret, (int)ri, (int)2);
                    ri += 2;
                }
            }
        }
        return new String(ret, 0, ri);
    }

    public static boolean parseDn(String dn, ArrayList keys, ArrayList vals) {
        int ko = 0;
        int vo = 0;
        int state = 1;
        int dlen = dn == null ? 0 : dn.length();
        block5: for (int di = 0; di <= dlen; ++di) {
            char ch = di == dlen ? (char)'\u0000' : dn.charAt(di);
            switch (state) {
                case 1: {
                    if (ch == '=') {
                        if (keys != null) {
                            keys.add(dn.substring(ko, di).trim());
                        }
                        state = 2;
                        vo = di + 1;
                        continue block5;
                    }
                    if (ch == ',' || ch == ';') {
                        return false;
                    }
                    if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == ' ') continue block5;
                    return false;
                }
                case 2: {
                    if (ch == '\\') {
                        state = 3;
                        continue block5;
                    }
                    if (ch == ',' || ch == ';' || ch == '\u0000') {
                        if (vals != null) {
                            vals.add(dn.substring(vo, di).trim());
                        }
                        state = 1;
                        ko = di + 1;
                        continue block5;
                    }
                    if (ch != '=') continue block5;
                    return false;
                }
                case 3: {
                    state = 2;
                }
            }
        }
        return state == 1 && ko > 0;
    }

    public static String canonicalizeDn(String dn) {
        ArrayList keys = new ArrayList();
        ArrayList vals = new ArrayList();
        if (!LdapSecurityProvider.parseDn(dn, keys, vals)) {
            return null;
        }
        String ret = "";
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            ret = ret + "," + keys.get(i) + "=" + vals.get(i);
        }
        return ret.substring(1);
    }

    public static String escapeDnValue(String str) {
        int si;
        String ret = null;
        int slen = str.length();
        int bi = 0;
        block3: for (si = 0; si < slen; ++si) {
            char ch = str.charAt(si);
            switch (ch) {
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    if (ret == null) {
                        ret = str.substring(0, si);
                    } else if (bi < si) {
                        ret = ret + str.substring(bi, si);
                    }
                    ret = ret + "\\" + ch;
                    bi = si + 1;
                    continue block3;
                }
            }
        }
        if (ret == null) {
            return str;
        }
        if (bi < si) {
            ret = ret + str.substring(bi);
        }
        return ret;
    }

    public LdapSecurityProvider(Map properties, String[] pnames) throws SecurityProviderException {
        super(properties, pnames);
        if (LogStream.level >= 4) {
            this.log.println("LdapSecurityProvider: " + properties.get("service.acctname"));
        }
    }

    public LdapSecurityProvider(Map properties) {
        super(properties);
        if (LogStream.level >= 4) {
            this.log.println("LdapSecurityProvider: " + properties.get("service.acctname"));
        }
    }

    public void dispose() throws SecurityProviderException {
        this.remove("service.password.encrypted");
        this.destroyLdapContext(this.ldapContext);
        this.ldapContext = null;
    }

    protected void encodeObject(ByteBuffer bb, Object obj) throws EncodingException {
        if (obj instanceof LdapAccount) {
            LdapAccount acct = (LdapAccount)obj;
            bb.encodeUint16le(20);
            try {
                this.encodeObject(bb, acct.getProperty("distinguishedName"));
            }
            catch (SecurityProviderException se) {
                throw new EncodingException("Failed to encode distinguishedName", se);
            }
            this.encodeObject(bb, acct._attrs);
        } else if (obj instanceof Attributes) {
            Attributes attrs = (Attributes)obj;
            bb.encodeUint16le(21);
            bb.encodeUint16le(attrs.size());
            try {
                NamingEnumeration<? extends Attribute> ne1 = attrs.getAll();
                while (ne1.hasMoreElements()) {
                    Attribute attr = ne1.next();
                    this.encodeObject(bb, attr.getID());
                    bb.encodeUint16le(attr.size());
                    NamingEnumeration<?> ne2 = attr.getAll();
                    while (ne2.hasMoreElements()) {
                        this.encodeObject(bb, ne2.next());
                    }
                    ne2.close();
                }
                ne1.close();
            }
            catch (NamingException ne) {
                throw new EncodingException("Failed to encode Attributes", ne);
            }
        } else if (obj instanceof LdapSecurityProvider) {
            HashMap m = (HashMap)((HashMap)obj).clone();
            m.remove("service.password");
            m.remove("authority.dns.names");
            m.remove("bindstr.url");
            bb.encodeUint16le(22);
            bb.encodeUint16le(m.size());
            for (Object key : m.keySet()) {
                Object val;
                if (key == (val = m.get(key))) {
                    val = DUPLICATE_REFERENCE;
                }
                this.encodeObject(bb, key);
                this.encodeObject(bb, val);
            }
        } else {
            super.encodeObject(bb, obj);
        }
    }

    protected Object decodeObject(ByteBuffer bb) throws EncodingException {
        int start = bb.getIndex();
        int type = bb.decodeUint16le();
        if (type == 20) {
            String distinguishedName = (String)this.decodeObject(bb);
            Attributes attrs = (Attributes)this.decodeObject(bb);
            try {
                return new LdapAccount(this, distinguishedName, attrs);
            }
            catch (SecurityProviderException se) {
                throw new EncodingException("Failed to decode LdapAccount", se);
            }
        }
        if (type == 21) {
            BasicAttributes attrs = new BasicAttributes();
            int len1 = bb.decodeUint16le();
            for (int i1 = 0; i1 < len1; ++i1) {
                String id = (String)this.decodeObject(bb);
                BasicAttribute attr = new BasicAttribute(id);
                int len2 = bb.decodeUint16le();
                for (int i2 = 0; i2 < len2; ++i2) {
                    attr.add(this.decodeObject(bb));
                }
                attrs.put(attr);
            }
            return attrs;
        }
        if (type == 22) {
            int len = bb.decodeUint16le();
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            for (int i = 0; i < len; ++i) {
                Object key = this.decodeObject(bb);
                Object val = this.decodeObject(bb);
                if (val == DUPLICATE_REFERENCE) {
                    val = key;
                }
                m.put(key, val);
            }
            return m;
        }
        bb.setIndex(start);
        return super.decodeObject(bb);
    }

    public Object exportState() throws SecurityProviderException {
        try {
            ByteBuffer bb = new ByteBuffer();
            this.encodeObject(bb, this.identity);
            this.encodeObject(bb, this.account);
            this.encodeObject(bb, this);
            return bb.getBuffer();
        }
        catch (EncodingException ee) {
            throw new SecurityProviderException(0, "Failed to export state", ee);
        }
    }

    public void importState(Object ostate) throws SecurityProviderException {
        byte[] bytes;
        if (ostate != null && (bytes = (byte[])ostate).length > 0) {
            try {
                ByteBuffer bb = new ByteBuffer(bytes, 0, bytes.length);
                this.identity = (String)this.decodeObject(bb);
                this.account = (LdapAccount)this.decodeObject(bb);
                HashMap m = (HashMap)this.decodeObject(bb);
                this.putAll(m);
                return;
            }
            catch (EncodingException ee) {
                throw new SecurityProviderException(0, "Failed to import state", ee);
            }
        }
        throw new SecurityProviderException(0, "Failed to import state");
    }

    private boolean isDotQuadIP(String hostname) {
        if (Character.isDigit(hostname.charAt(0))) {
            int dots = 0;
            int i = 0;
            int len = hostname.length();
            char[] data = hostname.toCharArray();
            while (i < len && Character.isDigit(data[i++])) {
                if (i == len && dots == 3) {
                    return true;
                }
                if (i >= len || data[i] != '.') continue;
                ++dots;
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InitialLdapContext createInitialLdapContext(Hashtable env, Control[] ctls) throws SecurityProviderException {
        InitialLdapContext ctx;
        boolean useLdaps;
        boolean useStartTls;
        String url = (String)env.get("java.naming.provider.url");
        if (LogStream.level >= 3) {
            this.log.println("LdapSecurityProvider: Connecting to " + url);
        }
        boolean bl = useStartTls = !(useLdaps = url.regionMatches(true, 0, "ldaps://", 0, 8)) && this.getFlag("confidentiality");
        if (env.get("java.naming.ldap.factory.socket") == null) {
            env.put("java.naming.ldap.factory.socket", useLdaps ? "jespa.ldap.StartTlsSocketFactory" : "jespa.ldap.LdapSocketFactory");
        }
        Thread caller = Thread.currentThread();
        Map<Thread, LdapSecurityProvider> map = socketCreators;
        synchronized (map) {
            socketCreators.put(caller, this);
        }
        try {
            ctx = new InitialLdapContext(env, ctls);
            if (useStartTls) {
                if (LogStream.level >= 4) {
                    this.log.println("LdapSecurityProvider: Negotiating START_TLS");
                }
                Object ssf = null;
                String ltsc = (String)this.getProperty("ldap.tls.sslsocketfactory.classname", null);
                if (ltsc != null) {
                    if (LogStream.level >= 4) {
                        this.log.println("LdapSecurityProvider: Using custom SSLSocketFactory for START_TLS: " + ltsc);
                    }
                    Method m = Class.forName(ltsc).getDeclaredMethod("getDefault", new Class[0]);
                    ssf = (SSLSocketFactory)m.invoke(null, new Object[0]);
                }
                if (ssf == null) {
                    ssf = (SSLSocketFactory)StartTlsSocketFactory.getDefault();
                }
                StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                tls.negotiate((SSLSocketFactory)ssf);
            }
        }
        catch (Exception e) {
            throw new SecurityProviderException(0, "Failed to create InitialLdapContext", e);
        }
        finally {
            Map<Thread, LdapSecurityProvider> map2 = socketCreators;
            synchronized (map2) {
                socketCreators.remove(caller);
            }
        }
        return ctx;
    }

    private void destroyLdapContext(InitialLdapContext ctx) {
        block3: {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    if (LogStream.level < 2) break block3;
                    ne.printStackTrace(this.log);
                }
            }
        }
    }

    private String getSecurityAuthentication(PasswordCredential cred, Hashtable env) throws SecurityProviderException {
        if (cred == anonymousPasswordCredential) {
            return "none";
        }
        String securityAuthentication = (String)this.getProperty("java.naming.security.authentication", null);
        if (securityAuthentication == null) {
            String disposition = (String)this.getProperty("ldap.disposition");
            securityAuthentication = disposition.startsWith("RFC") ? "simple" : "GSS-SPNEGO/JESPA";
            String _acctname = (String)env.get("jespa.service.acctname");
            if (_acctname == null || _acctname.trim().length() == 0) {
                securityAuthentication = "none";
            }
        } else if (LogStream.level >= 4 && securityAuthentication.equals("GSSAPI")) {
            this.log.println("LdapSecurityProvider: WARNING: GSSAPI authentication may fail if no DNS PTR record exists for the selected KDC");
        }
        return securityAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InitialLdapContext createLdapContext(PasswordCredential cred, boolean overwriteServiceProperties) throws SecurityProviderException {
        block87: {
            block89: {
                block90: {
                    block88: {
                        if (LogStream.level >= 4) {
                            this.log.println("LdapSecurityProvider: createLdapContext: " + this);
                        }
                        lurl = (LdapUrl)this.getProperty("bindstr.url");
                        env = new Hashtable<String, V>();
                        scheme = lurl.getScheme();
                        securityAuthentication = null;
                        securityPrincipal = null;
                        password = null;
                        passwordPropertyName = "jespa.service.password";
                        subject = null;
                        for (String key : this.keySet()) {
                            if (key.startsWith("java.naming.") || key.startsWith("com.sun.jndi.")) {
                                if (key.equals("java.naming.security.authentication") || key.equals("java.naming.security.principal") || key.equals("java.naming.security.credentials")) continue;
                                env.put(key, this.get(key));
                                continue;
                            }
                            if (key.equals("flags.confidentiality") || key.equals("flags.integrity")) continue;
                            env.put("jespa." + key, this.get(key));
                        }
                        securityAuthentication = this.getSecurityAuthentication(cred, env);
                        if (cred == LdapSecurityProvider.anonymousPasswordCredential) break block87;
                        if (cred == null) break block88;
                        securityPrincipal = cred.getSecurityPrincipal();
                        cpass = cred.getPassword();
                        if (cpass == null) {
                            throw new SecurityProviderException(2, "Password cannot be null");
                        }
                        password = new String(cpass);
                        break block89;
                    }
                    _cred = null;
                    subject = Subject.getSubject(AccessController.getContext());
                    if (subject != null && (_iter = subject.getPrivateCredentials(PasswordCredential.class).iterator()).hasNext()) {
                        _cred = _iter.next();
                    }
                    if (_cred == null) break block90;
                    securityPrincipal = _cred.getSecurityPrincipal();
                    if (_cred.getPassword() == null) {
                        throw new SecurityProviderException(2, "Password cannot be null");
                    }
                    password = new String(_cred.getPassword());
                    break block89;
                }
                _acctname = null;
                if (securityAuthentication.equals("simple")) {
                    _acctname = (String)env.get("jespa.service.acctname");
                    if (_acctname == null || _acctname.trim().length() == 0) {
                        throw new SecurityProviderException(0, "If the authentication mechanism is \"simple\", the service.acctname property is required");
                    }
                    if (new SecurityPrincipal(_acctname).getCanonicalForm() != 1) {
                        throw new SecurityProviderException(0, "If the authentication mechanism is \"simple\", the service.acctname property must be in DN form: " + _acctname);
                    }
                    password = (String)this.getProperty("service.password", null);
                } else if (securityAuthentication.equals("GSS-SPNEGO/JESPA")) {
                    _acctname = (String)env.get("jespa.service.acctname");
                    passwordPropertyName = "jespa.service.password.encrypted";
                    password = (String)env.get(passwordPropertyName);
                }
                if (subject != null) ** GOTO lbl-1000
                if (_acctname == null) ** GOTO lbl60
                if (password == null) {
lbl60:
                    // 2 sources

                    if (LogStream.level >= 3) {
                        this.log.println("LdapSecurityProvider: No credentials found, falling back to anonymous authentication");
                    }
                    securityAuthentication = "none";
                    password = null;
                } else if (_acctname != null) {
                    securityPrincipal = new SecurityPrincipal(_acctname);
                }
            }
            canonicalForm = (int)this.getPropertyAsLong("account.canonicalForm", 0L);
            if (canonicalForm != 0 && securityPrincipal != null && !this.isPossibleAuthority(securityPrincipal.getDomain())) {
                throw new SecurityProviderException(1, "SecurityProvider is not an authority for domain: " + securityPrincipal.getDomain());
            }
            if (securityAuthentication.equals("simple")) {
                if (password.length() == 0) {
                    throw new SecurityProviderException(2, "When using a \"simple\" bind, the password cannot be empty");
                }
                _acctname = securityPrincipal.getName();
                _acct = null;
                if (securityPrincipal.getCanonicalForm() != 1) {
                    _disposition = (String)this.getProperty("ldap.disposition");
                    if (_disposition.startsWith("ADS")) {
                        _acct = (LdapAccount)this.getAccount(_acctname, new String[]{"sAMAccountName"});
                        _acctname = _acct.getProperty("sAMAccountName") + "@" + this.getProperty("domain.dns.name");
                    } else {
                        _acct = (LdapAccount)this.getAccount(_acctname, new String[]{"distinguishedName"});
                        _acctname = (String)_acct.getProperty("distinguishedName");
                    }
                    securityPrincipal = new SecurityPrincipal(_acctname);
                }
            }
        }
        useSaslConf = true;
        useStartTls = false;
        if (this.containsKey("flags.confidentiality")) {
            if (this.getFlag("confidentiality")) {
                useSaslConf = false;
                useStartTls = true;
            } else {
                useSaslConf = false;
                useStartTls = false;
            }
        }
        if (useStartTls || !useSaslConf || scheme.equalsIgnoreCase("ldaps")) {
            env.put("jespa.flags.integrity", "false");
            env.put("jespa.flags.confidentiality", "false");
            useStartTls = useStartTls != false && useSaslConf == false && scheme.equalsIgnoreCase("ldaps") == false;
        }
        if (LogStream.level >= 4) {
            this.log.println("LdapSecurityProvider: useStartTls=" + useStartTls + ",SECURITY_AUTHENTICATION=" + securityAuthentication);
        }
        if ((port = lurl.getPort()) == 389 && scheme.equalsIgnoreCase("ldap")) {
            port = 0;
        }
        if (port == 636 && scheme.equalsIgnoreCase("ldaps")) {
            port = 0;
        }
        if (!env.containsKey("java.naming.factory.initial")) {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (!env.containsKey("java.naming.ldap.derefAliases")) {
            env.put("java.naming.ldap.derefAliases", "never");
        }
        if (!env.containsKey("java.naming.ldap.attributes.binary")) {
            battrs = "";
            attrdefs = (HashMap)this.getProperty("ldap.attributes.definitions");
            for (Map.Entry<K, V> e : attrdefs.entrySet()) {
                def = (LdapAttrDef)e.getValue();
                isBinary = def.type == 3;
                switch (def.conv) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: {
                        isBinary = true;
                        break;
                    }
                }
                if (!isBinary) continue;
                battrs = battrs + " " + (String)e.getKey();
            }
            if (battrs.length() > 0) {
                env.put("java.naming.ldap.attributes.binary", battrs.substring(1));
            }
        }
        _e = null;
        while (true) {
            block91: {
                retryNoSites = false;
                name = (String)this.getProperty("bindstr.host");
                names = new String[]{name};
                si = 0;
                isDotQuadIP = this.isDotQuadIP(name);
                if (!isDotQuadIP) {
                    names = null;
                    try {
                        names = (String[])this.getProperty("authority.dns.names");
                        name = (String)this.get("authority.dns.name");
                        if (name != null) {
                            for (ni = 0; ni < names.length; ++ni) {
                                if (!names[ni].equalsIgnoreCase(name)) continue;
                                si = ni;
                                break;
                            }
                            name = null;
                        }
                    }
                    catch (SecurityProviderException spe) {
                        dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L);
                        if ((dcaps & 4L) != 4L || !this.containsKey("dns.site")) {
                            throw spe;
                        }
                        if (LogStream.level >= 2) {
                            if (LogStream.level >= 3) {
                                spe.printStackTrace(this.log);
                            }
                            this.log.println("LdapSecurityProvider: Failed to retrieve names, retrying SRV lookup with no dns.site");
                        }
                        retryNoSites = true;
                    }
                }
                if (names == null) break block91;
                if (Security.getProvider("Jespa") == null) {
                    Security.addProvider(new JCAProvider());
                    if (LogStream.level >= 3) {
                        this.log.println("LdapSecurityProvider: Installed jespa.security.JCAProvider for NTLMSSP SASL client");
                    }
                }
                ctx = null;
                for (ni = 0; ni < names.length; ++ni) {
                    block86: {
                        block84: {
                            block85: {
                                try {
                                    try {
                                        name = names[(ni + si) % names.length];
                                        url = scheme + "://" + name;
                                        if (port > 0) {
                                            url = url + ":" + port;
                                        }
                                        env.put("java.naming.provider.url", url);
                                        ctx = this.createInitialLdapContext(env, null);
                                        if (securityAuthentication.equals("none")) {
                                            if (!env.containsKey("java.naming.referral")) {
                                                ctx.addToEnvironment("java.naming.referral", "follow");
                                            }
                                        } else if (securityAuthentication.equals("simple")) {
                                            ctx.addToEnvironment("java.naming.security.principal", securityPrincipal.getName());
                                            ctx.addToEnvironment("java.naming.security.credentials", password);
                                        } else if (!securityAuthentication.equals("GSSAPI")) {
                                            ctx.addToEnvironment("jespa.service.acctname", securityPrincipal.getName());
                                            ctx.addToEnvironment(passwordPropertyName, password);
                                        }
                                        if (overwriteServiceProperties) {
                                            this.setProperty("service.acctname", securityPrincipal.getName());
                                            this.setProperty(passwordPropertyName.substring(6), password);
                                        }
                                        ctx.addToEnvironment("java.naming.security.authentication", securityAuthentication);
                                        if (LogStream.level >= 4) {
                                            this.log.println("LdapSecurityProvider: securityAuthentication=" + securityAuthentication + ",securityPrincipal=" + securityPrincipal + ",cred=" + cred);
                                        }
                                        this.put("authority.dns.name", name);
                                        if (LogStream.level >= 4) {
                                            estr = ctx.getEnvironment().toString();
                                            pass = (String)this.getProperty("service.password", null);
                                            if (pass != null) {
                                                estr = estr.replace(pass, "********");
                                            }
                                            this.log.println("LdapSecurityProvider: Context created: " + (String)estr);
                                        }
                                        estr = ctx;
                                        var28_39 = null;
                                        if (_e == null) break block84;
                                        break block85;
                                    }
                                    catch (AuthenticationException ae) {
                                        msg = null;
                                        t /* !! */  = ae;
                                        do {
                                            msg = t /* !! */ .getMessage();
                                        } while ((t /* !! */  = t /* !! */ .getCause()) != null);
                                        status = LdapException.parseJndiStatus(msg);
                                        if (status > 0) {
                                            msg = LdapException.getIdent(status) + ": " + msg;
                                        }
                                        _e = new SecurityProviderException(2, msg, ae);
                                        var28_39 = null;
                                        if (_e != null) {
                                            if (LogStream.level >= 3) {
                                                _e.printStackTrace(this.log);
                                            }
                                            _e = null;
                                        }
                                        if (ni + 1 != names.length) break block86;
                                        ni = names.length;
                                        if (!isDotQuadIP && ((dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L)) & 4L) == 4L && this.containsKey("dns.site")) {
                                            if (LogStream.level >= 2) {
                                                this.log.println("LdapSecurityProvider: Failed to connect with any servers, retrying SRV lookup with no dns.site");
                                            }
                                            retryNoSites = true;
                                        }
                                        break block86;
                                    }
                                    catch (NamingException ne) {
                                        _e = ne;
                                        var28_39 = null;
                                        if (_e != null) {
                                            if (LogStream.level >= 3) {
                                                _e.printStackTrace(this.log);
                                            }
                                            _e = null;
                                        }
                                        if (ni + 1 != names.length) break block86;
                                        ni = names.length;
                                        if (isDotQuadIP || ((dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L)) & 4L) != 4L || !this.containsKey("dns.site")) break block86;
                                        if (LogStream.level >= 2) {
                                            this.log.println("LdapSecurityProvider: Failed to connect with any servers, retrying SRV lookup with no dns.site");
                                        }
                                        retryNoSites = true;
                                        break block86;
                                    }
lbl257:
                                    // 2 sources

                                    return estr;
                                }
                                catch (Throwable var27_41) {
                                    var28_39 = null;
                                    if (_e != null) {
                                        if (LogStream.level >= 3) {
                                            _e.printStackTrace(this.log);
                                        }
                                        _e = null;
                                    }
                                    if (ni + 1 != names.length) throw var27_41;
                                    ni = names.length;
                                    if (isDotQuadIP || ((dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L)) & 4L) != 4L || !this.containsKey("dns.site")) throw var27_41;
                                    if (LogStream.level >= 2) {
                                        this.log.println("LdapSecurityProvider: Failed to connect with any servers, retrying SRV lookup with no dns.site");
                                    }
                                    retryNoSites = true;
                                    throw var27_41;
                                }
                            }
                            if (LogStream.level >= 3) {
                                _e.printStackTrace(this.log);
                            }
                            _e = null;
                        }
                        if (ni + 1 != names.length) ** GOTO lbl257
                        ni = names.length;
                        if (isDotQuadIP || ((dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L)) & 4L) != 4L || !this.containsKey("dns.site")) ** GOTO lbl257
                        if (LogStream.level >= 2) {
                            this.log.println("LdapSecurityProvider: Failed to connect with any servers, retrying SRV lookup with no dns.site");
                        }
                        retryNoSites = true;
                        return estr;
                    }
                    this.destroyLdapContext(ctx);
                }
            }
            if (!retryNoSites) {
                if (_e != null) break;
                throw new SecurityProviderException(0, "Failed to bind server");
            }
            dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L);
            this.setProperty("dns.server.capabilities", "0x" + Hexdump.toHexString((long)(dcaps & -5L), (int)8));
            this.remove("authority.dns.names");
        }
        if (_e instanceof SecurityProviderException) {
            throw (SecurityProviderException)_e;
        }
        if (!(_e instanceof NamingException)) throw new SecurityProviderException(0, "Failed to bind server", _e);
        throw new LdapException("Bind failed", (NamingException)_e);
    }

    InitialLdapContext getLdapContext() throws SecurityProviderException {
        if (this.ldapContext == null) {
            this.ldapContext = this.createLdapContext(null, false);
        }
        return this.ldapContext;
    }

    public Object put(Object name, Object value) {
        String _key = (String)name;
        if (_key.equals("ldap.attributes.definitions") && !(value instanceof LdapAttrDef.AttrDefMap)) {
            value = new LdapAttrDef.AttrDefMap((HashMap)value);
        }
        return super.put(_key, value);
    }

    public Object getProperty(String name, Object def) throws SecurityProviderException {
        Object ret;
        String disposition;
        if (name.equals("dns.server.capabilities") && !this.containsKey("dns.server.capabilities") && (disposition = (String)this.getProperty("ldap.disposition", null)) != null && disposition.startsWith("RFC")) {
            this.setProperty(name, "0x" + Hexdump.toHexString((long)1L, (int)4));
        }
        if ((ret = super.getProperty(name, NO_PROPERTY)) == NO_PROPERTY) {
            if (name.equals("ldap.disposition")) {
                return "ADS2003";
            }
            if (name.equals("ldap.context")) {
                return this.getLdapContext();
            }
            if (name.equals("authority.dns.name")) {
                this.getLdapContext();
                ret = (String)this.get("authority.dns.name");
            } else if (name.equals("ldap.base")) {
                ret = super.getProperty("bindstr.base", NO_PROPERTY);
                if (ret == NO_PROPERTY || "RootDSE".equalsIgnoreCase((String)ret)) {
                    ret = "";
                } else if ("DefaultNamingContext".equalsIgnoreCase((String)ret)) {
                    ret = null;
                    InitialLdapContext ctx = this.createLdapContext(anonymousPasswordCredential, false);
                    try {
                        block32: {
                            try {
                                Attribute attr;
                                Attributes attrs = ctx.getAttributes(ctx.getNameInNamespace(), new String[]{"defaultNamingContext"});
                                if (attrs == null || (attr = attrs.get("defaultNamingContext")) == null) break block32;
                                ret = attr.toString().substring(22);
                                this.put(name, ret);
                            }
                            catch (NamingException ne) {
                                throw new LdapException("Failed to retrieve defaultNamingContext", ne);
                            }
                        }
                        Object var8_11 = null;
                        this.destroyLdapContext(ctx);
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        this.destroyLdapContext(ctx);
                        throw throwable;
                    }
                    if (ret == null) {
                        throw new SecurityProviderException(0, "Failed to retrieve defaultNamingContext");
                    }
                }
            } else if (name.equals("ldap.attributes.definitions")) {
                String disposition2 = (String)this.getProperty("ldap.disposition");
                if (disposition2 != null && disposition2.startsWith("RFC")) {
                    if (def == DEFAULT_ATTRIBUTE_DEFINITIONS) {
                        ret = DEFAULT_ATTRIBUTE_DEFINITIONS_RFC;
                    } else if (def == null || def == NO_PROPERTY) {
                        ret = LdapAttrDef.getDefaults("RFC");
                    }
                } else if (def == DEFAULT_ATTRIBUTE_DEFINITIONS) {
                    ret = DEFAULT_ATTRIBUTE_DEFINITIONS_ADS;
                } else if (def == null || def == NO_PROPERTY) {
                    ret = LdapAttrDef.getDefaults("ADS");
                }
            } else if (name.equals("ldap.attributes.date.format")) {
                ret = DEFAULT_DATE_FORMAT;
            } else if (name.equals("ldap.account.filter")) {
                String aname = (String)this.getProperty("ldap.account.attrname");
                ret = "(&(objectClass=posixAccount)(" + aname + "=%s))";
            } else if (name.equals("ldap.account.attrname")) {
                String disposition3 = (String)this.getProperty("ldap.disposition");
                Object object = ret = disposition3.startsWith("ADS") ? "sAMAccountName" : "uid";
            }
        }
        if (ret == NO_PROPERTY) {
            return def;
        }
        return ret;
    }

    private NamingEnumeration _search(String base, String[] attrs, String filter, int scope, long countlim) throws SecurityProviderException, NamingException {
        LdapUrl lurl = (LdapUrl)this.getProperty("bindstr.url");
        if (base == null) {
            base = (String)this.getProperty("ldap.base");
        }
        if (attrs == null) {
            attrs = lurl.getAttributes();
        }
        if (filter == null) {
            filter = lurl.getFilter();
        }
        if (filter == null) {
            filter = "(objectClass=*)";
        }
        if (scope < 0) {
            scope = lurl.getScope();
        }
        if (countlim < 1L) {
            countlim = this.getPropertyAsLong("ldap.search.maxcount", 1000L);
        }
        SearchControls ctls = new SearchControls(scope, countlim, (int)this.getPropertyAsLong("ldap.search.timeout", 60000L), attrs == Account.ALL_ATTRS ? null : attrs, false, false);
        if (LogStream.level >= 4) {
            this.log.println("LdapSecurityProvider: Searching " + base + " with filter " + filter);
        }
        return this.getLdapContext().search(base, filter, ctls);
    }

    public List search(String[] attrs, String filter) throws SecurityProviderException {
        try {
            NamingEnumeration result = this._search(null, attrs, filter, -1, 0L);
            return new EntryList(this, result);
        }
        catch (NamingException ne) {
            throw new LdapException(ne.getMessage(), ne);
        }
    }

    private boolean isAttrsConstructed(String[] attrs) throws SecurityProviderException {
        if (attrs != null) {
            HashMap attrdefs = (HashMap)this.getProperty("ldap.attributes.definitions");
            for (int ai = 0; ai < attrs.length; ++ai) {
                LdapAttrDef def = (LdapAttrDef)attrdefs.get(attrs[ai]);
                if ((def.flags & 0x40) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private SearchResult _searchLdapEntry(String name, String filter, String[] attrs, boolean isAccount) throws NamingException, SecurityProviderException {
        NamingEnumeration result = this._search(null, attrs, filter, 2, 1L);
        if (result.hasMoreElements()) {
            return (SearchResult)result.next();
        }
        if (isAccount) {
            throw new SecurityProviderException(1, "Account not found: " + name);
        }
        throw new SecurityProviderException(5, "Entry not found: " + name);
    }

    LdapEntry getLdapEntry(String name, String filter, String[] attrs, boolean isAccount) throws SecurityProviderException {
        if (name == null) {
            throw new SecurityProviderException(0, "Name cannot be null");
        }
        try {
            String distinguishedName = null;
            Attributes _attrs = null;
            ArrayList keys = new ArrayList();
            ArrayList vals = new ArrayList();
            if (name.trim().length() == 0) {
                distinguishedName = "";
            } else if (LdapSecurityProvider.parseDn(name, keys, vals)) {
                distinguishedName = "";
                int size = keys.size();
                for (int i = 0; i < size; ++i) {
                    distinguishedName = distinguishedName + "," + keys.get(i) + "=" + vals.get(i);
                }
                distinguishedName = distinguishedName.substring(1);
                if (vals.size() == 1) {
                    String base = (String)this.getProperty("ldap.base");
                    int bn = base.length();
                    int dn = distinguishedName.length();
                    if (dn < bn && !distinguishedName.regionMatches(true, dn - bn, base, 0, bn)) {
                        distinguishedName = distinguishedName + ',' + base;
                    }
                }
            } else if (filter == null) {
                throw new SecurityProviderException(0, "Entry key must be DN or RDN relative to base supplied in bindstr");
            }
            if (distinguishedName == null && this.isAttrsConstructed(attrs)) {
                SearchResult entry = this._searchLdapEntry(name, filter, new String[]{"distinguishedName"}, isAccount);
                distinguishedName = entry.getNameInNamespace();
            }
            if (distinguishedName == null) {
                SearchResult entry = this._searchLdapEntry(name, filter, attrs, isAccount);
                distinguishedName = entry.getNameInNamespace();
                _attrs = entry.getAttributes();
            } else {
                _attrs = this.getLdapContext().getAttributes(distinguishedName, attrs == Account.ALL_ATTRS ? null : attrs);
            }
            return isAccount ? new LdapAccount(this, distinguishedName, _attrs) : new LdapEntry(this, distinguishedName, _attrs);
        }
        catch (NamingException ne) {
            throw new LdapException("Failed to retrieve entry: " + name, ne);
        }
    }

    public Map getEntry(Object key, String[] attrs) throws SecurityProviderException {
        return this.getLdapEntry((String)key, null, attrs, false);
    }

    boolean isPossibleAuthority(String name) throws SecurityProviderException {
        if (name == null) {
            return true;
        }
        String dname = (String)this.getProperty("domain.dns.name", null);
        String nname = (String)this.getProperty("domain.netbios.name", null);
        if (name.equalsIgnoreCase(dname)) {
            return true;
        }
        return name.equalsIgnoreCase(nname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Account getAccount(String acctname, String[] attrs) throws SecurityProviderException {
        LdapEntry acct = this.getAccount0(acctname, attrs);
        if (userMap == null) return (Account)((Object)acct);
        Map<String, String> map = userMap;
        synchronized (map) {
            if (this.userLimit == -1) {
                try {
                    License lic = new License(null);
                    this.userLimit = lic.userLimit;
                    if (this.userLimit != 0) return (Account)((Object)acct);
                    userMap = null;
                }
                catch (Exception e) {
                    e.printStackTrace(this.log);
                    SecurityProviderException spe = new SecurityProviderException(0, e.getMessage(), e);
                    throw spe;
                }
            } else {
                if (userMap.get(acct.distinguishedName) != null) return (Account)((Object)acct);
                if (userMap.size() > this.userLimit) {
                    throw new SecurityProviderException(0, "Jespa license.key " + this.userLimit + " user limit exceeded");
                }
                userMap.put(acct.distinguishedName, acct.distinguishedName);
            }
            return (Account)((Object)acct);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LdapEntry getAccount0(String acctname, String[] attrs) throws SecurityProviderException {
        if (this.account == null && acctname == null) {
            return null;
        }
        if (acctname == null && attrs == null) {
            return this.account;
        }
        if (LogStream.level >= 4) {
            this.log.println("LdapSecurityProvider: getAccount: " + acctname);
        }
        String disposition = (String)this.getProperty("ldap.disposition");
        SecurityPrincipal p = null;
        int securityPrincipalCanonicalForm = 0;
        String filter = null;
        if (disposition.startsWith("ADS")) {
            if (acctname == null) {
                acctname = (String)this.account.get("sAMAccountName");
            }
            p = new SecurityPrincipal(acctname);
            securityPrincipalCanonicalForm = p.getCanonicalForm();
            if (attrs == null) {
                attrs = DEFAULT_ATTRIBUTES_ADS;
            }
            if (securityPrincipalCanonicalForm == 1) {
                return this.getLdapEntry(acctname, null, attrs, true);
            }
            if (securityPrincipalCanonicalForm == 2) {
                filter = "(&(objectClass=user)(sAMAccountName=" + LdapSecurityProvider.escapeFilterValue(p.getName()) + "))";
            } else if (securityPrincipalCanonicalForm == 4) {
                try {
                    filter = "(&(objectClass=user)(userPrincipalName=" + LdapSecurityProvider.escapeFilterValue(p.getName()) + "))";
                    return this.getLdapEntry(p.getName(), filter, attrs, true);
                }
                catch (SecurityProviderException spe) {
                    if (spe.getCode() != 1) {
                        throw spe;
                    }
                    filter = null;
                }
            }
            if (!this.isPossibleAuthority(p.getDomain())) throw new SecurityProviderException(1, "SecurityProvider is not an authority for domain: " + p.getDomain());
            filter = "(&(objectClass=user)(sAMAccountName=" + LdapSecurityProvider.escapeFilterValue(p.getUsername()) + "))";
            return this.getLdapEntry(p.getName(), filter, attrs, true);
        } else {
            if (acctname == null) {
                acctname = (String)this.account.get(this.getProperty("ldap.account.attrname"));
            }
            p = new SecurityPrincipal(acctname);
            securityPrincipalCanonicalForm = p.getCanonicalForm();
            if (attrs == null) {
                attrs = DEFAULT_ATTRIBUTES_RFC;
            }
            if (securityPrincipalCanonicalForm == 1) {
                return this.getLdapEntry(acctname, null, attrs, true);
            }
            int canonicalForm = (int)this.getPropertyAsLong("account.canonicalForm", 0L);
            if (canonicalForm != 0 && !this.isPossibleAuthority(p.getDomain())) throw new SecurityProviderException(1, "SecurityProvider is not an authority for domain: " + p.getDomain());
            filter = (String)this.getProperty("ldap.account.filter");
            String uname = canonicalForm == 0 ? p.toString() : p.getUsername();
            filter = String.format(filter, LdapSecurityProvider.escapeFilterValue(uname));
        }
        return this.getLdapEntry(p.getName(), filter, attrs, true);
    }

    public void authenticate(Object credential) throws SecurityProviderException {
        block21: {
            if (credential instanceof PasswordCredential) {
                PasswordCredential passwordCredential = (PasswordCredential)credential;
                String serviceAcctname = (String)this.getProperty("service.acctname", null);
                String servicePassword = (String)this.getProperty("service.password", null);
                boolean setcredential = this.getProperty("ldap.authenticate.setcredential", "").equals("true");
                try {
                    try {
                        int canonicalForm;
                        InitialLdapContext ctx = this.createLdapContext(passwordCredential, setcredential);
                        this.destroyLdapContext(this.ldapContext);
                        this.ldapContext = ctx;
                        String acctname = passwordCredential.getSecurityPrincipal().getName();
                        this.account = (LdapAccount)this.getAccount(acctname, null);
                        if (LogStream.level >= 4) {
                            this.log.println("LdapSecurityProvider: authenticate: " + this.account);
                        }
                        if ((canonicalForm = (int)this.getPropertyAsLong("account.canonicalForm", 0L)) == 0 || canonicalForm == 4 && acctname.indexOf(64) >= 0) {
                            this.identity = acctname;
                        } else {
                            String disposition = (String)this.getProperty("ldap.disposition");
                            String uname = (String)this.account.get(this.getProperty("ldap.account.attrname"));
                            if (canonicalForm == 1) {
                                this.identity = (String)this.account.getProperty("distinguishedName");
                            } else if (canonicalForm == 2) {
                                this.identity = uname;
                            } else if (canonicalForm == 3) {
                                this.identity = this.getProperty("domain.netbios.name") + "\\" + uname;
                            } else if (canonicalForm == 4) {
                                this.identity = uname + "@" + this.getProperty("domain.dns.name");
                            } else {
                                throw new SecurityProviderException(0, "Unsupported account name canonical form: " + canonicalForm);
                            }
                        }
                        Object var12_12 = null;
                        if (!setcredential) {
                            this.destroyLdapContext(this.ldapContext);
                            this.ldapContext = null;
                        }
                        break block21;
                    }
                    catch (SecurityProviderException spe) {
                        this.destroyLdapContext(this.ldapContext);
                        this.ldapContext = null;
                        if (setcredential) {
                            this.setProperty("service.acctname", serviceAcctname);
                            this.setProperty("service.password", servicePassword);
                        }
                        if (spe instanceof LdapException && spe.getCode() == 49) {
                            if (LogStream.level >= 4) {
                                spe.printStackTrace(this.log);
                            }
                            throw new SecurityProviderException(2, "Invalid credentials: " + credential);
                        }
                        throw spe;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (!setcredential) {
                        this.destroyLdapContext(this.ldapContext);
                        this.ldapContext = null;
                    }
                    throw throwable;
                }
            }
            throw new SecurityProviderException(0, "Unsupported credential type");
        }
    }

    static {
        try {
            anonymousPasswordCredential = new PasswordCredential("anonymous", null);
        }
        catch (SecurityProviderException securityProviderException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryList<E>
    implements List<E> {
        LdapSecurityProvider provider;
        NamingEnumeration ne;

        EntryList(LdapSecurityProvider provider, NamingEnumeration ne) {
            this.provider = provider;
            this.ne = ne;
        }

        @Override
        public boolean add(E value) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean remove(Object value) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int size() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean isEmpty() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public Iterator<E> iterator() {
            return new EntryIterator(this.provider, this.ne);
        }

        @Override
        public Object[] toArray() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void clear() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean equals(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int hashCode() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public E get(int index) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public E set(int index, E element) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void add(int index, E element) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public E remove(int index) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int indexOf(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public ListIterator<E> listIterator() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            throw new RuntimeException("Not implemented");
        }

        public String toString() {
            String ret = "";
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                ret = ret + ", " + iter.next();
            }
            if (ret.length() >= 2) {
                ret = "[" + ret.substring(2) + "]";
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator<E>
    implements Iterator<E> {
        LdapSecurityProvider provider;
        NamingEnumeration ne;

        EntryIterator(LdapSecurityProvider provider, NamingEnumeration ne) {
            this.provider = provider;
            this.ne = ne;
        }

        @Override
        public boolean hasNext() {
            return this.ne.hasMoreElements();
        }

        @Override
        public E next() {
            try {
                SearchResult result = (SearchResult)this.ne.next();
                return (E)new LdapEntry(this.provider, result.getNameInNamespace(), result.getAttributes());
            }
            catch (Exception e) {
                LogStream cfr_ignored_0 = LdapSecurityProvider.this.log;
                if (LogStream.level >= 1) {
                    e.printStackTrace(LdapSecurityProvider.this.log);
                }
                return null;
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented");
        }
    }
}

