/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import jespa.dns.Dns;
import jespa.dns.DnsException;
import jespa.ldap.LdapSecurityProvider;
import jespa.util.LogStream;

class LdapSocket
extends Socket {
    private static void dotQuadToBytes(String address, byte[] bytes) throws DnsException {
        int alen = address.length();
        int istart = 0;
        int bi = 0;
        for (int ci = 0; ci <= alen; ++ci) {
            if (ci != alen && address.charAt(ci) != '.') continue;
            if (istart == ci || bi == 4) {
                throw new DnsException(0, "DnsNameService: Invalid dot quad IP address: " + address);
            }
            bytes[bi++] = (byte)Integer.parseInt(address.substring(istart, ci));
            istart = ci + 1;
        }
        if (bi != 4) {
            throw new DnsException(0, "DnsNameService: Invalid dot quad IP address: " + address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress lookup(String host) throws UnknownHostException {
        LdapSecurityProvider provider;
        Map<Thread, LdapSecurityProvider> map = LdapSecurityProvider.socketCreators;
        synchronized (map) {
            provider = LdapSecurityProvider.socketCreators.get(Thread.currentThread());
        }
        if (provider == null) {
            throw new UnknownHostException("Failed to retreive DNS context");
        }
        try {
            Dns dns = Dns.getInstance(provider);
            Dns.DnsRecordA arecord = (Dns.DnsRecordA)dns.getRecordByName(host, "A");
            LogStream cfr_ignored_0 = provider.log;
            if (LogStream.level >= 4) {
                provider.log.println("LdapSocket: " + arecord);
            }
            byte[] bytes = new byte[4];
            LdapSocket.dotQuadToBytes(arecord.address, bytes);
            return InetAddress.getByAddress(host, bytes);
        }
        catch (DnsException de) {
            UnknownHostException uhe = new UnknownHostException(host);
            uhe.initCause(de);
            throw uhe;
        }
    }

    LdapSocket(String host, int port) throws UnknownHostException, IOException {
        super(LdapSocket.lookup(host), port);
    }
}

