/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import java.net.MalformedURLException;
import java.util.ArrayList;

public class LdapUrl {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";
    String urlstr = null;
    String scheme = null;
    String host = null;
    int port = -1;
    String base = null;
    String[] attrs = null;
    int scope = 2;
    String filter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LdapUrl(String urlstr) throws MalformedURLException {
        ArrayList<String> attrList = null;
        int ch = 120;
        int si = 0;
        int state = 0;
        int ii = 0;
        while (ch != 0) {
            ch = ii == urlstr.length() ? 0 : (int)urlstr.charAt(ii);
            switch (state) {
                case 0: {
                    if (ch == 0) {
                        throw new MalformedURLException();
                    }
                    if (ch != 58) break;
                    if (ii != 4 || !urlstr.regionMatches(true, 0, "ldap", 0, 4)) {
                        this.scheme = urlstr.substring(0, ii).trim();
                        if (this.scheme.length() == 0) {
                            throw new MalformedURLException("Invalid scheme");
                        }
                    }
                    state = 1;
                    break;
                }
                case 1: 
                case 2: {
                    if (ch != 47) {
                        throw new MalformedURLException();
                    }
                    si = ii + 1;
                    ++state;
                    break;
                }
                case 3: {
                    if (ch != 0 && ch != 58 && ch != 47) break;
                    if (ii > si) {
                        this.host = urlstr.substring(si, ii);
                    }
                    state = ch == 58 ? 4 : 5;
                    si = ii + 1;
                    break;
                }
                case 4: {
                    if (ch != 0 && ch != 47) break;
                    if (ii > si) {
                        try {
                            this.port = Integer.parseInt(urlstr.substring(si, ii));
                        }
                        catch (NumberFormatException nfe) {
                            throw new MalformedURLException("Invalid port");
                        }
                    }
                    state = 5;
                    si = ii + 1;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    String tmp;
                    if (ch != 0 && ch != 63) break;
                    if (ii > si && (tmp = urlstr.substring(si, ii).trim()).length() > 0) {
                        if (state == 5) {
                            this.base = tmp;
                        } else if (state == 6) {
                            if (tmp.equalsIgnoreCase("base")) {
                                this.scope = 0;
                            } else if (tmp.equalsIgnoreCase("one")) {
                                this.scope = 1;
                            } else {
                                if (!tmp.equalsIgnoreCase("sub")) throw new MalformedURLException("Invalid scope");
                                this.scope = 2;
                            }
                        } else {
                            this.filter = tmp;
                        }
                    }
                    state = state == 5 ? 10 : ++state;
                    si = ii + 1;
                    break;
                }
                case 10: {
                    String tmp;
                    if (ch != 44 && ch != 0 && ch != 63) break;
                    if (ii > si && (tmp = urlstr.substring(si, ii).trim()).length() > 0) {
                        if (attrList == null) {
                            attrList = new ArrayList<String>();
                        }
                        attrList.add(tmp);
                    }
                    if (ch != 44) {
                        if (attrList != null) {
                            this.attrs = attrList.toArray(new String[attrList.size()]);
                        }
                        state = 6;
                    }
                    si = ii + 1;
                    break;
                }
                default: {
                    throw new MalformedURLException();
                }
            }
            ++ii;
        }
        this.urlstr = urlstr;
    }

    public String getScheme() {
        return this.scheme != null ? this.scheme : "ldap";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port > 0) {
            return this.port;
        }
        if (this.scheme != null && this.scheme.equalsIgnoreCase("ldaps")) {
            return 636;
        }
        return 389;
    }

    public String getBase() {
        return this.base;
    }

    public String[] getAttributes() {
        return this.attrs;
    }

    public int getScope() {
        return this.scope;
    }

    public String getFilter() {
        return this.filter;
    }

    public String toString() {
        return this.urlstr;
    }
}

