/*
 * Decompiled with CFR 0.152.
 */
package jespa.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jespa.ldap.LdapSecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.LogStream;

public class StartTlsSocketFactory
extends SSLSocketFactory {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";
    SSLSocketFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StartTlsSocketFactory() {
        block7: {
            this.factory = null;
            try {
                LdapSecurityProvider provider;
                Map<Thread, LdapSecurityProvider> map = LdapSecurityProvider.socketCreators;
                synchronized (map) {
                    provider = LdapSecurityProvider.socketCreators.get(Thread.currentThread());
                }
                if (provider == null) {
                    throw new SecurityProviderException(0, "Failed to retreive LdapSecurityProvider");
                }
                SSLContext sc = SSLContext.getInstance("TLS");
                TrustManager[] tm = null;
                if (provider.getPropertyAsBoolean("ldap.tls.trustall", false)) {
                    tm = new TrustManager[]{new X509TrustManager(){

                        public void checkClientTrusted(X509Certificate[] c, String a) throws CertificateException {
                        }

                        public void checkServerTrusted(X509Certificate[] c, String a) throws CertificateException {
                        }

                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }};
                }
                sc.init(null, tm, null);
                this.factory = sc.getSocketFactory();
            }
            catch (Exception e) {
                LogStream log = LogStream.getInstance();
                if (LogStream.level < 1) break block7;
                e.printStackTrace(log);
            }
        }
    }

    public static SocketFactory getDefault() {
        return new StartTlsSocketFactory();
    }

    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, localHost, localPort);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.factory.createSocket(address, port, localAddress, localPort);
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.factory.createSocket(s, host, port, autoClose);
    }

    public String[] getSupportedCipherSuites() {
        return null;
    }

    public String[] getDefaultCipherSuites() {
        return null;
    }
}

