/*
 * Decompiled with CFR 0.152.
 */
package jespa.ntlm;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import jcifs.Config;
import jcifs.dcerpc.DcerpcBinding;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.DcerpcSecurityProvider;
import jcifs.dcerpc.UnicodeString;
import jcifs.dcerpc.msrpc.samr;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.util.DES;
import jcifs.util.Encdec;
import jcifs.util.HMACT64;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;
import jespa.License;
import jespa.dcerpc.SecureChannelDcerpcSecurityProvider;
import jespa.dcerpc.msrpc.MsrpcNetrDsEnumerateDomainTrusts;
import jespa.dcerpc.msrpc.MsrpcNetrLogonSamLogon;
import jespa.dcerpc.msrpc.MsrpcNetrServerAuthenticate2;
import jespa.dcerpc.msrpc.MsrpcNetrServerReqChallenge;
import jespa.dcerpc.msrpc.NetrAuthenticatorX;
import jespa.dcerpc.msrpc.netlogon;
import jespa.dns.Dns;
import jespa.ntlm.NtlmAccount;
import jespa.ntlm.NtlmDomain;
import jespa.ntlm.NtlmResponse;
import jespa.ntlm.NtlmSecurityProvider;
import jespa.security.Domain;
import jespa.security.Properties;
import jespa.security.SecurityPrincipal;
import jespa.security.SecurityProviderException;
import jespa.util.Csv;
import jespa.util.SID;
import jespa.util.UUID;

class Netlogon
extends Properties {
    private static HashMap userMap = null;
    static final byte[] ZEROS = new byte[]{0, 0, 0, 0};
    static final long DEFAULT_DOMAIN_TRUST_CACHE_EXPIRATION = 300000L;
    static final SecureRandom RANDOM = new SecureRandom();
    DcerpcHandle handle = null;
    String server_name = null;
    String server_ip = null;
    byte[] sessionKey;
    byte[] client_credential;
    byte[] server_credential;
    int userLimit = 0;
    Map trustsCache = null;
    long trustsCacheExpiration = 0L;
    boolean isSecureChannel = false;
    boolean discoInError = false;
    jespa.util.LogStream log;

    static byte[] computeSessionKey(byte[] nTOWFv1, byte[] clientChallenge, byte[] serverChallenge) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(ZEROS, 0, 4);
            md5.update(clientChallenge, 0, 8);
            md5.update(serverChallenge, 0, 8);
            HMACT64 hmac = new HMACT64(nTOWFv1);
            hmac.update(md5.digest());
            return hmac.digest();
        }
        catch (GeneralSecurityException gse) {
            jespa.util.LogStream log = jespa.util.LogStream.getInstance();
            if (jespa.util.LogStream.level > 0) {
                gse.printStackTrace(log);
            }
            throw new RuntimeException("MD5", gse);
        }
    }

    static byte[] computeNetlogonCredential(byte[] input, byte[] sessionKey) {
        byte[] k1 = new byte[7];
        byte[] k2 = new byte[7];
        System.arraycopy(sessionKey, 0, k1, 0, 7);
        System.arraycopy(sessionKey, 7, k2, 0, 7);
        DES k3 = new DES(k1);
        DES k4 = new DES(k2);
        byte[] output1 = new byte[8];
        byte[] output2 = new byte[8];
        k3.encrypt(input, output1);
        k4.encrypt(output1, output2);
        return output2;
    }

    static void mergeNtlmDomainFromCache(NtlmDomain nd, HashMap cache) throws SecurityProviderException {
        String nname = (String)nd.getProperty("domain.netbios.name", null);
        String dname = (String)nd.getProperty("domain.dns.name", null);
        long flags = nd.getPropertyAsLong("domain.flags", 0L);
        if (nname != null && dname != null && flags > 0L) {
            return;
        }
        NtlmDomain cd = null;
        String n = (String)nd.get("domain.netbios.name");
        if (n != null) {
            n = n.toUpperCase();
            cd = (NtlmDomain)cache.get(n);
        }
        if (cd == null && (n = (String)nd.get("domain.dns.name")) != null) {
            n = n.toUpperCase();
            cd = (NtlmDomain)cache.get(n);
        }
        if (cd == null) {
            return;
        }
        if (nname == null) {
            nd.put("domain.netbios.name", cd.get("domain.netbios.name"));
        }
        if (dname == null) {
            nd.put("domain.dns.name", cd.get("domain.dns.name"));
        }
        if (flags == 0L) {
            nd.put("domain.flags", cd.getProperty("domain.flags", "0x00000000"));
        }
    }

    Netlogon(String nlname, Map properties) {
        super(properties);
        DcerpcBinding.addInterface((String)"netlogon", (String)netlogon.getSyntax());
        this.log = jespa.util.LogStream.getInstance();
        if (jespa.util.LogStream.level >= 4) {
            this.log.println("NETLOGON: " + nlname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name, Object def) throws SecurityProviderException {
        if (this.containsKey(name)) {
            return this.get(name);
        }
        if (name.equals("authority.dns.name")) {
            try {
                this.connect(false, false);
                return this.server_name;
            }
            catch (IOException ioe) {
                throw new SecurityProviderException(0, ioe.getMessage(), ioe);
            }
        }
        if (name.equals("authority.dns.names")) {
            NtlmSecurityProvider nsp = new NtlmSecurityProvider((Map)this);
            try {
                Object object = nsp.getProperty(name, def);
                return object;
            }
            finally {
                nsp.dispose();
            }
        }
        if (name.equals("dns.server.capabilities")) {
            return "0x" + Hexdump.toHexString((long)7L, (int)8);
        }
        return def;
    }

    void connect(boolean useSession, boolean useSecureChannel) throws IOException, SecurityProviderException {
        String hostname;
        if (this.handle == null) {
            if (jespa.util.LogStream.level >= 5) {
                Config.store((OutputStream)this.log, (String)"JCIFS PROPERTIES");
            }
            try {
                License lic = new License(null);
                this.userLimit = lic.userLimit;
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            String hostname2 = (String)this.getProperty("localhost.netbios.name");
            String acctname = (String)this.getProperty("service.acctname");
            String password = (String)this.getProperty("service.password");
            NtlmPasswordAuthentication serviceAuth = new NtlmPasswordAuthentication(null, acctname, password);
            DcerpcHandle _handle = null;
            String name = null;
            while (true) {
                boolean retryNoSites = false;
                String[] names = null;
                try {
                    names = (String[])this.getProperty("authority.dns.names");
                }
                catch (SecurityProviderException spe) {
                    long dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L);
                    if ((dcaps & 4L) != 4L) {
                        throw spe;
                    }
                    if (jespa.util.LogStream.level >= 2) {
                        if (jespa.util.LogStream.level >= 3) {
                            spe.printStackTrace(this.log);
                        }
                        this.log.println("NETLOGON: Failed to retrieve names, retrying SRV lookup with no dns.site");
                    }
                    retryNoSites = true;
                }
                if (names != null) {
                    int si = 0;
                    if (this.server_name != null) {
                        for (int ni = 0; ni < names.length; ++ni) {
                            if (!names[ni].equalsIgnoreCase(this.server_name)) continue;
                            si = ni;
                            break;
                        }
                        if (this.discoInError && ++si == names.length) {
                            si = 0;
                        }
                        this.server_name = null;
                    }
                    Dns dns = Dns.getInstance(this);
                    for (int ni = 0; ni < names.length; ++ni) {
                        try {
                            name = names[(ni + si) % names.length];
                            Dns.DnsRecordA dra = (Dns.DnsRecordA)dns.getRecordByName(name, "A");
                            this.server_ip = dra.address;
                            String endpoint = "ncacn_np:" + this.server_ip + "[\\PIPE\\NETLOGON]";
                            if (jespa.util.LogStream.level >= 4) {
                                LogStream.setInstance((PrintStream)this.log);
                                LogStream.setLevel((int)(jespa.util.LogStream.level - 3));
                                this.log.println("NETLOGON: Connecting DCERPC handle to " + endpoint + " with identity " + serviceAuth);
                            }
                            _handle = DcerpcHandle.getHandle((String)endpoint, (NtlmPasswordAuthentication)serviceAuth);
                            _handle.bind();
                            break;
                        }
                        catch (IOException ioe) {
                            if (ni + 1 == names.length) {
                                long dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L);
                                if ((dcaps & 4L) != 4L) {
                                    throw ioe;
                                }
                                retryNoSites = true;
                            }
                            if (jespa.util.LogStream.level < 2) continue;
                            if (jespa.util.LogStream.level >= 3) {
                                ioe.printStackTrace(this.log);
                            }
                            if (!retryNoSites) continue;
                            this.log.println("NETLOGON: Failed to connect with any servers, retrying SRV lookup with no dns.site");
                            continue;
                        }
                    }
                }
                if (!retryNoSites) break;
                long dcaps = this.getPropertyAsLong("dns.server.capabilities", 0L);
                this.setProperty("dns.server.capabilities", "0x" + Hexdump.toHexString((long)(dcaps & 0xFFFFFFFFFFFFFFFBL), (int)8));
                this.server_name = null;
                this.remove("authority.dns.names");
            }
            this.handle = _handle;
            this.server_name = name;
            this.discoInError = false;
            if (jespa.util.LogStream.level >= 3) {
                this.log.println("NETLOGON: Bind successful");
            }
        }
        if (useSession && this.sessionKey == null) {
            String acctname = (String)this.getProperty("service.acctname");
            hostname = (String)this.getProperty("localhost.netbios.name");
            byte[] client_challenge = new byte[8];
            RANDOM.nextBytes(client_challenge);
            MsrpcNetrServerReqChallenge rpc1 = new MsrpcNetrServerReqChallenge(this.server_name, hostname, client_challenge);
            this.handle.sendrecv((DcerpcMessage)rpc1);
            if (rpc1.retval != 0) {
                throw new SmbException(rpc1.retval, false);
            }
            String password = (String)this.getProperty("service.password");
            byte[] nTOWFv1 = NtlmPasswordAuthentication.nTOWFv1((String)password);
            byte[] _sessionKey = Netlogon.computeSessionKey(nTOWFv1, client_challenge, rpc1.server_challenge);
            this.client_credential = Netlogon.computeNetlogonCredential(client_challenge, _sessionKey);
            this.server_credential = Netlogon.computeNetlogonCredential(rpc1.server_challenge, _sessionKey);
            MsrpcNetrServerAuthenticate2 rpc2 = new MsrpcNetrServerAuthenticate2(this.server_name, new SecurityPrincipal(acctname).getUsername(), hostname, this.client_credential, 0x600FFFFF);
            this.handle.sendrecv((DcerpcMessage)rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, false);
            }
            if (!Arrays.equals(this.server_credential, rpc2.server_credential)) {
                throw new SecurityProviderException(0, "NetrServerAuthenticate2 server_credential check failed");
            }
            this.sessionKey = _sessionKey;
            if (jespa.util.LogStream.level >= 4) {
                this.log.println("NETLOGON: Session authenticated");
            }
        }
        if (useSecureChannel && !this.isSecureChannel) {
            DcerpcHandle _handle;
            block32: {
                String endpoint = "ncacn_np:" + this.server_ip + "[\\PIPE\\NETLOGON]";
                hostname = (String)this.getProperty("localhost.netbios.name");
                String acctname = (String)this.getProperty("service.acctname");
                String password = (String)this.getProperty("service.password");
                NtlmPasswordAuthentication serviceAuth = new NtlmPasswordAuthentication(null, acctname, password);
                _handle = DcerpcHandle.getHandle((String)endpoint, (NtlmPasswordAuthentication)serviceAuth);
                NtlmDomain _domain = (NtlmDomain)this.getDomainTrust("~", 3);
                if (_domain == null) {
                    throw new SecurityProviderException(0, "Failed to determine NetBIOS domain name");
                }
                HashMap<String, Object> _properties = new HashMap<String, Object>();
                _properties.put("sessionKey", this.sessionKey);
                _properties.put("domain.netbios.name", _domain.getProperty("domain.netbios.name"));
                _properties.put("localhost.netbios.name", hostname);
                _handle.setDcerpcSecurityProvider((DcerpcSecurityProvider)new SecureChannelDcerpcSecurityProvider(_properties));
                _handle.bind();
                try {
                    this.handle.close();
                }
                catch (IOException ioe) {
                    if (jespa.util.LogStream.level < 2) break block32;
                    ioe.printStackTrace(this.log);
                }
            }
            this.handle = _handle;
            this.isSecureChannel = true;
            if (jespa.util.LogStream.level >= 4) {
                this.log.println("NETLOGON: Secure Channel encryption installed");
            }
        }
    }

    void disconnect(boolean inError) {
        if (this.handle != null) {
            if (jespa.util.LogStream.level >= 4) {
                this.log.println("NETLOGON: disconnect");
            }
            DcerpcHandle tmp = this.handle;
            this.handle = null;
            this.sessionKey = null;
            this.isSecureChannel = false;
            this.discoInError = inError;
            try {
                tmp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    Map getDomainTrusts0(int flags) throws IOException, SecurityProviderException {
        HashMap<String, NtlmDomain> ret;
        block18: {
            NtlmDomain d;
            ret = new HashMap<String, NtlmDomain>();
            String values = (String)this.getProperty("domain.trust.cache.values", null);
            if (values != null) {
                String[] r = Csv.parseRow(values, ',', 1);
                for (int ri = 0; ri < r.length; ++ri) {
                    String[] e = Csv.parseRow(r[ri], ':', 1);
                    if (e.length < 2) {
                        throw new SecurityProviderException(0, "domain.trust.cache.values elements must contain at least <domain.netbios.name>:<domain.dns.name>");
                    }
                    d = new NtlmDomain();
                    d.put("domain.netbios.name", e[0]);
                    d.put("domain.dns.name", e[1]);
                    if (e.length > 2) {
                        if (!e[2].startsWith("0x")) {
                            throw new SecurityProviderException(0, "domain.flags value must start with 0x");
                        }
                        long f = Long.parseLong(e[2].substring(2), 16);
                        d.put("domain.flags", "0x" + Hexdump.toHexString((long)f, (int)8));
                    }
                    ret.put(e[0].toUpperCase(), d);
                    ret.put(e[1].toUpperCase(), d);
                }
                if (jespa.util.LogStream.level >= 4) {
                    this.log.println("NETLOGON: Initialized domain trusts cache with values: " + ret);
                }
            }
            try {
                this.connect(false, false);
                MsrpcNetrDsEnumerateDomainTrusts rpc2 = new MsrpcNetrDsEnumerateDomainTrusts(this.server_name, flags);
                this.handle.sendrecv((DcerpcMessage)rpc2);
                if (rpc2.retval != 0) {
                    throw new SmbException(rpc2.retval, false);
                }
                netlogon.NetrTrustedDomainArray domains = rpc2.domains;
                for (int di = 0; di < domains.domain_count; ++di) {
                    d = new NtlmDomain();
                    netlogon.NetrDomainTrust domain = domains.domains[di];
                    if (domain.trust_type == 3) {
                        d.put("domain.dns.name", domain.netbios_domain_name);
                    } else {
                        d.put("domain.netbios.name", domain.netbios_domain_name);
                        d.put("domain.dns.name", domain.dns_domain_name);
                    }
                    d.put("domain.flags", "0x" + Hexdump.toHexString((int)domain.flags, (int)8));
                    d.put("domain.trust.type", "" + domain.trust_type);
                    d.put("domain.trust.attributes", "0x" + Hexdump.toHexString((int)domain.trust_attributes, (int)8));
                    if (domain.domain_sid != null) {
                        d.put("objectSid", new SID(domain.domain_sid, 3, domain.netbios_domain_name, null, false));
                    }
                    d.put("objectGUID", new UUID(domain.domain_guid));
                    Netlogon.mergeNtlmDomainFromCache(d, ret);
                    domain.netbios_domain_name = (String)d.getProperty("domain.netbios.name", null);
                    domain.dns_domain_name = (String)d.getProperty("domain.dns.name", null);
                    domain.flags = (int)(d.getPropertyAsLong("domain.flags", 0L) & 0xFFFFFFFFL);
                    if ((domain.flags & 8) == 8) {
                        ret.put("~", d);
                    }
                    if (domain.dns_domain_name != null) {
                        ret.put(domain.dns_domain_name.toUpperCase(), d);
                    }
                    if (domain.netbios_domain_name == null) continue;
                    ret.put(domain.netbios_domain_name.toUpperCase(), d);
                }
            }
            catch (SecurityProviderException spe) {
                if (ret.size() == 0) {
                    throw spe;
                }
                if (jespa.util.LogStream.level < 2) break block18;
                if (jespa.util.LogStream.level >= 3) {
                    spe.printStackTrace(this.log);
                } else {
                    this.log.println("NETLOGON: " + spe.getMessage());
                }
                this.log.println("NETLOGON: Failed to retrieve domain trust info, proceeding with domain.trust.cache.values only ...");
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Map getDomainTrusts(int flags) throws IOException, SecurityProviderException {
        long currentMillis;
        if (this.trustsCache != null && this.trustsCacheExpiration > (currentMillis = System.currentTimeMillis())) {
            if (jespa.util.LogStream.level < 4) return this.trustsCache;
            this.log.println("NETLOGON: domain trusts cache info refresh in " + (this.trustsCacheExpiration - currentMillis) + "ms");
            return this.trustsCache;
        }
        boolean discoOnReturn = this.handle == null;
        if (jespa.util.LogStream.level >= 3) {
            this.log.println("getDomainTrusts: Retrieving list of domains");
        }
        IOException e = null;
        int retry = 2;
        while (retry-- > 0) {
            try {
                Map ret = this.getDomainTrusts0(flags);
                if (jespa.util.LogStream.level >= 4) {
                    this.log.println("getDomainTrusts: List of domains retrieved successfully: " + ret);
                }
                this.trustsCache = ret;
                this.trustsCacheExpiration = System.currentTimeMillis() + this.getPropertyAsLong("domain.trust.cache.expiration", 300000L);
                Map map = ret;
                return map;
            }
            catch (IOException ioe) {
                if (jespa.util.LogStream.level >= 1) {
                    String msg = ioe.getMessage();
                    if (msg != null && msg.equals("DCERPC pipe is no longer open")) {
                        if (jespa.util.LogStream.level >= 4) {
                            this.log.println("getDomainTrusts: " + ioe.getMessage());
                        }
                    } else {
                        ioe.printStackTrace(this.log);
                    }
                }
                if ((e = ioe) instanceof DcerpcException || e instanceof NdrException) {
                    retry = 0;
                }
                this.disconnect(true);
            }
        }
        if (this.trustsCache == null) throw (IOException)e;
        if (jespa.util.LogStream.level < 2) return this.trustsCache;
        e.printStackTrace(this.log);
        this.log.println("getDomainTrusts: Failed to retrieve domain trust information - using cached data");
        return this.trustsCache;
        finally {
            if (discoOnReturn) {
                this.disconnect(false);
            }
        }
    }

    Domain getDomainTrust(String name, int _flags) throws IOException, SecurityProviderException {
        this.getDomainTrusts(_flags);
        Domain ret = (Domain)this.trustsCache.get(name.toUpperCase());
        if (ret == null) {
            NtlmDomain domain = (NtlmDomain)this.trustsCache.get("~");
            if (domain == null) {
                throw new SecurityProviderException(0, "Failed to retrieve primary domain trust info");
            }
            long flags = domain.getPropertyAsLong("domain.flags", 0L);
            if ((flags & 4L) != 0L) {
                if (jespa.util.LogStream.level >= 4) {
                    this.log.println("getDomainTrust: Domain not found (in forest root data): " + name);
                }
            } else {
                String rootDnsName = null;
                for (String key : this.trustsCache.keySet()) {
                    domain = (NtlmDomain)this.trustsCache.get(key);
                    flags = domain.getPropertyAsLong("domain.flags", 0L);
                    if ((flags & 4L) == 0L) continue;
                    rootDnsName = (String)domain.getProperty("domain.dns.name", null);
                }
                if (rootDnsName == null) {
                    if (jespa.util.LogStream.level >= 4) {
                        this.log.println("getDomainTrust: No forest root found in Computer account domain trusts");
                    }
                } else {
                    if (jespa.util.LogStream.level >= 4) {
                        this.log.println("getDomainTrust: Domain '" + name + "' not found, querying DC in forest root domain '" + rootDnsName + "'");
                    }
                    HashMap _properties = Properties.getFilteredProperties(this, NtlmSecurityProvider.NETLOGON_KEYS);
                    _properties.put("bindstr", rootDnsName);
                    Netlogon nl = new Netlogon(rootDnsName, _properties);
                    Map trusts = nl.getDomainTrusts(3);
                    if (trusts != null) {
                        trusts.putAll(this.trustsCache);
                        this.trustsCache = trusts;
                    }
                    ret = (Domain)this.trustsCache.get(name.toUpperCase());
                }
            }
        }
        if (jespa.util.LogStream.level >= 3 && ret == null) {
            this.log.println("getDomainTrust: Failed to retrieve trust info for domain: " + name + " flags=0x" + Hexdump.toHexString((int)_flags, (int)8));
        }
        return ret;
    }

    void validate0(NtlmResponse resp, byte[] challenge, byte[] userSessionKey, NtlmAccount acct) throws IOException, SecurityProviderException {
        this.connect(true, this.getPropertyAsBoolean("netlogon.useSecureChannel", true));
        int timestamp = (int)(System.currentTimeMillis() / 1000L) & 0xFFFFFFFF;
        Encdec.enc_uint32le((int)(Encdec.dec_uint32le((byte[])this.client_credential, (int)0) + timestamp), (byte[])this.client_credential, (int)0);
        byte[] cred = Netlogon.computeNetlogonCredential(this.client_credential, this.sessionKey);
        netlogon.NetrSamInfo2 samInfo2 = new netlogon.NetrSamInfo2();
        MsrpcNetrLogonSamLogon rpc2 = new MsrpcNetrLogonSamLogon(this.server_name, (String)this.getProperty("localhost.netbios.name"), new NetrAuthenticatorX(cred, timestamp), resp.domain, resp.username, challenge, resp.ntResponse, resp.lmResponse, 3, samInfo2);
        this.handle.sendrecv((DcerpcMessage)rpc2);
        Encdec.enc_uint32le((int)(Encdec.dec_uint32le((byte[])this.client_credential, (int)0) + 1), (byte[])this.client_credential, (int)0);
        cred = Netlogon.computeNetlogonCredential(this.client_credential, this.sessionKey);
        if (!Arrays.equals(cred, rpc2.return_authenticator.cred)) {
            throw new SecurityProviderException(3, "NetrLogonSamLogon return authenticator check failed");
        }
        switch (rpc2.retval) {
            case 0: {
                break;
            }
            case -1073741724: {
                throw new SecurityProviderException(1, "The account is not found: " + resp.domain + "\\" + resp.username);
            }
            case -1073741718: {
                throw new SecurityProviderException(2, "The supplied credentials are invalid: " + resp.domain + "\\" + resp.username);
            }
            case -1073741713: 
            case -1073741711: 
            case -1073741710: 
            case -1073741260: {
                SmbException se = new SmbException(rpc2.retval, false);
                throw new SecurityProviderException(2, se.getMessage() + ": " + resp.domain + "\\" + resp.username);
            }
            default: {
                throw new SmbException(rpc2.retval, false);
            }
        }
        if (this.userLimit > 0) {
            String key;
            if (userMap == null) {
                userMap = new HashMap();
            }
            if (userMap.get(key = (resp.domain + "\\" + resp.username).toLowerCase()) == null) {
                if (userMap.size() >= this.userLimit) {
                    throw new IOException("Jespa license.key " + this.userLimit + " user limit exceeded");
                }
                userMap.put(key, key);
            }
        }
        System.arraycopy(samInfo2.key.key, 0, userSessionKey, 0, 16);
        try {
            Cipher rc4 = Cipher.getInstance("RC4");
            rc4.init(2, new SecretKeySpec(this.sessionKey, "RC4"));
            rc4.update(samInfo2.key.key, 0, 16, userSessionKey, 0);
        }
        catch (GeneralSecurityException gse) {
            throw new SecurityProviderException(0, "Failed to decrypt userSessionKey key", gse);
        }
        if (acct != null) {
            SID sid;
            int si;
            String domainName = new UnicodeString(samInfo2.domain, false).toString();
            NtlmDomain acctDomain = (NtlmDomain)this.getDomainTrust(domainName, 3);
            if (acctDomain != null) {
                acct.put("domain.dns.name", acctDomain.get("domain.dns.name"));
                acct.put("domain.netbios.name", acctDomain.get("domain.netbios.name"));
            } else {
                if (jespa.util.LogStream.level >= 3) {
                    this.log.println("Failed to retrieve account domain, not setting domain.dns.name in NtlmAccount");
                }
                acct.put("domain.netbios.name", domainName.toUpperCase());
            }
            SID domainSid = new SID(samInfo2.logon_domain, 3, domainName, null, false);
            samr.SamrRidWithAttributeArray sids = samInfo2.groups;
            HashMap<SID, SID> groups = new HashMap<SID, SID>();
            for (si = 0; si < sids.count; ++si) {
                sid = new SID(domainSid, sids.rids[si].rid);
                groups.put(sid, sid);
            }
            for (si = 0; si < samInfo2.sid_count; ++si) {
                sid = new SID(samInfo2.extra_sids[si].sid, 0, null, null, false);
                groups.put(sid, sid);
            }
            acct.put("tokenGroups", groups);
            acct.put("sAMAccountName", new UnicodeString(samInfo2.account_name, false).toString());
            acct.put("objectSid", new SID(domainSid, samInfo2.rid));
            acct.put("userAccountControl", "0x" + Hexdump.toHexString((int)samInfo2.acct_flags, (int)8));
            if (samInfo2.full_name != null && samInfo2.full_name.buffer != null) {
                acct.put("displayName", new UnicodeString(samInfo2.full_name, false).toString());
            }
            if (samInfo2.home_directory != null && samInfo2.home_directory.buffer != null) {
                acct.put("homeDirectory", new UnicodeString(samInfo2.home_directory, false).toString());
            }
            if (samInfo2.home_drive != null && samInfo2.home_drive.buffer != null) {
                acct.put("homeDrive", new UnicodeString(samInfo2.home_drive, false).toString());
            }
        }
    }

    void validate(NtlmResponse resp, byte[] userSessionKey, NtlmAccount acct) throws IOException, SecurityProviderException {
        Exception e = null;
        int retry = 2;
        byte[] challenge = resp.challenge;
        if ((resp.flags & 0x80000) != 0 && resp.ntResponse.length == 24) {
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(resp.sessionNonce);
                challenge = md5.digest();
            }
            catch (GeneralSecurityException gse) {
                throw new SecurityProviderException(0, "Failed to compute NTLM2 serverChallenge", gse);
            }
        }
        while (retry-- > 0) {
            block17: {
                try {
                    this.validate0(resp, challenge, userSessionKey, acct);
                    if ((resp.flags & 0x80000) != 0 && resp.ntResponse.length == 24) {
                        HMACT64 hmac = new HMACT64(userSessionKey);
                        hmac.update(resp.sessionNonce);
                        System.arraycopy(hmac.digest(), 0, userSessionKey, 0, userSessionKey.length);
                    }
                    return;
                }
                catch (SecurityProviderException spe) {
                    if (spe.getCode() != 1 && spe.getCode() != 2) {
                        if (jespa.util.LogStream.level >= 1) {
                            spe.printStackTrace(this.log);
                        }
                    }
                    if (spe.getCode() != 3) {
                        throw spe;
                    }
                    e = spe;
                }
                catch (IOException ioe) {
                    if (ioe.getMessage().equals("All pipe instances are busy.")) {
                        this.server_name = null;
                    }
                    if (jespa.util.LogStream.level >= 1) {
                        if (ioe.getMessage().equals("DCERPC pipe is no longer open") || ioe.getMessage().equals("All pipe instances are busy.")) {
                            if (jespa.util.LogStream.level >= 4) {
                                this.log.println("NETLOGON: " + ioe.getMessage());
                            }
                        } else {
                            ioe.printStackTrace(this.log);
                        }
                    }
                    if (!((e = ioe) instanceof DcerpcException) && !(e instanceof NdrException)) break block17;
                    retry = 0;
                }
            }
            this.disconnect(true);
        }
        if (e instanceof SecurityProviderException) {
            throw (SecurityProviderException)e;
        }
        throw (IOException)e;
    }
}

