/*
 * Decompiled with CFR 0.152.
 */
package jespa.ntlm;

import java.util.Arrays;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.util.Encdec;
import jcifs.util.HMACT64;
import jcifs.util.MD4;

public class NtlmResponse {
    String domain;
    String username;
    byte[] challenge;
    byte[] sessionNonce;
    byte[] targetInformation;
    byte[] lmResponse;
    byte[] ntResponse;
    byte[] sessionKey = null;
    int flags = 0;

    NtlmResponse(String domain, String username, byte[] challenge, byte[] sessionNonce, byte[] targetInformation, byte[] lmResponse, byte[] ntResponse, int flags) {
        this.domain = domain;
        this.username = username;
        this.challenge = challenge;
        this.sessionNonce = sessionNonce;
        this.targetInformation = targetInformation;
        this.lmResponse = lmResponse;
        this.ntResponse = ntResponse;
        this.flags = flags;
    }

    private byte[] getAvPair(byte[] response, int id) {
        byte[] ret = null;
        int ri = 44;
        while (true) {
            short avId = Encdec.dec_uint16le((byte[])response, (int)ri);
            short avLen = Encdec.dec_uint16le((byte[])response, (int)(ri + 2));
            if (avId == 0 || (ri += 4) + avLen > response.length) break;
            if (avId == id) {
                ret = new byte[avLen];
                System.arraycopy(response, ri, ret, 0, avLen);
                break;
            }
            ri += avLen;
        }
        return ret;
    }

    private byte[] getCombinedTargetInformation(byte[] response, byte[] targetInformation) {
        int ri = 44;
        while (true) {
            short avId = Encdec.dec_uint16le((byte[])response, (int)ri);
            short avLen = Encdec.dec_uint16le((byte[])response, (int)(ri + 2));
            if (avId == 0 || (ri += 4) + avLen > response.length) break;
            if (avId > 4) {
                byte[] tmp = new byte[targetInformation.length + 4 + avLen];
                int ti = 0;
                System.arraycopy(targetInformation, 0, tmp, ti, targetInformation.length - 4);
                Encdec.enc_uint16le((short)avId, (byte[])tmp, (int)(ti += targetInformation.length - 4));
                Encdec.enc_uint16le((short)avLen, (byte[])tmp, (int)(ti += 2));
                System.arraycopy(response, ri, tmp, ti += 2, avLen);
                Encdec.enc_uint32le((int)0, (byte[])tmp, (int)(ti += avLen));
                ti += 4;
                targetInformation = tmp;
            }
            ri += avLen;
        }
        return targetInformation;
    }

    public NtlmResponse(NtlmResponse clientResponse, String domain, String username, char[] password, byte[] targetInformation) {
        this.domain = domain;
        this.username = username;
        this.lmResponse = null;
        this.flags = clientResponse.flags;
        if (clientResponse.ntResponse.length == 24) {
            if ((this.flags & 0x80000) == 0) {
                this.ntResponse = NtlmPasswordAuthentication.getNTLMResponse((String)new String(password), (byte[])clientResponse.challenge);
            } else {
                byte[] clientChallenge = new byte[8];
                System.arraycopy(clientResponse.lmResponse, 0, clientChallenge, 0, 8);
                byte[] responseKeyNT = NtlmPasswordAuthentication.nTOWFv1((String)new String(password));
                this.ntResponse = NtlmPasswordAuthentication.getNTLM2Response((byte[])responseKeyNT, (byte[])clientResponse.challenge, (byte[])clientChallenge);
                if ((this.flags & 0x10) != 0) {
                    MD4 md4 = new MD4();
                    md4.update(responseKeyNT);
                    byte[] userSessionKey = md4.digest();
                    HMACT64 hmac = new HMACT64(userSessionKey);
                    hmac.update(clientResponse.sessionNonce);
                    clientResponse.sessionKey = this.sessionKey = hmac.digest();
                }
            }
        } else {
            byte[] responseKeyNT = NtlmPasswordAuthentication.nTOWFv2((String)domain, (String)username, (String)new String(password));
            byte[] clientChallenge = new byte[8];
            System.arraycopy(clientResponse.ntResponse, 32, clientChallenge, 0, 8);
            long nanos1601 = Encdec.dec_uint64le((byte[])clientResponse.ntResponse, (int)24);
            targetInformation = this.getCombinedTargetInformation(clientResponse.ntResponse, targetInformation);
            this.ntResponse = NtlmPasswordAuthentication.getNTLMv2Response((byte[])responseKeyNT, (byte[])clientResponse.challenge, (byte[])clientChallenge, (long)nanos1601, (byte[])targetInformation);
            if ((this.flags & 0x10) != 0) {
                HMACT64 hmac = new HMACT64(responseKeyNT);
                hmac.update(this.ntResponse, 0, 16);
                clientResponse.sessionKey = this.sessionKey = hmac.digest();
            }
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NtlmResponse) {
            NtlmResponse resp = (NtlmResponse)obj;
            if (resp.ntResponse.length == this.ntResponse.length && Arrays.equals(resp.ntResponse, this.ntResponse)) {
                return true;
            }
        }
        return false;
    }
}

