/*
 * Decompiled with CFR 0.152.
 */
package jespa.ntlm;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.UnicodeString;
import jcifs.dcerpc.msrpc.LsaPolicyHandle;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SID;
import jcifs.smb.SmbException;
import jcifs.util.Encdec;
import jcifs.util.HMACT64;
import jcifs.util.Hexdump;
import jespa.dcerpc.msrpc.MsrpcLsarLookupNames;
import jespa.dcerpc.msrpc.lsarpc;
import jespa.dns.Dns;
import jespa.dns.DnsException;
import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.ntlm.Netlogon;
import jespa.ntlm.NtlmAccount;
import jespa.ntlm.NtlmConstants;
import jespa.ntlm.NtlmResponse;
import jespa.ntlm.NtlmSessionSecurity;
import jespa.ntlm.NtlmsspAuthenticateMessage;
import jespa.ntlm.NtlmsspChallengeMessage;
import jespa.ntlm.NtlmsspNegotiateMessage;
import jespa.security.Account;
import jespa.security.Domain;
import jespa.security.PasswordCredential;
import jespa.security.Properties;
import jespa.security.SecurityPrincipal;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.CacheMap;
import jespa.util.LogStream;

public class NtlmSecurityProvider
extends SecurityProvider {
    static final int ST_GROUND = 0;
    static final int ST_INIT_TYPE1 = 1;
    static final int ST_ACCEPT_TYPE1 = 17;
    static final int ST_INIT_TYPE2 = 2;
    static final int ST_ACCEPT_TYPE3 = 18;
    static final int ST_INIT_COMPLETE = 3;
    static final int ST_ACCEPT_COMPLETE = 19;
    static final int ST_INIT_FAILED = 4;
    static final int ST_ACCEPT_FAILED = 20;
    static final int ST_DISPOSED = 255;
    static final long MILLISECONDS_BETWEEN_1970_AND_1601 = 11644473600000L;
    static final long DEFAULT_PROPERTIES_CHANGED_EXPIRATION = 5000L;
    static final String[] NETLOGON_KEYS = new String[]{"bindstr", "service.acctname", "service.password", "dns.servers", "dns.site", "dns.records.path", "dns.jndifactory.classname", "authority.dns.names.resolve", "authority.dns.names.resolve.sld", "localhost.netbios.name", "domain.trust.cache.expiration", "domain.trust.cache.values", "netlogon.useSecureChannel"};
    static final SID NOSID = new SID(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, 0);
    static Object LOCK = null;
    static String DEFAULT_LOCALHOST_NETBIOS_NAME = null;
    static String DEFAULT_LOCALHOST_DNS_NAME = null;
    static NetlogonMap<String, Netlogon> netlogonInstances = null;
    static CacheMap<String, SID> sidCache = new CacheMap("NtlmSecurityProvider: sidCache", 3600L, 300L);
    static long propertiesChangedExpiration = 0L;
    static SecureRandom random = new SecureRandom();
    private static String[] _DOMAIN_ATTRS;
    private static String[] _ACCOUNT_ATTRS;
    private PasswordCredential serviceCredential = null;
    int state = 0;
    byte[] serverChallenge = null;
    byte[] targetInformation = null;
    byte[] sessionKey = null;
    NtlmSessionSecurity sessionSecurityWrap = null;
    NtlmSessionSecurity sessionSecurityUnwrap = null;
    NtlmAccount account = null;
    LogStream log = LogStream.getInstance();

    public NtlmSecurityProvider(Map properties) {
        super(properties);
        if (LogStream.level >= 4) {
            this.log.println("NtlmSecurityProvider: " + properties.get("service.acctname"));
        }
    }

    public NtlmSecurityProvider(Map properties, String[] pnames) throws SecurityProviderException {
        super(properties, pnames);
        if (LogStream.level >= 4) {
            this.log.println("NtlmSecurityProvider: " + properties.get("service.acctname"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name, Object def) throws SecurityProviderException {
        Object ret = super.getProperty(name, null);
        if (ret == null) {
            if (name.equals("domain.netbios.name") || name.equals("domain.dns.name")) {
                try {
                    ret = this.getDomain(null, null).get(name);
                }
                catch (SecurityProviderException spe) {
                    throw new SecurityProviderException(0, "Failed to retrieve property: " + name, spe);
                }
            }
            if (name.equals("localhost.dns.name")) {
                ret = DEFAULT_LOCALHOST_DNS_NAME;
            } else if (name.equals("localhost.netbios.name")) {
                ret = this.getProperty("service.acctname", null);
                if (ret != null) {
                    String s = new SecurityPrincipal((String)ret).getUsername();
                    ret = null;
                    int n = s.length();
                    if (n > 1 && s.indexOf(36) == n - 1) {
                        ret = s.substring(0, n - 1);
                        this.put(name, ret);
                    }
                }
                if (ret == null) {
                    ret = DEFAULT_LOCALHOST_NETBIOS_NAME;
                }
            } else if (name.equals("ntlmssp.flags")) {
                int _flags = 579338887;
                String p = (String)this.get("flags.confidentiality");
                if (p == null || "true".equalsIgnoreCase(p) || "1".equals(p) || "yes".equalsIgnoreCase(p)) {
                    _flags |= 0x40008030;
                }
                if ((p = (String)this.get("flags.integrity")) == null || "true".equalsIgnoreCase(p) || "1".equals(p) || "yes".equalsIgnoreCase(p)) {
                    _flags |= 0x40008010;
                }
                ret = "0x" + Hexdump.toHexString((int)_flags, (int)8);
                this.put(name, ret);
            } else if (name.equals("authority.dns.name")) {
                Object object = LOCK;
                synchronized (object) {
                    ret = this.getNetlogonInstance().getProperty(name);
                    this.put(name, ret);
                }
            }
        }
        if (ret == null) {
            return def;
        }
        return ret;
    }

    public void setEncryptedProperty(String name, String value, Object salt) throws SecurityProviderException {
        if (salt == null) {
            salt = this.getProperty("service.acctname");
        }
        super.setEncryptedProperty(name, value, salt);
    }

    public boolean getFlag(String name) throws SecurityProviderException {
        String p;
        int current;
        int flags = 0;
        if (name.equals("confidentiality")) {
            flags = 524336;
        } else if (name.equals("integrity") || name.equals("sequenceDetection")) {
            flags = 524304;
        }
        return flags != 0 ? ((current = (int)this.getPropertyAsLong("ntlmssp.flags", 0L)) & flags) == flags : name.equals("capabilities.accept.ntlmssp") && ((p = (String)this.get("flags." + name)) == null || "true".equalsIgnoreCase(p) || "1".equals(p) || "yes".equalsIgnoreCase(p));
    }

    public void setFlag(String name, boolean value) throws SecurityProviderException {
        if (!name.equals("confidentiality") && !name.equals("integrity")) {
            super.setFlag(name, value);
            return;
        }
        int current = (int)this.getPropertyAsLong("ntlmssp.flags", 0L);
        int flags = 0;
        if (value) {
            if (name.equals("confidentiality")) {
                flags = 1074266160;
            } else if (name.equals("integrity")) {
                flags = 1074266128;
            }
            current |= flags;
        } else {
            if (name.equals("confidentiality")) {
                flags = 32;
            } else if (name.equals("integrity")) {
                flags = 1074266160;
            }
            current &= ~flags;
        }
        if (flags != 0) {
            this.put("ntlmssp.flags", "0x" + Hexdump.toHexString((int)current, (int)8));
        }
    }

    protected void encodeObject(ByteBuffer bb, Object obj) throws EncodingException {
        if (obj instanceof NtlmAccount) {
            NtlmAccount acct = (NtlmAccount)obj;
            bb.encodeUint16le(10);
            bb.encodeUint16le(acct.size());
            for (Object key : acct.keySet()) {
                Object val;
                if (key == (val = acct.get(key))) {
                    val = DUPLICATE_REFERENCE;
                }
                this.encodeObject(bb, key);
                this.encodeObject(bb, val);
            }
        } else if (obj instanceof NtlmSecurityProvider) {
            HashMap m = (HashMap)((HashMap)obj).clone();
            m.remove("service.password");
            m.remove("authority.dns.names");
            m.remove("bindstr.url");
            bb.encodeUint16le(11);
            bb.encodeUint16le(m.size());
            for (Object key : m.keySet()) {
                Object val;
                if (key == (val = m.get(key))) {
                    val = DUPLICATE_REFERENCE;
                }
                this.encodeObject(bb, key);
                this.encodeObject(bb, val);
            }
        } else {
            super.encodeObject(bb, obj);
        }
    }

    protected Object decodeObject(ByteBuffer bb) throws EncodingException {
        int start = bb.getIndex();
        int type = bb.decodeUint16le();
        if (type == 10) {
            int len = bb.decodeUint16le();
            NtlmAccount acct = new NtlmAccount(this);
            for (int i = 0; i < len; ++i) {
                Object key = this.decodeObject(bb);
                Object val = this.decodeObject(bb);
                if (val == DUPLICATE_REFERENCE) {
                    val = key;
                }
                acct.put(key, val);
            }
            return acct;
        }
        if (type == 11) {
            int len = bb.decodeUint16le();
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            for (int i = 0; i < len; ++i) {
                Object key = this.decodeObject(bb);
                Object val = this.decodeObject(bb);
                if (val == DUPLICATE_REFERENCE) {
                    val = key;
                }
                m.put(key, val);
            }
            return m;
        }
        bb.setIndex(start);
        return super.decodeObject(bb);
    }

    public Object exportState() throws SecurityProviderException {
        if (this.sessionSecurityWrap != null || this.sessionSecurityUnwrap != null) {
            throw new SecurityProviderException(0, "Provider state cannot be exported after session security has been initialized.");
        }
        try {
            ByteBuffer bb = new ByteBuffer();
            bb.encodeUint32le((int)this.getPropertyAsLong("ntlmssp.flags", 0L));
            bb.encodeUint16le(this.state);
            bb.encodeUint16le(0);
            this.encodeObject(bb, this.serverChallenge);
            this.encodeObject(bb, this.targetInformation);
            this.encodeObject(bb, this.sessionKey);
            this.encodeObject(bb, this.identity);
            this.encodeObject(bb, this.account);
            this.encodeObject(bb, this);
            return bb.getBuffer();
        }
        catch (EncodingException ee) {
            throw new SecurityProviderException(0, "Failed to export state", ee);
        }
    }

    public void importState(Object ostate) throws SecurityProviderException {
        byte[] bytes;
        if (ostate != null && (bytes = (byte[])ostate).length > 0) {
            try {
                ByteBuffer bb = new ByteBuffer(bytes, 0, bytes.length);
                this.put("ntlmssp.flags", "0x" + Hexdump.toHexString((int)bb.decodeUint32le(), (int)8));
                this.state = bb.decodeUint16le();
                this.isComplete = (this.state & 0xF) >= 3;
                bb.decodeUint16le();
                this.serverChallenge = (byte[])this.decodeObject(bb);
                this.targetInformation = (byte[])this.decodeObject(bb);
                this.sessionKey = (byte[])this.decodeObject(bb);
                this.identity = (String)this.decodeObject(bb);
                this.account = (NtlmAccount)this.decodeObject(bb);
                HashMap m = (HashMap)this.decodeObject(bb);
                this.putAll(m);
                return;
            }
            catch (EncodingException ee) {
                throw new SecurityProviderException(0, "Failed to import state", ee);
            }
        }
        throw new SecurityProviderException(0, "Failed to import state");
    }

    protected byte[] getTargetInformation() throws SecurityProviderException {
        if (this.targetInformation == null || this.targetInformation.length == 0) {
            NtlmsspListElem addressList = new NtlmsspListElem(2, (String)this.getProperty("domain.netbios.name"), new NtlmsspListElem(1, (String)this.getProperty("localhost.netbios.name"), new NtlmsspListElem(4, (String)this.getProperty("domain.dns.name"), new NtlmsspListElem(3, (String)this.getProperty("localhost.dns.name"), new NtlmsspListElem(0, "", null)))));
            try {
                this.targetInformation = addressList.toByteArray(0);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SecurityProviderException(0, uee.getMessage());
            }
        }
        return this.targetInformation;
    }

    private String getServiceDomain() throws SecurityProviderException {
        String domain = (String)this.get("domain.dns.name");
        if (domain == null || domain.trim().length() == 0) {
            domain = null;
            String acctname = (String)this.get("service.acctname");
            if (acctname != null) {
                domain = new SecurityPrincipal(acctname).getDomain();
            }
        }
        return domain;
    }

    private PasswordCredential getServiceCredential() {
        block3: {
            if (this.serviceCredential == null) {
                try {
                    this.serviceCredential = new PasswordCredential((String)this.getProperty("service.acctname"), ((String)this.getProperty("service.password")).toCharArray());
                }
                catch (SecurityProviderException spe) {
                    if (LogStream.level < 4) break block3;
                    this.log.println("NtlmSecurityProvider: Failed to retrieve service credentials: " + spe.getMessage());
                }
            }
        }
        return this.serviceCredential;
    }

    public byte[] initSecContext(byte[] token, int off, int len) throws SecurityProviderException {
        Iterator<PasswordCredential> iter;
        PasswordCredential cred = null;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && (iter = subject.getPrivateCredentials(PasswordCredential.class).iterator()).hasNext()) {
            cred = iter.next();
        }
        if (cred == null) {
            boolean sc = this.serviceCredential == null;
            cred = this.getServiceCredential();
            if (sc) {
                if (LogStream.level >= 4) {
                    this.log.println("NtlmSecurityProvider: No credentials found in JAAS Subject, using service credentials");
                }
            }
        }
        if (cred == null) {
            throw new SecurityProviderException(0, "Failed to acquire credentials for authentication");
        }
        return this.initSecContext0(token, off, len, cred);
    }

    private byte[] initSecContext0(byte[] token, int off, int len, PasswordCredential cred) throws SecurityProviderException {
        int flags = (int)this.getPropertyAsLong("ntlmssp.flags", 0L);
        String domainName = null;
        if (off != 0) {
            byte[] tmp = new byte[len];
            System.arraycopy(token, off, tmp, 0, len);
            token = tmp;
        }
        try {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                }
                case 1: {
                    NtlmsspNegotiateMessage nnm = new NtlmsspNegotiateMessage();
                    nnm.negotiateFlags = flags;
                    ByteBuffer dst = new ByteBuffer();
                    nnm.encode(dst);
                    token = dst.toByteArray();
                    this.state = 2;
                    break;
                }
                case 2: {
                    char[] passwordChars;
                    NtlmsspChallengeMessage ncm = new NtlmsspChallengeMessage();
                    ByteBuffer src = new ByteBuffer(token, 0, token.length);
                    ncm.decode(src);
                    this.serverChallenge = ncm.serverChallenge;
                    flags &= ncm.negotiateFlags;
                    flags &= 0xFDFFFFFF;
                    flags &= 0xFFFBFFFF;
                    flags &= 0xFFFDFFFF;
                    flags &= 0xFFFEFFFF;
                    flags |= 0x2000000;
                    SecurityPrincipal p = cred.getSecurityPrincipal();
                    String name = p.getName();
                    if (name.indexOf(92) >= 0) {
                        domainName = p.getDomain();
                        name = p.getUsername();
                    }
                    if ((passwordChars = cred.getPassword()) == null) {
                        throw new SecurityProviderException(2, "A password is required");
                    }
                    NtlmsspAuthenticateMessage nam = new NtlmsspAuthenticateMessage();
                    nam.negotiateFlags = flags;
                    nam.domainName = domainName != null ? domainName : "";
                    nam.userName = name;
                    nam.workstation = (String)this.getProperty("localhost.netbios.name");
                    String password = new String(passwordChars);
                    byte[] responseKeyNT = NtlmPasswordAuthentication.nTOWFv2((String)nam.domainName, (String)nam.userName, (String)password);
                    byte[] clientChallenge = new byte[8];
                    random.nextBytes(clientChallenge);
                    long nanos1601 = (System.currentTimeMillis() + 11644473600000L) * 10000L;
                    nam.lmChallengeResponse = NtlmConstants.Z24;
                    nam.ntChallengeResponse = NtlmPasswordAuthentication.getNTLMv2Response((byte[])responseKeyNT, (byte[])this.serverChallenge, (byte[])clientChallenge, (long)nanos1601, (byte[])ncm.targetInfo);
                    nam.encryptedRandomSessionKey = null;
                    if ((flags & 0x10) != 0) {
                        HMACT64 hmac = new HMACT64(responseKeyNT);
                        hmac.update(nam.ntChallengeResponse, 0, 16);
                        this.sessionKey = hmac.digest();
                        nam.encryptedRandomSessionKey = this.sessionKey;
                        if ((flags & 0x40000000) != 0) {
                            byte[] masterKey = new byte[16];
                            random.nextBytes(masterKey);
                            byte[] exchangedKey = new byte[16];
                            try {
                                Cipher rc4 = Cipher.getInstance("RC4");
                                rc4.init(1, new SecretKeySpec(this.sessionKey, "RC4"));
                                rc4.update(masterKey, 0, 16, exchangedKey, 0);
                            }
                            catch (GeneralSecurityException gse) {
                                throw new SecurityProviderException(0, "Failed to encrypt exchange key", gse);
                            }
                            nam.encryptedRandomSessionKey = exchangedKey;
                            this.sessionKey = masterKey;
                        }
                    }
                    ByteBuffer dst = new ByteBuffer();
                    nam.encode(dst);
                    token = dst.toByteArray();
                    if ((flags & 0x80000) != 0 && (flags & 0x10) != 0) {
                        if (this.sessionKey == null) {
                            throw new SecurityProviderException(0, "Cannot perform signing or sealing if an NTLMSSP sessionKey is not established");
                        }
                        if (LogStream.level >= 4) {
                            this.log.println("NtlmSecurityProvider: Extended Session Security key negotiated successfully");
                        }
                    }
                    if (LogStream.level >= 4) {
                        this.log.println("NtlmSecurityProvider: Initiator negotiated NTLMv2");
                    }
                    this.identity = name;
                    this.serverChallenge = null;
                    this.targetInformation = null;
                    this.isComplete = true;
                    this.state = 3;
                    break;
                }
                case 3: {
                    this.state = 4;
                    throw new SecurityProviderException(2, "Authentication failed");
                }
                default: {
                    throw new IOException("Invalid state");
                }
            }
            this.put("ntlmssp.flags", "0x" + Hexdump.toHexString((int)flags, (int)8));
            return token;
        }
        catch (IOException ioe) {
            this.state = 4;
            throw new SecurityProviderException(0, ioe.getMessage(), ioe);
        }
    }

    public byte[] acceptSecContext(byte[] token, int off, int len) throws SecurityProviderException {
        int flags = (int)this.getPropertyAsLong("ntlmssp.flags", 0L);
        Object domainName = null;
        if (off != 0) {
            byte[] tmp = new byte[len];
            System.arraycopy(token, off, tmp, 0, len);
            token = tmp;
        }
        try {
            switch (this.state) {
                case 0: {
                    this.state = 17;
                }
                case 17: {
                    NtlmsspNegotiateMessage nnm = new NtlmsspNegotiateMessage();
                    ByteBuffer src = new ByteBuffer(token, 0, token.length);
                    nnm.decode(src);
                    flags &= nnm.negotiateFlags;
                    if (LogStream.level >= 4 && nnm.version != null) {
                        this.log.println("NtlmSecurityProvider: NEGOTIATE_MESSAGE.version: " + nnm.version);
                    }
                    this.serverChallenge = new byte[8];
                    random.nextBytes(this.serverChallenge);
                    if ((flags & 1) != 0) {
                        flags &= 0xFFFFFFFD;
                    }
                    flags |= 0x2000000;
                    if (((flags |= 0x10000) & 0x80000) != 0) {
                        flags |= 0x800000;
                    }
                    ByteBuffer dst = new ByteBuffer();
                    NtlmsspChallengeMessage ncm = new NtlmsspChallengeMessage();
                    ncm.targetName = (String)this.getProperty("domain.netbios.name");
                    ncm.negotiateFlags = flags;
                    ncm.serverChallenge = this.serverChallenge;
                    ncm.targetInfo = this.getTargetInformation();
                    ncm.encode(dst);
                    token = dst.toByteArray();
                    this.state = 18;
                    this.setProperty("ntlmssp.challenge.flags", "0x" + Hexdump.toHexString((int)flags, (int)8));
                    if (LogStream.level < 4) break;
                    this.log.println("NtlmSecurityProvider: Negotiated NTLMSSP flags: 0x" + Hexdump.toHexString((int)flags, (int)8));
                    break;
                }
                case 18: {
                    int canonicalForm;
                    NtlmsspAuthenticateMessage nam = new NtlmsspAuthenticateMessage();
                    nam.negotiateFlags = flags = (int)this.getPropertyAsLong("ntlmssp.challenge.flags", 0L);
                    ByteBuffer src = new ByteBuffer(token, 0, token.length);
                    nam.decode(src);
                    token = null;
                    this.state = 20;
                    byte[] sessionNonce = new byte[16];
                    System.arraycopy(this.serverChallenge, 0, sessionNonce, 0, 8);
                    System.arraycopy(nam.lmChallengeResponse, 0, sessionNonce, 8, nam.lmChallengeResponse.length < 8 ? 0 : 8);
                    if (nam.userName.length() == 0) {
                        throw new SecurityProviderException(1, "Invalid account name");
                    }
                    if (LogStream.level >= 4) {
                        this.log.println("NtlmSecurityProvider: NTLMSSP principal: DomainName=" + nam.domainName + " UserName=" + nam.userName + " Workstation=" + nam.workstation);
                    }
                    this.put("ntlmssp.account.name", nam.userName);
                    NtlmResponse ntlmResponse = new NtlmResponse(nam.domainName, nam.userName, this.serverChallenge, sessionNonce, this.targetInformation, nam.lmChallengeResponse, nam.ntChallengeResponse, flags);
                    this.authenticate(ntlmResponse);
                    if ((flags & 0x80000) != 0 && (flags & 0x10) != 0) {
                        byte[] userSessionKey = ntlmResponse.sessionKey;
                        if (LogStream.level >= 5) {
                            this.log.println("NtlmSecurityProvider: Generating NTLM2 Session Security keys");
                        }
                        this.sessionKey = userSessionKey;
                        if (this.sessionKey == null) {
                            throw new SecurityProviderException(0, "Cannot perform signing or sealing if an NTLMSSP sessionKey is not established");
                        }
                        if ((flags & 0x40000000) != 0) {
                            byte[] exchangedKey = nam.encryptedRandomSessionKey;
                            byte[] masterKey = new byte[16];
                            if (LogStream.level >= 5) {
                                this.log.println("NtlmSecurityProvider: Decrypting Key Exchange session key");
                            }
                            try {
                                Cipher rc4 = Cipher.getInstance("RC4");
                                rc4.init(2, new SecretKeySpec(this.sessionKey, "RC4"));
                                rc4.update(exchangedKey, 0, 16, masterKey, 0);
                            }
                            catch (GeneralSecurityException gse) {
                                throw new SecurityProviderException(0, "Failed to decrypt exchange key", gse);
                            }
                            this.sessionKey = masterKey;
                        }
                        if (LogStream.level >= 4) {
                            this.log.println("NtlmSecurityProvider: NTLM2 Session Security key negotiated successfully");
                        }
                    } else if (LogStream.level >= 5) {
                        this.log.println("NtlmSecurityProvider: NTLM2 Session Security was not negotiated");
                    }
                    if (LogStream.level >= 4) {
                        if (nam.ntChallengeResponse.length > 24) {
                            this.log.println("NtlmSecurityProvider: Acceptor negotiated NTLMv2");
                        } else {
                            this.log.println("NtlmSecurityProvider: Acceptor negotiated NTLMv1");
                        }
                    }
                    if ((canonicalForm = (int)this.getPropertyAsLong("account.canonicalForm", 0L)) == 0 || canonicalForm == 4 && nam.userName.indexOf(64) >= 0) {
                        this.identity = nam.userName;
                    } else {
                        Account acct = this.getAccount(null, null);
                        this.identity = this.canonicalizeAccountName((String)acct.getProperty("domain.dns.name"), (String)acct.getProperty("sAMAccountName"), canonicalForm);
                    }
                    this.serverChallenge = null;
                    this.targetInformation = null;
                    this.isComplete = true;
                    this.state = 19;
                    break;
                }
                default: {
                    throw new IOException("Invalid state");
                }
            }
            this.put("ntlmssp.flags", "0x" + Hexdump.toHexString((int)flags, (int)8));
            return token;
        }
        catch (IOException ioe) {
            if (LogStream.level >= 1) {
                ioe.printStackTrace(this.log);
            }
            throw new SecurityProviderException(0, ioe.getMessage(), ioe);
        }
    }

    public boolean isComplete() {
        try {
            if (this.getPropertyAsBoolean("anonymous", false)) {
                return true;
            }
        }
        catch (SecurityProviderException securityProviderException) {
            // empty catch block
        }
        return this.isComplete;
    }

    String canonicalizeDomainName(String dname, int canonicalForm) throws SecurityProviderException {
        Domain domain = this.getDomain(dname, null);
        if (canonicalForm == 3) {
            return (String)domain.get("domain.netbios.name");
        }
        if (canonicalForm == 4) {
            return (String)domain.get("domain.dns.name");
        }
        throw new SecurityProviderException(0, "Unsupported domain name canonical form: " + canonicalForm);
    }

    String canonicalizeAccountName(String dname, String uname, int canonicalForm) throws SecurityProviderException {
        SecurityPrincipal securityPrincipal = new SecurityPrincipal(dname, uname);
        if (canonicalForm == 0) {
            return securityPrincipal.getName();
        }
        if (canonicalForm == 1) {
            throw new SecurityProviderException(0, "DN account name canonicalization currently not supported");
        }
        if (canonicalForm == 2) {
            return securityPrincipal.getUsername();
        }
        if (canonicalForm == 3) {
            dname = this.canonicalizeDomainName(securityPrincipal.getDomain(), 3);
            return dname + '\\' + securityPrincipal.getUsername();
        }
        if (canonicalForm == 4) {
            dname = this.canonicalizeDomainName(securityPrincipal.getDomain(), 4);
            return securityPrincipal.getUsername() + '@' + dname;
        }
        throw new SecurityProviderException(0, "Unsupported account name canonical form: " + canonicalForm);
    }

    boolean isPropertiesChanged(Map props, String[] keys) throws SecurityProviderException {
        for (int ki = 0; ki < keys.length; ++ki) {
            String key = keys[ki];
            Object val = this.getProperty(key, NO_PROPERTY);
            if (props.containsKey(key) != (val != NO_PROPERTY)) {
                return true;
            }
            if (!props.containsKey(key) || props.get(key).equals(val)) continue;
            return true;
        }
        return false;
    }

    Netlogon getNetlogonInstance() throws SecurityProviderException {
        if (netlogonInstances == null) {
            netlogonInstances = new NetlogonMap(7200L, 1800L);
        }
        String bname = (String)this.getProperty("bindstr.host");
        String lname = (String)this.getProperty("localhost.netbios.name");
        String nlname = (bname + '/' + lname).toUpperCase();
        Netlogon nl = (Netlogon)netlogonInstances.get(nlname);
        if (propertiesChangedExpiration < System.currentTimeMillis()) {
            if (nl != null && this.isPropertiesChanged(nl, NETLOGON_KEYS)) {
                if (LogStream.level >= 3) {
                    this.log.println("NtlmSecurityProvider: NETLOGON properties appear to have changed - rebuilding connection");
                }
                nl.disconnect(false);
                nl = null;
            }
            propertiesChangedExpiration = System.currentTimeMillis() + this.getPropertyAsLong("propertiesChanged.expiration", 5000L);
        }
        if (nl == null) {
            HashMap _properties = Properties.getFilteredProperties(this, NETLOGON_KEYS);
            nl = new Netlogon(nlname, _properties);
            netlogonInstances.put(nlname, nl);
        }
        return nl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(Object credential) throws SecurityProviderException {
        block16: {
            block15: {
                if (credential instanceof NtlmResponse) {
                    Object object = LOCK;
                    synchronized (object) {
                        NtlmResponse resp = (NtlmResponse)credential;
                        if (resp.username == null || resp.username.trim().length() == 0) {
                            throw new SecurityProviderException(1, "A username was not supplied");
                        }
                        try {
                            byte[] userSessionKey = new byte[16];
                            NtlmAccount acct = new NtlmAccount(this);
                            this.getNetlogonInstance().validate(resp, userSessionKey, acct);
                            resp.sessionKey = userSessionKey;
                            this.account = acct;
                            return;
                        }
                        catch (IOException ioe) {
                            if (LogStream.level >= 1) {
                                ioe.printStackTrace(this.log);
                            }
                            throw new SecurityProviderException(0, "NETLOGON failure", ioe);
                        }
                    }
                }
                if (!(credential instanceof PasswordCredential)) break block15;
                NtlmSecurityProvider initiator = new NtlmSecurityProvider((Map)this);
                initiator.serviceCredential = (PasswordCredential)credential;
                byte[] token = new byte[]{};
                try {
                    while (!this.isComplete()) {
                        token = initiator.initSecContext(token, 0, token.length);
                        token = this.acceptSecContext(token, 0, token.length);
                    }
                    initiator.serviceCredential = null;
                }
                catch (Throwable throwable) {
                    initiator.serviceCredential = null;
                    initiator.dispose();
                    if (token != null) {
                        for (int i = 0; i < token.length; ++i) {
                            token[i] = 0;
                        }
                    }
                    throw throwable;
                }
                initiator.dispose();
                if (token != null) {
                    for (int i = 0; i < token.length; ++i) {
                        token[i] = 0;
                    }
                }
                break block16;
            }
            throw new SecurityProviderException(0, "Unsupported credential type");
        }
    }

    public void dispose() throws SecurityProviderException {
        this.state = 255;
        this.serverChallenge = null;
        this.targetInformation = null;
        this.sessionKey = null;
        if (this.serviceCredential != null) {
            this.serviceCredential.destroy();
            this.serviceCredential = null;
        }
        this.sessionSecurityWrap = null;
        this.sessionSecurityUnwrap = null;
    }

    NtlmSessionSecurity getSessionSecurity(boolean isClientToServer) throws SecurityProviderException {
        int flags;
        if (this.sessionKey != null && ((flags = (int)this.getPropertyAsLong("ntlmssp.flags", 0L)) & 0x80000) != 0 && (flags & 0x10) != 0) {
            boolean doSealing = (flags & 0x20) != 0;
            boolean doKeyExch = (flags & 0x40000000) != 0;
            return new NtlmSessionSecurity(this, isClientToServer, doSealing, doKeyExch);
        }
        throw new SecurityProviderException(0, "Session security is not available");
    }

    public void wrap(ByteBuffer outgoing) throws SecurityProviderException {
        if (this.sessionSecurityWrap == null) {
            this.sessionSecurityWrap = this.getSessionSecurity((this.state & 0xF0) != 16);
        }
        this.sessionSecurityWrap.wrap(outgoing);
    }

    public void unwrap(ByteBuffer incoming) throws SecurityProviderException {
        if (this.sessionSecurityUnwrap == null) {
            this.sessionSecurityUnwrap = this.getSessionSecurity((this.state & 0xF0) == 16);
        }
        this.sessionSecurityUnwrap.unwrap(incoming);
    }

    private boolean isSubsetOf(String[] a, String[] subset) {
        for (int si = 0; si < subset.length; ++si) {
            int ai;
            for (ai = 0; ai < a.length && !subset[si].equals(a[ai]); ++ai) {
            }
            if (ai != a.length) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain getDomain(String dname, String[] attrs) throws SecurityProviderException {
        if (attrs != null && !this.isSubsetOf(_DOMAIN_ATTRS, attrs)) {
            throw new SecurityProviderException(0, "Currently not supported, attrs must be null or default set");
        }
        if (dname == null) {
            dname = "~";
        }
        Object object = LOCK;
        synchronized (object) {
            Netlogon netlogon2 = null;
            Domain ret = null;
            try {
                netlogon2 = this.getNetlogonInstance();
                ret = netlogon2.getDomainTrust(dname, 3);
            }
            catch (IOException ioe) {
                if (LogStream.level >= 1) {
                    ioe.printStackTrace(this.log);
                }
                throw new SecurityProviderException(0, "Failed to retrieve NETLOGON domain trust information", ioe);
            }
            if (ret == null) {
                throw new SecurityProviderException(4, "Domain not found: " + dname);
            }
            return ret;
        }
    }

    public Account getAccount(String acctname, String[] attrs) throws SecurityProviderException {
        if (acctname != null) {
            throw new SecurityProviderException(0, "Currently not implemented, acctname must be null");
        }
        if (attrs != null && !this.isSubsetOf(_ACCOUNT_ATTRS, attrs)) {
            throw new SecurityProviderException(0, "Currently not supported, attrs must be null or default set");
        }
        return this.account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void translateNamesToSids(String[] names, SID[] sids) throws SecurityProviderException {
        int cacheCount = 0;
        String nbtName = (String)this.getProperty("domain.netbios.name");
        Object object = LOCK;
        synchronized (object) {
            for (int i = 0; i < names.length; ++i) {
                try {
                    SecurityPrincipal sp = new SecurityPrincipal(nbtName, names[i]);
                    String cname = sp.getCanonicalName(3).toUpperCase();
                    sids[i] = sidCache.get(cname);
                    if (sids[i] == null) continue;
                    if (sids[i] == NOSID) {
                        sids[i] = null;
                    }
                    ++cacheCount;
                    continue;
                }
                catch (SecurityProviderException spe) {
                    // empty catch block
                }
            }
        }
        if (cacheCount == names.length) {
            if (LogStream.level >= 4) {
                this.log.println("translateNamesToSids: Found all " + names.length + " SIDs in cache, MS-RPC names to SIDs lookup skipped");
            }
            return;
        }
        IOException e = null;
        int retry = 2;
        while (retry-- > 0) {
            Object object2 = LOCK;
            synchronized (object2) {
                String authority;
                Netlogon nl;
                block36: {
                    nl = this.getNetlogonInstance();
                    authority = (String)nl.getProperty("authority.dns.name");
                    if (LogStream.level >= 4) {
                        this.log.println("translateNamesToSids: Translating names to SIDs with " + authority);
                    }
                    try {
                        Dns dns = Dns.getInstance(this);
                        Dns.DnsRecordA dra = (Dns.DnsRecordA)dns.getRecordByName(authority, "A");
                        authority = dra.address;
                    }
                    catch (DnsException de) {
                        if (LogStream.level < 2) break block36;
                        this.log.println("translateNamesToSids: Failed to resolve authority with DNS: " + authority);
                    }
                }
                try {
                    int ni;
                    String endpoint = "ncacn_np:" + authority + "[\\PIPE\\lsarpc]";
                    NtlmPasswordAuthentication serviceAuth = new NtlmPasswordAuthentication(null, (String)this.getProperty("service.acctname"), (String)this.getProperty("service.password"));
                    DcerpcHandle lhandle = null;
                    LsaPolicyHandle phandle = null;
                    UnicodeString[] unames = new UnicodeString[names.length];
                    for (ni = 0; ni < names.length; ++ni) {
                        unames[ni] = new UnicodeString(names[ni], false);
                    }
                    lhandle = DcerpcHandle.getHandle((String)endpoint, (NtlmPasswordAuthentication)serviceAuth);
                    phandle = new LsaPolicyHandle(lhandle, null, 0x2000000);
                    MsrpcLsarLookupNames rpc2 = new MsrpcLsarLookupNames(phandle, unames);
                    lhandle.sendrecv((DcerpcMessage)rpc2);
                    if (rpc2.retval == -1073741709) {
                        if (LogStream.level >= 2) {
                            this.log.println("translateNamesToSids: Failed to resolve name: " + names[0]);
                        }
                        for (ni = 0; ni < names.length; ++ni) {
                            SecurityPrincipal sp = new SecurityPrincipal(nbtName, names[ni]);
                            String cname = sp.getCanonicalName(3).toUpperCase();
                            if (LogStream.level >= 4) {
                                this.log.println("translateNamesToSids: Adding negative SID to cache: " + cname);
                            }
                            sidCache.put(cname, NOSID);
                        }
                        return;
                    }
                    if (rpc2.retval != 0 && rpc2.retval != 263) {
                        throw new SmbException(rpc2.retval, false);
                    }
                    SID[] domain_sids = new SID[rpc2.referenced_domains.count];
                    for (int di = 0; di < domain_sids.length; ++di) {
                        domain_sids[di] = new SID(rpc2.referenced_domains.domains[di].sid, 3, null, null, false);
                    }
                    for (int si = 0; si < rpc2.translated_sids.count; ++si) {
                        String cname = this.canonicalizeAccountName(null, names[si], 3).toUpperCase();
                        lsarpc.LsarTranslatedSid tsid = rpc2.translated_sids.sids[si];
                        if (tsid.sid_index >= 0 && tsid.sid_index < domain_sids.length) {
                            sids[si] = new SID(domain_sids[tsid.sid_index], tsid.rid);
                            if (LogStream.level >= 4) {
                                this.log.println("translateNamesToSids: Adding SID to cache: " + cname + ": " + sids[si]);
                            }
                            sidCache.put(cname, sids[si]);
                            continue;
                        }
                        sids[si] = null;
                        if (LogStream.level >= 2) {
                            this.log.println("translateNamesToSids: Failed to resolve name: " + names[si]);
                        }
                        if (LogStream.level >= 4) {
                            this.log.println("translateNamesToSids: Adding negative SID to cache: " + cname);
                        }
                        sidCache.put(cname, NOSID);
                    }
                    return;
                    finally {
                        if (lhandle != null) {
                            if (phandle != null) {
                                phandle.close();
                            }
                            lhandle.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    e = ioe;
                    nl.disconnect(true);
                }
            }
        }
        throw new SecurityProviderException(0, "Failed to translate names to SIDs.", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = LOCK = new Object();
        synchronized (object) {
            InetAddress laddr = null;
            String hostname = null;
            try {
                laddr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
            if (laddr != null) {
                DEFAULT_LOCALHOST_DNS_NAME = hostname = laddr.getHostName();
                int dot = hostname.indexOf(46);
                if (dot > 0) {
                    hostname = hostname.substring(0, dot);
                }
                if (hostname.length() > 15) {
                    hostname = hostname.substring(0, 15);
                }
                hostname = hostname.toUpperCase();
            }
            if (hostname == null) {
                hostname = "JESPA_";
                if (laddr != null) {
                    byte[] addr = laddr.getAddress();
                    hostname = hostname + (addr[addr.length - 1] & 0xFF) + "_";
                }
                hostname = hostname + Hexdump.toHexString((int)((int)(Math.random() * 255.0)), (int)2);
            }
            DEFAULT_LOCALHOST_NETBIOS_NAME = hostname;
        }
        _DOMAIN_ATTRS = new String[]{"domain.dns.name", "domain.netbios.name", "objectSid", "objectGUID"};
        _ACCOUNT_ATTRS = new String[]{"sAMAccountName", "objectSid"};
    }

    static class NtlmsspListElem {
        int type;
        String name;
        NtlmsspListElem next;

        NtlmsspListElem(int type, String name, NtlmsspListElem next) {
            this.type = type;
            this.name = name;
            this.next = next;
        }

        byte[] toByteArray(int off) throws UnsupportedEncodingException {
            byte[] ret;
            byte[] data;
            if (this.next == null) {
                this.type = 0;
                data = new byte[]{};
                ret = new byte[off + 4];
            } else {
                data = this.name.getBytes("UnicodeLittleUnmarked");
                ret = this.next.toByteArray(off + 4 + data.length);
            }
            Encdec.enc_uint16le((short)((short)this.type), (byte[])ret, (int)off);
            Encdec.enc_uint16le((short)((short)data.length), (byte[])ret, (int)(off + 2));
            System.arraycopy(data, 0, ret, off + 4, data.length);
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NetlogonMap<K, V>
    extends CacheMap<K, V> {
        public NetlogonMap(long expiration, long period) {
            super("NtlmSecurityProvider: netlogonInstances", expiration, period);
        }

        @Override
        protected void dispose(V val) {
            if (val instanceof Netlogon) {
                Netlogon nl = (Netlogon)val;
                nl.disconnect(false);
            }
        }
    }
}

