/*
 * Decompiled with CFR 0.152.
 */
package jespa.ntlm;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import jcifs.util.Encdec;
import jcifs.util.HMACT64;
import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.ntlm.NtlmSecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.LogStream;

class NtlmSessionSecurity {
    static final byte[] CLIENT_TO_SERVER_SIGNING = "session key to client-to-server signing key magic constant\u0000".getBytes();
    static final byte[] SERVER_TO_CLIENT_SIGNING = "session key to server-to-client signing key magic constant\u0000".getBytes();
    static final byte[] CLIENT_TO_SERVER_SEALING = "session key to client-to-server sealing key magic constant\u0000".getBytes();
    static final byte[] SERVER_TO_CLIENT_SEALING = "session key to server-to-client sealing key magic constant\u0000".getBytes();
    NtlmSecurityProvider provider;
    boolean doSealing = false;
    boolean doKeyExch = false;
    byte[] signingKey;
    byte[] sealingKey;
    int _seqNum = 0;
    Cipher rc4;

    static byte[] computeKey(byte[] sessionKey, byte[] constant) throws GeneralSecurityException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(sessionKey);
        md5.update(constant);
        return md5.digest();
    }

    NtlmSessionSecurity(NtlmSecurityProvider provider, boolean isClientToServer, boolean doSealing, boolean doKeyExch) throws SecurityProviderException {
        this.provider = provider;
        this.doSealing = doSealing;
        this.doKeyExch = doKeyExch;
        try {
            this.signingKey = NtlmSessionSecurity.computeKey(provider.sessionKey, isClientToServer ? CLIENT_TO_SERVER_SIGNING : SERVER_TO_CLIENT_SIGNING);
            this.sealingKey = NtlmSessionSecurity.computeKey(provider.sessionKey, isClientToServer ? CLIENT_TO_SERVER_SEALING : SERVER_TO_CLIENT_SEALING);
            this.rc4 = Cipher.getInstance("RC4");
            this.rc4.init(1, new SecretKeySpec(this.sealingKey, "RC4"));
        }
        catch (GeneralSecurityException gse) {
            LogStream cfr_ignored_0 = provider.log;
            if (LogStream.level >= 1) {
                gse.printStackTrace(provider.log);
            }
            throw new SecurityProviderException(0, "Failed to compute NTLM signing and sealing keys", gse);
        }
    }

    byte[] computeSignature(byte[] data, int off, int len) throws GeneralSecurityException {
        byte[] signature = new byte[16];
        Encdec.enc_uint32le((int)1, (byte[])signature, (int)0);
        Encdec.enc_uint32le((int)this._seqNum, (byte[])signature, (int)12);
        HMACT64 hmac = new HMACT64(this.signingKey);
        hmac.update(signature, 12, 4);
        hmac.update(data, off, len);
        System.arraycopy(hmac.digest(), 0, signature, 4, 8);
        return signature;
    }

    void wrap(ByteBuffer outgoing) throws SecurityProviderException {
        byte[] buf = outgoing.getBuffer();
        int off = outgoing.getStart();
        int len = outgoing.getLength();
        try {
            byte[] signature = this.computeSignature(buf, off, len);
            if (this.doSealing) {
                this.rc4.update(buf, off, len, buf, off);
            }
            outgoing.setIndex(16);
            outgoing.encodeBytes(buf, off, len);
            outgoing.setIndex(0);
            if (this.doKeyExch) {
                this.rc4.update(signature, 4, 8, signature, 4);
            }
            outgoing.encodeBytes(signature, 0, signature.length);
            outgoing.setIndex(0);
            ++this._seqNum;
        }
        catch (GeneralSecurityException gse) {
            throw new SecurityProviderException(0, "Failed to compute NTLMSSP_MESSAGE_SIGNATURE", gse);
        }
        catch (EncodingException ee) {
            throw new SecurityProviderException(0, "NTLMSSP wrap encoding failure", ee);
        }
    }

    void unwrap(ByteBuffer incoming) throws SecurityProviderException {
        byte[] buf = incoming.getBuffer();
        int off = incoming.getStart() + 16;
        int len = incoming.getLength() - 16;
        try {
            byte[] signature = new byte[16];
            incoming.decodeBytes(signature, 0, 16);
            if (this.doSealing) {
                this.rc4.update(buf, off, len, buf, off);
            }
            byte[] signatureExpected = this.computeSignature(buf, off, len);
            if (this.doKeyExch) {
                this.rc4.update(signatureExpected, 4, 8, signatureExpected, 4);
            }
            if (!Arrays.equals(signature, signatureExpected)) {
                throw new SecurityProviderException(0, "Failed to validate NTLMSSP_MESSAGE_SIGNATURE");
            }
            incoming.setStart();
            incoming.shift(0, false);
            ++this._seqNum;
        }
        catch (GeneralSecurityException gse) {
            throw new SecurityProviderException(0, "Failed to compute expected NTLMSSP_MESSAGE_SIGNATURE", gse);
        }
        catch (EncodingException ee) {
            throw new SecurityProviderException(0, "NTLMSSP unwrap decoding failure", ee);
        }
    }
}

