/*
 * Decompiled with CFR 0.152.
 */
package jespa.ntlm;

import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.ntlm.NtlmsspMessage;

class NtlmsspAuthenticateMessage
extends NtlmsspMessage {
    byte[] lmChallengeResponse;
    byte[] ntChallengeResponse;
    String domainName;
    String userName;
    String workstation;
    byte[] encryptedRandomSessionKey;

    NtlmsspAuthenticateMessage() {
    }

    void encode(ByteBuffer dst) throws EncodingException {
        ByteBuffer payload = dst.derive(72);
        dst.encodeBytes(SIGNATURE, 0, SIGNATURE.length);
        dst.encodeUint32le(3);
        this.encodeBuffer(dst, payload, this.lmChallengeResponse);
        this.encodeBuffer(dst, payload, this.ntChallengeResponse);
        this.encodeString(dst, payload, this.domainName);
        this.encodeString(dst, payload, this.userName);
        this.encodeString(dst, payload, this.workstation);
        this.encodeBuffer(dst, payload, this.encryptedRandomSessionKey);
        dst.encodeUint32le(this.negotiateFlags);
        dst.encodeBytes(VERSION, 0, VERSION.length);
    }

    void decode(ByteBuffer src) throws EncodingException {
        this.decodeSignature(src);
        if (src.decodeUint32le() != 3) {
            throw new EncodingException("Not a Type 3 message (NTLMSSP_AUTHENTICATE_MESSAGE)");
        }
        ByteBuffer payload = src.derive(0);
        this.lmChallengeResponse = this.decodeBuffer(src, payload);
        this.ntChallengeResponse = this.decodeBuffer(src, payload);
        this.domainName = this.decodeString(src, payload);
        this.userName = this.decodeString(src, payload);
        this.workstation = this.decodeString(src, payload);
        this.encryptedRandomSessionKey = this.decodeBuffer(src, payload);
        this.negotiateFlags = src.decodeUint32le();
        if ((this.negotiateFlags & 0x2000000) != 0) {
            this.decodeVersion(src);
        }
    }
}

