/*
 * Decompiled with CFR 0.152.
 */
package jespa.ntlm;

import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.ntlm.NtlmsspMessage;

class NtlmsspChallengeMessage
extends NtlmsspMessage {
    String targetName;
    byte[] serverChallenge;
    byte[] targetInfo;

    NtlmsspChallengeMessage() {
    }

    void encode(ByteBuffer dst) throws EncodingException {
        ByteBuffer payload = dst.derive(56);
        dst.encodeBytes(SIGNATURE, 0, SIGNATURE.length);
        dst.encodeUint32le(2);
        this.encodeString(dst, payload, this.targetName);
        dst.encodeUint32le(this.negotiateFlags);
        dst.encodeBytes(this.serverChallenge, 0, 8);
        dst.encodeBytes(Z8, 0, Z8.length);
        this.encodeBuffer(dst, payload, this.targetInfo);
        dst.encodeBytes(VERSION, 0, VERSION.length);
    }

    void decode(ByteBuffer src) throws EncodingException {
        this.decodeSignature(src);
        if (src.decodeUint32le() != 2) {
            throw new EncodingException("Not a Type 2 message (NTLMSSP_CHALLENGE_MESSAGE)");
        }
        ByteBuffer flags = src.derive(20);
        this.negotiateFlags = flags.decodeUint32le();
        ByteBuffer payload = src.derive(0);
        this.targetName = this.decodeString(src, payload);
        src.advance(4);
        this.serverChallenge = new byte[8];
        src.decodeBytes(this.serverChallenge, 0, 8);
        src.advance(8);
        this.targetInfo = this.decodeBuffer(src, payload);
        if ((this.negotiateFlags & 0x2000000) != 0) {
            this.decodeVersion(src);
        }
    }
}

