/*
 * Decompiled with CFR 0.152.
 */
package jespa.ntlm;

import java.io.UnsupportedEncodingException;
import jcifs.util.Hexdump;
import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.ntlm.NtlmConstants;

abstract class NtlmsspMessage
implements NtlmConstants {
    int negotiateFlags;
    String version = null;

    NtlmsspMessage() {
    }

    void encodeBuffer(ByteBuffer dst, ByteBuffer payload, byte[] buf) throws EncodingException {
        int len = buf == null ? 0 : buf.length;
        dst.encodeUint16le(len);
        dst.encodeUint16le(len);
        dst.encodeUint32le(payload.getIndex());
        if (buf != null) {
            payload.encodeBytes(buf, 0, buf.length);
        }
    }

    byte[] decodeBuffer(ByteBuffer src, ByteBuffer payload) throws EncodingException {
        int len = src.decodeUint16le();
        int max = src.decodeUint16le();
        int off = src.decodeUint32le();
        if (len > Short.MAX_VALUE || len > 0 && off >= src.getLength()) {
            throw new EncodingException("Invalid NTLMSSP buffer: len=0x" + Hexdump.toHexString((int)len, (int)8) + ",off=0x" + Hexdump.toHexString((int)off, (int)8));
        }
        byte[] ret = new byte[len];
        payload.setIndex(off);
        payload.decodeBytes(ret, 0, len);
        return ret;
    }

    String decodeString(ByteBuffer src, ByteBuffer payload) throws EncodingException {
        byte[] buf = this.decodeBuffer(src, payload);
        try {
            if (this.negotiateFlags == 0) {
                throw new EncodingException("Negotiate flags are not set");
            }
            if ((this.negotiateFlags & 2) != 0) {
                return new String(buf);
            }
            return new String(buf, "UTF-16LE");
        }
        catch (UnsupportedEncodingException uee) {
            throw new EncodingException("Failed to decode NTLMSSP string", uee);
        }
    }

    void encodeString(ByteBuffer dst, ByteBuffer payload, String str) throws EncodingException {
        try {
            if (this.negotiateFlags == 0) {
                throw new EncodingException("Negotiate flags are not set");
            }
            if ((this.negotiateFlags & 2) != 0) {
                this.encodeBuffer(dst, payload, str.getBytes());
            } else {
                this.encodeBuffer(dst, payload, str.getBytes("UTF-16LE"));
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new EncodingException("Failed to encode NTLMSSP string", uee);
        }
    }

    void decodeSignature(ByteBuffer src) throws EncodingException {
        byte[] buf = src.getBuffer();
        for (int si = 0; si < SIGNATURE.length; ++si) {
            if (buf[si] == SIGNATURE[si]) continue;
            throw new EncodingException("Invalid NTLMSSP signature");
        }
        src.advance(SIGNATURE.length);
    }

    void decodeVersion(ByteBuffer src) throws EncodingException {
        byte productMajorVersion = src.decodeUint8();
        byte productMinorVersion = src.decodeUint8();
        int productBuild = src.decodeUint16le();
        src.advance(3);
        byte ntlmRevisionCurrent = src.decodeUint8();
        this.version = productMajorVersion + "." + productMinorVersion + "." + productBuild + "." + ntlmRevisionCurrent;
    }
}

