/*
 * Decompiled with CFR 0.152.
 */
package jespa.ntlm;

import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.ntlm.NtlmsspMessage;

class NtlmsspNegotiateMessage
extends NtlmsspMessage {
    NtlmsspNegotiateMessage() {
    }

    void encode(ByteBuffer dst) throws EncodingException {
        dst.encodeBytes(SIGNATURE, 0, SIGNATURE.length);
        dst.encodeUint32le(1);
        dst.encodeUint32le(this.negotiateFlags);
        dst.encodeBytes(Z8, 0, Z8.length);
        dst.encodeBytes(Z8, 0, Z8.length);
        dst.encodeBytes(VERSION, 0, VERSION.length);
    }

    void decode(ByteBuffer src) throws EncodingException {
        this.decodeSignature(src);
        if (src.decodeUint32le() != 1) {
            throw new EncodingException("Not a Type 1 message (NTLMSSP_NEGOTIATE_MESSAGE)");
        }
        ByteBuffer payload = src.derive(0);
        this.negotiateFlags = src.decodeUint32le();
        this.decodeString(src, payload);
        boolean isMalformed = false;
        if ((this.negotiateFlags & 0x2000) == 0 && src.getRemaining() < 8) {
            isMalformed = true;
        }
        if (!isMalformed) {
            this.decodeString(src, payload);
        }
        if ((this.negotiateFlags & 0x2000000) != 0) {
            this.decodeVersion(src);
        }
    }
}

