/*
 * Decompiled with CFR 0.152.
 */
package jespa.sasl;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import jcifs.util.Hexdump;
import jespa.io.ByteBuffer;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.LogStream;

public class SaslServer
implements javax.security.sasl.SaslServer {
    static LogStream log = null;
    protected String mechanismName;
    protected SecurityProvider provider;

    public SaslServer(String mechanismName, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        this.mechanismName = mechanismName;
        String classname = (String)props.get("provider.classname");
        if (classname == null) {
            classname = "jespa.ntlm.NtlmSecurityProvider";
        }
        HashMap properties = new HashMap();
        for (String name : props.keySet()) {
            if (name.startsWith("jespa.")) {
                properties.put(name.substring(6), props.get(name));
                continue;
            }
            if (!name.startsWith("jcifs.")) continue;
            properties.put(name, props.get(name));
        }
        try {
            Class<?> klass = Class.forName(classname);
            Constructor<?> providerConstructor = klass.getConstructor(Map.class);
            this.provider = (SecurityProvider)providerConstructor.newInstance(properties);
        }
        catch (Exception ex) {
            log = LogStream.getInstance();
            if (LogStream.level >= 1) {
                ex.printStackTrace(log);
            }
            throw new SaslException("Failed to instantiate SecurityProvider: " + classname, ex);
        }
        log = LogStream.getInstance();
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            return this.provider.acceptSecContext(response, 0, response.length);
        }
        catch (SecurityProviderException spe) {
            throw new SaslException(spe.getMessage(), spe);
        }
    }

    public boolean isComplete() {
        return this.provider.isComplete();
    }

    public String getAuthorizationID() {
        try {
            return this.provider.getIdentity();
        }
        catch (SecurityProviderException securityProviderException) {
            return null;
        }
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        try {
            ByteBuffer bb = new ByteBuffer();
            bb.encodeBytes(incoming, offset, len);
            bb.setIndex(0);
            this.provider.unwrap(bb);
            byte[] ret = bb.toByteArray();
            if (LogStream.level >= 4) {
                log.println("SaslServer: unwrap: " + ret.length);
                if (LogStream.level >= 5) {
                    Hexdump.hexdump((PrintStream)log, (byte[])ret, (int)0, (int)(ret.length < 256 ? ret.length : 256));
                }
            }
            return ret;
        }
        catch (Exception e) {
            if (LogStream.level >= 1) {
                e.printStackTrace(log);
            }
            throw new SaslException("Jespa SASL unwrap failure", e);
        }
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        try {
            ByteBuffer bb = new ByteBuffer();
            bb.encodeBytes(outgoing, offset, len);
            bb.setIndex(0);
            this.provider.wrap(bb);
            byte[] ret = bb.toByteArray();
            if (LogStream.level >= 4) {
                log.println("SaslServer:   wrap: " + ret.length);
                if (LogStream.level >= 5) {
                    Hexdump.hexdump((PrintStream)log, (byte[])ret, (int)0, (int)(ret.length < 256 ? ret.length : 256));
                }
            }
            return ret;
        }
        catch (Exception e) {
            if (LogStream.level >= 1) {
                e.printStackTrace(log);
            }
            throw new SaslException("Jespa SASL wrap failure", e);
        }
    }

    public Object getNegotiatedProperty(String propName) {
        String ret;
        block8: {
            ret = null;
            if (!this.isComplete()) {
                throw new IllegalStateException("SASL authentication is not complete");
            }
            if (propName.equals("javax.security.sasl.qop")) {
                try {
                    if (this.provider.getIdentity() == null) break block8;
                    if (this.provider.getFlag("confidentiality")) {
                        ret = "auth-conf";
                        break block8;
                    }
                    if (this.provider.getFlag("integrity")) {
                        ret = "auth-int";
                        break block8;
                    }
                    ret = "auth";
                }
                catch (SecurityProviderException securityProviderException) {}
            } else if (this.provider.containsKey(propName)) {
                ret = (String)this.provider.get(propName);
            }
        }
        return ret;
    }

    public void dispose() throws SaslException {
    }
}

