/*
 * Decompiled with CFR 0.152.
 */
package jespa.security;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.security.Account;
import jespa.security.Domain;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.Csv;
import jespa.util.LogStream;

public class ChainSecurityProvider
extends SecurityProvider {
    SecurityProvider provider;
    LogStream log;

    public ChainSecurityProvider(Map properties) {
        block4: {
            super(properties);
            this.provider = null;
            this.log = LogStream.getInstance();
            try {
                String[] names = (String[])this.getProperty("chain.names.array");
                for (int ni = 0; ni < names.length; ++ni) {
                    String pname = "chain." + names[ni] + ".service.password";
                    if (!this.containsKey(pname)) continue;
                    this.setProperty(pname, this.remove(pname));
                }
            }
            catch (SecurityProviderException spe) {
                if (LogStream.level < 1) break block4;
                spe.printStackTrace(this.log);
            }
        }
        if (LogStream.level >= 4) {
            this.log.println("ChainSecurityProvider: " + properties.get("chain.names"));
        }
    }

    public void setProperty(String name, Object obj) throws SecurityProviderException {
        if (name.startsWith("chain.")) {
            if (name.endsWith(".service.password")) {
                super.setEncryptedProperty(name, (String)obj, null);
            } else {
                super.setProperty(name, obj);
            }
            return;
        }
        SecurityProvider sp = this.getSecurityProvider();
        sp.setProperty(name, obj);
    }

    public Object getProperty(String name, Object def) throws SecurityProviderException {
        Object ret = NO_PROPERTY;
        if (name.startsWith("chain.")) {
            ret = super.getProperty(name, NO_PROPERTY);
            if (ret == NO_PROPERTY && name.equals("chain.names.array")) {
                String str = (String)this.getProperty("chain.names");
                String[] names = null;
                try {
                    names = Csv.parseRow(str, ',', 5);
                }
                catch (IOException ioe) {
                    throw new SecurityProviderException(0, "Failed to parse property value: " + name, ioe);
                }
                if (names == null || names.length == 0) {
                    throw new SecurityProviderException(0, "Invalid property value: " + name);
                }
                this.put("chain.names.array", names);
                ret = names;
            }
        } else {
            SecurityProvider sp = this.getSecurityProvider();
            ret = sp.getProperty(name, NO_PROPERTY);
        }
        if (ret == NO_PROPERTY) {
            return def;
        }
        return ret;
    }

    SecurityProvider newSecurityProvider(String name, Map properties) throws SecurityProviderException {
        name = name.toUpperCase();
        String prefix = "chain." + name + ".";
        if (properties == null) {
            properties = new HashMap();
            for (String key : this.keySet()) {
                String pkey;
                if (!key.startsWith(prefix) || (pkey = key.substring(prefix.length())).equals("provider.classname")) continue;
                properties.put(pkey, this.get(key));
            }
        }
        String classname = (String)this.getProperty(prefix + "provider.classname");
        try {
            Class<?> klass = Class.forName(classname);
            Constructor<?> providerConstructor = klass.getConstructor(Map.class);
            SecurityProvider ret = (SecurityProvider)providerConstructor.newInstance(properties);
            ret.put("chain.name", name);
            if (LogStream.level >= 4) {
                this.log.println("ChainSecurityProvider: Selected chain provider " + name);
            }
            return ret;
        }
        catch (Exception ex) {
            throw new SecurityProviderException(0, "Failed to load SecurityProvider: " + classname, ex);
        }
    }

    protected void encodeObject(ByteBuffer bb, Object obj) throws EncodingException {
        if (obj instanceof ChainSecurityProvider) {
            HashMap m = (HashMap)((HashMap)obj).clone();
            Iterator iter = m.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (!"chain.names.array".equals(key)) continue;
                iter.remove();
            }
            super.encodeObject(bb, m);
        } else {
            super.encodeObject(bb, obj);
        }
    }

    public Object exportState() throws SecurityProviderException {
        try {
            ByteBuffer bb = new ByteBuffer();
            if (this.provider == null) {
                this.encodeObject(bb, null);
            } else {
                this.encodeObject(bb, this.provider.get("chain.name"));
                this.encodeObject(bb, (byte[])this.provider.exportState());
            }
            this.encodeObject(bb, this);
            return bb.getBuffer();
        }
        catch (EncodingException ee) {
            throw new SecurityProviderException(0, "Failed to export state", ee);
        }
    }

    public void importState(Object ostate) throws SecurityProviderException {
        byte[] bytes;
        if (ostate != null && (bytes = (byte[])ostate).length > 0) {
            try {
                ByteBuffer bb = new ByteBuffer(bytes, 0, bytes.length);
                String name = (String)this.decodeObject(bb);
                if (name != null) {
                    Object state = this.decodeObject(bb);
                    this.provider = this.newSecurityProvider(name, null);
                    this.provider.importState(state);
                }
                HashMap props = (HashMap)this.decodeObject(bb);
                this.putAll(props);
                return;
            }
            catch (EncodingException ee) {
                throw new SecurityProviderException(0, "Failed to import state", ee);
            }
        }
        throw new SecurityProviderException(0, "Failed to import state");
    }

    public SecurityProvider getSecurityProvider() throws SecurityProviderException {
        if (this.provider == null) {
            String[] names = (String[])this.getProperty("chain.names.array");
            this.provider = this.newSecurityProvider(names[0], null);
        }
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityProvider nextSecurityProvider(String msg) throws SecurityProviderException {
        if (this.provider != null) {
            String name = (String)this.provider.getProperty("chain.name");
            String[] names = (String[])this.getProperty("chain.names.array");
            for (int ni = 0; ni < names.length; ++ni) {
                Object var7_6;
                if (!name.equalsIgnoreCase(names[ni])) continue;
                try {
                    try {
                        this.provider.dispose();
                    }
                    catch (SecurityProviderException spe1) {
                        var7_6 = null;
                        this.provider = null;
                    }
                    var7_6 = null;
                    this.provider = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    this.provider = null;
                    throw throwable;
                }
                if (++ni >= names.length) continue;
                if (LogStream.level >= 3) {
                    msg = msg == null ? "" : msg + ": ";
                    this.log.println("ChainSecurityProvider: " + msg + "Selecting new chain provider: " + names[ni]);
                }
                this.provider = this.newSecurityProvider(names[ni], null);
            }
        }
        return this.provider;
    }

    public String getName() throws SecurityProviderException {
        SecurityProvider sp = this.getSecurityProvider();
        return sp.getName();
    }

    public boolean getFlag(String name) throws SecurityProviderException {
        SecurityProvider sp = this.getSecurityProvider();
        return sp.getFlag(name);
    }

    public void setFlag(String name, boolean value) throws SecurityProviderException {
        SecurityProvider sp = this.getSecurityProvider();
        sp.setFlag(name, value);
    }

    public Domain getDomain(String dname, String[] attrs) throws SecurityProviderException {
        SecurityProvider sp = this.getSecurityProvider();
        return sp.getDomain(dname, attrs);
    }

    public Account getAccount(String acctname, String[] attrs) throws SecurityProviderException {
        SecurityProvider sp = this.getSecurityProvider();
        return sp.getAccount(acctname, attrs);
    }

    public String getIdentity() throws SecurityProviderException {
        return this.provider == null ? null : this.provider.getIdentity();
    }

    public boolean isComplete() {
        return this.provider == null ? false : this.provider.isComplete();
    }

    public byte[] acceptSecContext(byte[] token, int off, int len) throws SecurityProviderException {
        SecurityProviderException spe = null;
        SecurityProvider sp = this.getSecurityProvider();
        while (sp != null) {
            String msg = null;
            if (sp.getFlag("capabilities.accept.ntlmssp") || sp.getFlag("capabilities.accept.spnego")) {
                try {
                    return sp.acceptSecContext(token, off, len);
                }
                catch (SecurityProviderException spe0) {
                    spe = spe0;
                    if (LogStream.level >= 4) {
                        spe.printStackTrace(this.log);
                    }
                    msg = "Authentication failed: " + spe.getMessage();
                }
            }
            try {
                this.provider.dispose();
            }
            catch (SecurityProviderException spe1) {
                // empty catch block
            }
            sp = this.nextSecurityProvider(msg);
        }
        throw spe;
    }

    public void authenticate(Object credential) throws SecurityProviderException {
        SecurityProviderException spe = null;
        SecurityProvider sp = this.getSecurityProvider();
        while (sp != null) {
            String msg = null;
            try {
                sp.authenticate(credential);
                return;
            }
            catch (SecurityProviderException spe0) {
                spe = spe0;
                if (LogStream.level >= 4) {
                    spe.printStackTrace(this.log);
                }
                msg = "Login failed: " + spe.getMessage();
                try {
                    sp.dispose();
                }
                catch (SecurityProviderException spe1) {
                    // empty catch block
                }
                sp = this.nextSecurityProvider(msg);
            }
        }
        throw spe;
    }

    public void dispose() throws SecurityProviderException {
        if (this.provider != null) {
            this.provider.dispose();
        }
    }
}

