/*
 * Decompiled with CFR 0.152.
 */
package jespa.security;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import jcifs.Config;
import jespa.security.Credential;
import jespa.security.PasswordCredential;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;

public class LoginModule
implements javax.security.auth.spi.LoginModule {
    static final String SSNAME = "javax.security.auth.login.name";
    static final String SSPASSWORD = "javax.security.auth.login.password";
    SecurityProvider provider;
    Subject subject;
    CallbackHandler callbackHandler;
    Map sharedState;
    Map options;
    StringBuffer acctname;
    char[] password;
    Object credential;
    int state = 0;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.acctname = null;
        this.password = null;
        this.credential = null;
    }

    protected boolean getOptionAsBoolean(String name, boolean def) {
        Object val = this.options.get(name);
        if (val != null && val instanceof String) {
            return "true".equalsIgnoreCase((String)val);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        boolean getFromSharedState = this.getOptionAsBoolean("tryFirstPass", false) || this.getOptionAsBoolean("useFirstPass", false);
        while (true) {
            Object var4_4;
            try {
                this.attemptLogin(getFromSharedState);
                this.state = 1;
                boolean bl = true;
                var4_4 = null;
                this.cleanState();
                return bl;
            }
            catch (LoginException le) {
                try {
                    if (!getFromSharedState) {
                        throw le;
                    }
                    getFromSharedState = false;
                    var4_4 = null;
                    this.cleanState();
                    continue;
                }
                catch (Throwable throwable) {
                    var4_4 = null;
                    this.cleanState();
                    throw throwable;
                }
            }
            break;
        }
    }

    /*
     * Loose catch block
     */
    private void attemptLogin(boolean getFromSharedState) throws LoginException {
        block19: {
            String name = (String)this.options.get("principal");
            if (name != null) {
                this.acctname = new StringBuffer(name);
            } else {
                this.acquireAcctname(getFromSharedState);
            }
            this.acquirePassword(getFromSharedState);
            for (String key : this.options.keySet()) {
                if (!key.startsWith("jcifs.")) continue;
                Config.setProperty((String)key, (String)((String)this.options.get(key)));
            }
            String classname = (String)this.options.get("provider.classname");
            if (classname == null) {
                classname = "jespa.ntlm.NtlmSecurityProvider";
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String key : this.options.keySet()) {
                if (!key.startsWith("jespa.")) continue;
                String param = (String)this.options.get(key);
                properties.put(key.substring(6), param);
            }
            Class<?> clas = Class.forName(classname);
            Constructor<?> providerConstructor = clas.getConstructor(Map.class);
            this.provider = (SecurityProvider)providerConstructor.newInstance(properties);
            this.credential = new PasswordCredential(this.acctname.toString(), this.password);
            this.provider.authenticate(this.credential);
            Object var9_12 = null;
            if (this.provider == null) break block19;
            try {
                this.provider.dispose();
            }
            catch (SecurityProviderException spe) {
                // empty catch block
            }
            this.provider = null;
            {
                break block19;
                catch (SecurityProviderException spe) {
                    LoginException le;
                    if (this.credential != null) {
                        if (this.credential instanceof Credential) {
                            ((Credential)this.credential).destroy();
                        }
                        this.credential = null;
                    }
                    switch (spe.getCode()) {
                        case 1: 
                        case 2: {
                            le = new FailedLoginException(spe.getMessage());
                            break;
                        }
                        default: {
                            le = new LoginException("Failed to validate password credential");
                        }
                    }
                    le.initCause(spe);
                    throw le;
                }
                catch (Exception e) {
                    LoginException le = new LoginException("Failed to validate password credential");
                    le.initCause(e);
                    throw le;
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (this.provider != null) {
                    try {
                        this.provider.dispose();
                    }
                    catch (SecurityProviderException spe) {
                        // empty catch block
                    }
                    this.provider = null;
                }
                throw throwable;
            }
        }
    }

    private void cleanState() {
        if (this.state > 0 && this.getOptionAsBoolean("storePass", false) && !this.sharedState.containsKey(SSNAME) && !this.sharedState.containsKey(SSPASSWORD)) {
            this.sharedState.put(SSNAME, this.acctname.toString());
            this.sharedState.put(SSPASSWORD, this.password);
        }
        if (this.acctname != null) {
            this.acctname.delete(0, this.acctname.length());
        }
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
        }
        this.acctname = null;
        this.password = null;
    }

    private void acquireAcctname(boolean getFromSharedState) throws LoginException {
        this.acctname = new StringBuffer("");
        if (getFromSharedState) {
            String name = (String)this.sharedState.get(SSNAME);
            if (name == null || name.trim().length() == 0) {
                throw new LoginException("Failed to acquire account name from shared state");
            }
            this.acctname.insert(0, name.trim());
            return;
        }
        if (this.getOptionAsBoolean("doNotPrompt", false)) {
            throw new LoginException("Failed to acquire account name");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler is set");
        }
        try {
            String defaultName = System.getProperty("user.name");
            NameCallback nameCallback = new NameCallback("Enter account name [" + defaultName + "]: ");
            Callback[] callbacks = new Callback[]{nameCallback};
            this.callbackHandler.handle(callbacks);
            String name = nameCallback.getName();
            if (name == null || name.trim().length() == 0) {
                name = defaultName;
            }
            this.acctname.insert(0, name.trim());
        }
        catch (Exception e) {
            LoginException le = new LoginException("Failed to acquire account name");
            le.initCause(e);
            throw le;
        }
    }

    private void acquirePassword(boolean getFromSharedState) throws LoginException {
        this.password = null;
        if (getFromSharedState) {
            this.password = (char[])this.sharedState.get(SSPASSWORD);
            if (this.password == null) {
                throw new LoginException("Failed to acquire password from shared state");
            }
            return;
        }
        if (this.getOptionAsBoolean("doNotPrompt", false)) {
            throw new LoginException("Failed to acquire password");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler is set");
        }
        try {
            PasswordCallback passwordCallback = new PasswordCallback("Enter password for " + this.acctname + ": ", false);
            Callback[] callbacks = new Callback[]{passwordCallback};
            this.callbackHandler.handle(callbacks);
            this.password = passwordCallback.getPassword();
            if (this.password == null) {
                this.password = new char[0];
            }
            passwordCallback.clearPassword();
        }
        catch (Exception e) {
            LoginException le = new LoginException("Failed to acquire password");
            le.initCause(e);
            throw le;
        }
    }

    public boolean commit() throws LoginException {
        if (this.state > 0) {
            this.subject.getPrivateCredentials().add(this.credential);
            this.state = 2;
            return true;
        }
        return false;
    }

    public boolean abort() throws LoginException {
        if (this.state > 0) {
            this.logout();
            return true;
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (this.state > 0) {
            if (this.credential instanceof Credential) {
                ((Credential)this.credential).destroy();
            }
            this.credential = null;
            this.state = 0;
        }
        return true;
    }
}

