/*
 * Decompiled with CFR 0.152.
 */
package jespa.security;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jcifs.dcerpc.rpc;
import jcifs.smb.SID;
import jcifs.util.Base64;
import jcifs.util.Hexdump;
import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.security.SecurityProviderException;
import jespa.util.LogStream;

public class Properties
extends HashMap {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";
    private static final byte[] ZEROS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] SECRET_KEY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final Object NO_PROPERTY = new Object();
    protected static final Object DUPLICATE_REFERENCE = new Object();

    public static Map getFilteredProperties(Map properties, String[] keys) {
        HashMap ret = new HashMap();
        for (int ki = 0; ki < keys.length; ++ki) {
            String key = keys[ki];
            if (!properties.containsKey(key)) continue;
            ret.put(key, properties.get(key));
        }
        return ret;
    }

    public static HashMap getFilteredProperties(Properties in, String[] keys) throws SecurityProviderException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (int ki = 0; ki < keys.length; ++ki) {
            Object val = in.getProperty(keys[ki], NO_PROPERTY);
            if (val == NO_PROPERTY) continue;
            ret.put(keys[ki], val);
        }
        return ret;
    }

    public Properties() {
    }

    public Properties(Map properties, String[] keys) throws SecurityProviderException {
        super(keys == null ? properties : (properties instanceof Properties ? Properties.getFilteredProperties((Properties)properties, keys) : Properties.getFilteredProperties(properties, keys)));
    }

    public Properties(Map properties) {
        super(properties);
    }

    protected void encodeObject(ByteBuffer bb, Object obj) throws EncodingException {
        int type = -1;
        int len = -1;
        byte[] data = null;
        if (obj == null) {
            type = 0;
            len = -1;
        } else if (obj instanceof byte[]) {
            type = 1;
            data = (byte[])obj;
            len = data.length;
        } else if (obj instanceof String) {
            type = 2;
            try {
                data = ((String)obj).getBytes("UTF-8");
                len = data.length;
            }
            catch (UnsupportedEncodingException uee) {}
        } else if (obj instanceof SID) {
            type = 3;
            data = SID.toByteArray((rpc.sid_t)((SID)obj));
            len = data.length;
        } else {
            if (obj instanceof HashMap) {
                HashMap hmap = (HashMap)obj;
                bb.encodeUint16le(4);
                bb.encodeUint16le(hmap.size());
                for (Object key : hmap.keySet()) {
                    Object val;
                    if (key == (val = hmap.get(key))) {
                        val = DUPLICATE_REFERENCE;
                    }
                    this.encodeObject(bb, key);
                    this.encodeObject(bb, val);
                }
                return;
            }
            if (obj == DUPLICATE_REFERENCE) {
                type = 5;
                len = -1;
            } else {
                throw new EncodingException("Unsupported object type: " + obj.getClass());
            }
        }
        bb.encodeUint16le(type);
        bb.encodeUint16le(len);
        if (len > 0) {
            bb.encodeBytes(data, 0, len);
        }
    }

    protected Object decodeObject(ByteBuffer bb) throws EncodingException {
        int type = bb.decodeUint16le();
        int len = bb.decodeUint16le();
        if (type == -1 || type == 0) {
            return null;
        }
        if (type == 1 || type == 2 || type == 3) {
            if (len < 0) {
                LogStream log = LogStream.getInstance();
                if (LogStream.level >= 4) {
                    log.println("Invalid object length: len=" + len);
                    log.println(bb.toString());
                    bb.hexdump(log, 0, bb.getLength());
                }
                throw new EncodingException("Invalid object length: len=" + len);
            }
            byte[] ret = new byte[len];
            bb.decodeBytes(ret, 0, len);
            if (type == 2) {
                try {
                    return new String(ret, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                }
            } else if (type == 3) {
                return new SID(ret, 0);
            }
            return ret;
        }
        if (type == 4) {
            HashMap<Object, Object> hmap = new HashMap<Object, Object>();
            for (int i = 0; i < len; ++i) {
                Object key = this.decodeObject(bb);
                Object val = this.decodeObject(bb);
                if (val == DUPLICATE_REFERENCE) {
                    val = key;
                }
                hmap.put(key, val);
            }
            return hmap;
        }
        if (type == 5) {
            return DUPLICATE_REFERENCE;
        }
        throw new EncodingException("Unknown object type: 0x" + Hexdump.toHexString((int)type, (int)4));
    }

    public void setProperty(String name, Object obj) throws SecurityProviderException {
        this.put(name, obj);
    }

    public Object getProperty(String name, Object def) throws SecurityProviderException {
        if (this.containsKey(name)) {
            return this.get(name);
        }
        return def;
    }

    public Object getProperty(String name) throws SecurityProviderException {
        Object ret = this.getProperty(name, NO_PROPERTY);
        if (ret != NO_PROPERTY) {
            return ret;
        }
        throw new SecurityProviderException(0, "Property not set or constructed: " + name);
    }

    public long getPropertyAsLong(String name, long def) throws SecurityProviderException {
        Object ret = this.getProperty(name, NO_PROPERTY);
        if (ret != NO_PROPERTY) {
            String p = (String)ret;
            if (p == null) {
                throw new SecurityProviderException(0, "Cannot parse null as numeric value: " + name);
            }
            try {
                if (p.startsWith("0x")) {
                    return Long.parseLong(p.substring(2), 16);
                }
                return Long.parseLong(p);
            }
            catch (NumberFormatException nfe) {
                throw new SecurityProviderException(0, nfe.getMessage(), nfe);
            }
        }
        return def;
    }

    public boolean getPropertyAsBoolean(String name, boolean def) throws SecurityProviderException {
        Object ret = this.getProperty(name, NO_PROPERTY);
        if (ret != NO_PROPERTY) {
            String p = (String)ret;
            return "true".equalsIgnoreCase(p) || "1".equals(p) || "yes".equalsIgnoreCase(p);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncryptedProperty(String name, String value, Object salt) throws SecurityProviderException {
        if (salt == null) {
            salt = name;
        }
        int saltcode = salt.hashCode();
        byte[] saltbytes = new byte[8];
        for (int si = 0; si < saltbytes.length; ++si) {
            saltbytes[si] = (byte)(saltcode & 0xFF);
            saltcode >>= 4;
        }
        try {
            byte[] vbytes = value.getBytes("UTF-8");
            byte[] src = new byte[saltbytes.length + vbytes.length];
            System.arraycopy(saltbytes, 0, src, 0, saltbytes.length);
            System.arraycopy(vbytes, 0, src, saltbytes.length, vbytes.length);
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(ZEROS);
            byte[] byArray = SECRET_KEY;
            synchronized (SECRET_KEY) {
                while (SECRET_KEY[0] == 0) {
                    SecureRandom random = new SecureRandom();
                    random.nextBytes(SECRET_KEY);
                }
                // ** MonitorExit[var10_12] (shouldn't be in output)
                c.init(1, (Key)new SecretKeySpec(SECRET_KEY, "AES"), iv);
                byte[] e1 = c.doFinal(src, 0, src.length);
                byte[] enc = new byte[8 + e1.length];
                System.arraycopy(src, 0, enc, 0, 8);
                System.arraycopy(e1, 0, enc, 8, e1.length);
                this.setProperty(name + ".encrypted", Base64.encode((byte[])enc));
            }
        }
        catch (Exception e) {
            throw new SecurityProviderException(0, "Failed to encrypt property: " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEncryptedProperty(String name, Object def) throws SecurityProviderException {
        Object encrypted = this.getProperty(name + ".encrypted", NO_PROPERTY);
        if (encrypted == NO_PROPERTY) {
            return def;
        }
        try {
            byte[] enc = Base64.decode((String)((String)encrypted));
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(ZEROS);
            byte[] byArray = SECRET_KEY;
            synchronized (SECRET_KEY) {
                while (SECRET_KEY[0] == 0) {
                    SecureRandom random = new SecureRandom();
                    random.nextBytes(SECRET_KEY);
                }
                // ** MonitorExit[var7_8] (shouldn't be in output)
                c.init(2, (Key)new SecretKeySpec(SECRET_KEY, "AES"), iv);
                byte[] src = c.doFinal(enc, 8, enc.length - 8);
                return new String(src, 8, src.length - 8, "UTF-8");
            }
        }
        catch (Exception e) {
            throw new SecurityProviderException(0, "Failed to decrypt property: " + name, e);
        }
    }
}

