/*
 * Decompiled with CFR 0.152.
 */
package jespa.security;

import com.sun.security.auth.callback.TextCallbackHandler;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import jespa.security.Credential;
import jespa.security.PasswordCredential;
import jespa.security.SecurityProviderException;

public class RunAs {
    static final Random RANDOM = new Random();

    public static Object runAs(PrivilegedExceptionAction action, Object credential, String moduleName, Map options) throws Exception {
        String principalName = null;
        PasswordCredentialCallbackHandler callbackHandler = null;
        if (credential instanceof PasswordCredential) {
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            principalName = passwordCredential.getSecurityPrincipal().getUsername();
            callbackHandler = new PasswordCredentialCallbackHandler(passwordCredential);
        } else if (credential != null) {
            throw new SecurityProviderException(0, "Credential type not supported");
        }
        return RunAs.runAs(action, principalName, moduleName, options, callbackHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runAs(PrivilegedExceptionAction action, String principalName, String moduleName, Map options, CallbackHandler callbackHandler) throws Exception {
        Object t;
        RunAsConfiguration config = new RunAsConfiguration(moduleName, options);
        if (principalName != null) {
            config.options.put("principal", principalName);
        }
        LoginContext lc = new LoginContext(config.name, null, callbackHandler != null ? callbackHandler : new TextCallbackHandler(), config);
        lc.login();
        try {
            t = Subject.doAs(lc.getSubject(), action);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            lc.logout();
            throw throwable;
        }
        lc.logout();
        return t;
    }

    public static Object runAs(PrivilegedExceptionAction action, Object credential, Principal principal) throws Exception {
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(credential);
        if (credential instanceof Credential) {
            principal = ((Credential)credential).getSecurityPrincipal();
        }
        if (principal != null) {
            subject.getPrincipals().add(principal);
        }
        return Subject.doAs(subject, action);
    }

    public static Object runAs(PrivilegedExceptionAction action, Object credential) throws Exception {
        return RunAs.runAs(action, credential, null);
    }

    static class PasswordCredentialCallbackHandler
    implements CallbackHandler {
        PasswordCredential credential;

        PasswordCredentialCallbackHandler(PasswordCredential credential) {
            this.credential = credential;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int ci = 0; ci < callbacks.length; ++ci) {
                Callback cb = callbacks[ci];
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.credential.getSecurityPrincipal().getUsername());
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    ((PasswordCallback)cb).setPassword(this.credential.getPassword());
                    continue;
                }
                throw new UnsupportedCallbackException(cb);
            }
        }
    }

    static class RunAsConfiguration
    extends Configuration {
        String name;
        Map options;
        AppConfigurationEntry[] entries;

        RunAsConfiguration(String moduleName, Map options) {
            this.name = moduleName + "." + RANDOM.nextInt();
            this.options = options != null ? options : new HashMap();
            this.entries = new AppConfigurationEntry[1];
            this.entries[0] = new AppConfigurationEntry(moduleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.options);
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            if (name.equals(this.name)) {
                return this.entries;
            }
            return null;
        }

        public void refresh() {
        }
    }
}

