/*
 * Decompiled with CFR 0.152.
 */
package jespa.security;

import java.security.Principal;
import jespa.ldap.LdapSecurityProvider;
import jespa.security.SecurityProviderException;

public class SecurityPrincipal
implements Principal {
    protected int canonicalForm = 2;
    protected String domain;
    protected String name;

    public SecurityPrincipal(String acctname) throws SecurityProviderException {
        this(null, acctname);
    }

    public SecurityPrincipal(String dname, String uname) throws SecurityProviderException {
        if (LdapSecurityProvider.parseDn(uname, null, null)) {
            dname = null;
            this.canonicalForm = 1;
        } else {
            int ci = uname.indexOf(64);
            if (ci >= 0) {
                this.canonicalForm = 4;
                dname = uname.substring(ci + 1);
                uname = uname.substring(0, ci);
            } else {
                ci = uname.indexOf(92);
                if (ci >= 0) {
                    this.canonicalForm = 3;
                    dname = uname.substring(0, ci);
                    uname = uname.substring(ci + 1);
                }
            }
        }
        if (dname != null) {
            if ((dname = dname.trim()).length() == 0) {
                dname = null;
            }
            if (dname == null) {
                this.canonicalForm = 2;
            }
        }
        if (uname != null && (uname = uname.trim()).length() == 0) {
            uname = null;
        }
        if (uname == null) {
            throw new SecurityProviderException(0, "Invalid account name");
        }
        this.domain = dname;
        this.name = uname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.name;
    }

    public String getName() {
        try {
            return this.getCanonicalName(this.canonicalForm);
        }
        catch (SecurityProviderException securityProviderException) {
            return null;
        }
    }

    public String getCanonicalName(int form) throws SecurityProviderException {
        switch (form) {
            case 1: {
                if (this.canonicalForm != 1) {
                    throw new SecurityProviderException(0, "Not a DN");
                }
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return (this.domain == null ? "" : this.domain) + '\\' + this.name;
            }
            case 4: {
                return this.name + '@' + (this.domain == null ? "" : this.domain);
            }
        }
        throw new SecurityProviderException(0, "Unsupported canonical form");
    }

    public int getCanonicalForm() {
        return this.canonicalForm;
    }

    public int hashCode() {
        int hc = this.name.hashCode();
        if (this.domain != null) {
            hc *= this.domain.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecurityPrincipal) {
            SecurityPrincipal p = (SecurityPrincipal)obj;
            if (this.name.equalsIgnoreCase(p.name)) {
                if (this.domain == null && p.domain == null) {
                    return true;
                }
                return this.domain != null && p.domain != null && this.domain.equalsIgnoreCase(p.domain);
            }
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

