/*
 * Decompiled with CFR 0.152.
 */
package jespa.security;

import java.net.MalformedURLException;
import java.util.Map;
import jcifs.util.Hexdump;
import jespa.dns.Dns;
import jespa.dns.DnsException;
import jespa.io.ByteBuffer;
import jespa.ldap.LdapUrl;
import jespa.security.Account;
import jespa.security.Domain;
import jespa.security.Properties;
import jespa.security.SecurityProviderException;
import jespa.util.LogStream;

public abstract class SecurityProvider
extends Properties {
    protected String identity;
    protected boolean isComplete;

    public SecurityProvider(Map properties) {
        block3: {
            super(properties);
            this.identity = null;
            this.isComplete = false;
            if (this.containsKey("service.password")) {
                try {
                    this.setProperty("service.password", this.remove("service.password"));
                }
                catch (SecurityProviderException spe) {
                    LogStream log = LogStream.getInstance();
                    if (LogStream.level < 1) break block3;
                    spe.printStackTrace(log);
                }
            }
        }
    }

    public SecurityProvider(Map properties, String[] pnames) throws SecurityProviderException {
        block3: {
            super(properties, pnames);
            this.identity = null;
            this.isComplete = false;
            if (this.containsKey("service.password")) {
                try {
                    this.setProperty("service.password", this.remove("service.password"));
                }
                catch (SecurityProviderException spe) {
                    LogStream log = LogStream.getInstance();
                    if (LogStream.level < 0) break block3;
                    spe.printStackTrace(log);
                }
            }
        }
    }

    public String getName() throws SecurityProviderException {
        String cname = this.getClass().getName();
        int lio = cname.lastIndexOf(46);
        if (lio > 0 && lio < cname.length()) {
            cname = cname.substring(lio + 1);
        }
        return cname;
    }

    public void setProperty(String name, Object obj) throws SecurityProviderException {
        if (name.equals("service.password")) {
            this.setEncryptedProperty(name, (String)obj, null);
        } else if (name.startsWith("flags.")) {
            String p = (String)obj;
            boolean b = "true".equalsIgnoreCase(p) || "1".equals(p) || "yes".equalsIgnoreCase(p);
            this.setFlag(name.substring(6), b);
        } else {
            this.put(name, obj);
        }
    }

    String[] getAuthorityDnsNames(String prefix, String name, boolean putDomain) throws SecurityProviderException {
        int di;
        LogStream log = LogStream.getInstance();
        boolean singlelabeldomain = false;
        String site = null;
        int step = 0;
        String domain = name;
        Dns dns = null;
        try {
            dns = Dns.getInstance(this);
        }
        catch (DnsException de) {
            throw new SecurityProviderException(0, "Failed to acquire DNS context", de);
        }
        singlelabeldomain = this.getPropertyAsBoolean("authority.dns.names.resolve.sld", false);
        long caps = this.getPropertyAsLong("dns.server.capabilities", 0L);
        if (LogStream.level >= 4) {
            log.println("getAuthorityDnsNames: " + name + " capabilities=0x" + Hexdump.toHexString((long)caps, (int)4));
        }
        if ((caps & 1L) == 0L) {
            throw new SecurityProviderException(0, "DNS SRV lookups are required");
        }
        if ((caps & 4L) == 4L) {
            site = (String)this.getProperty("dns.site", null);
        }
        step = 0;
        while ((di = domain.indexOf(46)) >= 0 || singlelabeldomain) {
            try {
                String str = prefix;
                if ((caps & 2L) == 2L) {
                    if ((caps & 4L) == 4L && site != null && site.length() > 0) {
                        str = str + site + "._sites.";
                    }
                    str = str + "dc._msdcs.";
                }
                str = str + domain;
                if (LogStream.level >= 4) {
                    log.println("getAuthorityDnsNames: step=" + step);
                }
                Dns.DnsRecordSrv[] records = (Dns.DnsRecordSrv[])dns.getRecordsByName(str, "SRV");
                if (step > 0) {
                    for (int ri = 0; ri < records.length; ++ri) {
                        if (!name.equalsIgnoreCase(records[ri].target)) continue;
                        if (putDomain) {
                            this.put("domain.dns.name", domain);
                        }
                        return new String[]{name};
                    }
                    throw new SecurityProviderException(0, "The server is not an authority for the domain: " + name);
                }
                String[] ret = new String[records.length];
                for (int ri = 0; ri < records.length; ++ri) {
                    ret[ri] = records[ri].target;
                }
                if (LogStream.level >= 4) {
                    String msg = "";
                    if (ret.length > 0) {
                        for (int ri = 0; ri < ret.length; ++ri) {
                            msg = msg + ", " + ret[ri];
                        }
                        msg = msg.substring(2);
                    }
                    log.println("getAuthorityDnsNames: " + msg);
                }
                if (putDomain) {
                    this.put("domain.dns.name", domain);
                }
                return ret;
            }
            catch (DnsException de) {
                if (de.getCode() != 3) {
                    throw new SecurityProviderException(0, "Failed to locate authority for name: " + name, de);
                }
                if (di < 1) break;
                domain = domain.substring(di + 1);
                ++step;
            }
        }
        throw new SecurityProviderException(0, "Failed to locate authority for name: " + name);
    }

    public Object getProperty(String name, Object def) throws SecurityProviderException {
        if (name.equals("service.password")) {
            return this.getEncryptedProperty(name, def);
        }
        if (name.startsWith("flags.")) {
            return this.getFlag(name.substring(6)) ? "true" : "false";
        }
        String[] ret = super.getProperty(name, NO_PROPERTY);
        if (ret == NO_PROPERTY) {
            if (name.equals("bindstr.url")) {
                String bindstr = (String)this.getProperty("bindstr");
                if (bindstr.indexOf("://") < 0) {
                    bindstr = "ldap://" + bindstr;
                }
                try {
                    ret = new LdapUrl(bindstr);
                    this.put(name, ret);
                }
                catch (MalformedURLException mue) {
                    throw new SecurityProviderException(0, "SecurityProvider: " + mue.getMessage(), mue);
                }
            } else if (name.equals("bindstr.host")) {
                LdapUrl lurl = (LdapUrl)this.getProperty("bindstr.url");
                String str = lurl.getHost();
                if (str != null && str.length() > 0) {
                    ret = str;
                }
            } else if (name.equals("bindstr.base")) {
                LdapUrl lurl = (LdapUrl)this.getProperty("bindstr.url");
                String str = lurl.getBase();
                if (str != null && str.length() > 0) {
                    ret = str;
                }
            } else if (name.equals("authority.dns.names")) {
                String str = (String)this.getProperty("bindstr.host", null);
                if (str != null) {
                    if (this.getPropertyAsBoolean("authority.dns.names.resolve", true)) {
                        String prefix = (String)this.getProperty("authority.dns.names.prefix", "_ldap._tcp.");
                        ret = this.getAuthorityDnsNames(prefix, str, true);
                    } else {
                        ret = new String[]{str};
                    }
                    this.put(name, ret);
                }
            } else if (name.equals("dns.server.capabilities")) {
                ret = "0x" + Hexdump.toHexString((long)7L, (int)8);
            }
        }
        if (ret == NO_PROPERTY) {
            return def;
        }
        return ret;
    }

    public boolean getFlag(String name) throws SecurityProviderException {
        String value = (String)this.get("flags." + name);
        return value != null && ("true".equalsIgnoreCase(value) || "1".equals(value) || "yes".equalsIgnoreCase(value));
    }

    public void setFlag(String name, boolean value) throws SecurityProviderException {
        this.put("flags." + name, value ? "true" : "false");
    }

    public Domain getDomain(String dname, String[] attrs) throws SecurityProviderException {
        throw new SecurityProviderException(0, "Not implemented");
    }

    public Account getAccount(String acctname, String[] attrs) throws SecurityProviderException {
        throw new SecurityProviderException(0, "Not implemented");
    }

    public String getIdentity() throws SecurityProviderException {
        return this.identity;
    }

    public Object exportState() throws SecurityProviderException {
        return null;
    }

    public void importState(Object state) throws SecurityProviderException {
    }

    public byte[] initSecContext(byte[] token, int off, int len) throws SecurityProviderException {
        throw new SecurityProviderException(0, "Not implemented");
    }

    public byte[] acceptSecContext(byte[] token, int off, int len) throws SecurityProviderException {
        throw new SecurityProviderException(0, "Not implemented");
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void wrap(ByteBuffer outgoing) throws SecurityProviderException {
        throw new SecurityProviderException(0, "Not implemented");
    }

    public void unwrap(ByteBuffer incoming) throws SecurityProviderException {
        throw new SecurityProviderException(0, "Not implemented");
    }

    public void authenticate(Object credential) throws SecurityProviderException {
        throw new SecurityProviderException(0, "Not implemented");
    }

    public void dispose() throws SecurityProviderException {
    }
}

