/*
 * Decompiled with CFR 0.152.
 */
package jespa.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jespa.util.LogStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap<K, V> {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";
    String name;
    long expiration;
    long period;
    HashMap<Object, Entry> map;
    long nextClean = 0L;

    public CacheMap(String name, long expiration, long period) {
        this.name = name;
        this.expiration = expiration * 1000L;
        this.period = period * 1000L;
        this.map = new HashMap();
    }

    protected void dispose(V val) {
    }

    void clean() {
        if (System.currentTimeMillis() > this.nextClean) {
            LogStream log = LogStream.getInstance();
            if (LogStream.level >= 4) {
                log.println(this.name + ": checking for expired entries ...");
            }
            Iterator<Map.Entry<Object, Entry>> iter = this.map.entrySet().iterator();
            int n = this.map.size();
            while (iter.hasNext()) {
                Map.Entry<Object, Entry> me = iter.next();
                Entry e = me.getValue();
                if (System.currentTimeMillis() <= e.expiration) continue;
                iter.remove();
                if (LogStream.level >= 4) {
                    String k = me.getKey() instanceof String ? ": " + me.getKey() : "";
                    log.println(this.name + ": disposing entry" + k);
                }
                this.dispose(e.value);
            }
            this.nextClean = System.currentTimeMillis() + this.period;
            if (LogStream.level >= 4 && (n -= this.map.size()) > 0) {
                log.println(this.name + ": " + n + " entries disposed: size=" + this.map.size());
            }
        }
    }

    public V get(K key) {
        V ret = null;
        this.clean();
        Entry e = this.map.get(key);
        if (e != null) {
            ret = e.value;
        }
        return ret;
    }

    public V put(K key, V val) {
        V ret = null;
        this.clean();
        Entry e = this.map.put(key, new Entry(val, System.currentTimeMillis() + this.expiration));
        if (e != null) {
            ret = e.value;
            this.dispose(e.value);
        }
        return ret;
    }

    public V remove(K key) {
        V ret = null;
        this.clean();
        Entry e = this.map.remove(key);
        if (e != null) {
            this.dispose(e.value);
            ret = e.value;
        }
        return ret;
    }

    public int size() {
        return this.map.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry {
        V value;
        long expiration;

        Entry(V value, long expiration) {
            this.value = value;
            this.expiration = expiration;
        }
    }
}

