/*
 * Decompiled with CFR 0.152.
 */
package jespa.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class Csv {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";
    private static final int ST_START = 1;
    private static final int ST_COLLECT = 2;
    private static final int ST_TAILSPACE = 3;
    private static final int ST_END_QUOTE = 4;
    public static final int FLAG_TRIM_SPACE = 1;
    public static final int FLAG_IGNORE_QUOTES = 2;
    public static final int FLAG_COLLAPSE_ELEM = 4;
    static final String LINEBREAK = System.getProperty("line.separator");

    public static int parseRow(String input, char[] buf, int bn, String[] row, int rn, char sep, int flags) throws IOException {
        return Csv.readRow(new StringReader(input), buf, bn, row, rn, sep, flags);
    }

    public static String[] parseRow(String input, char sep, int flags) throws IOException {
        return Csv.readRow(new StringReader(input), sep, flags);
    }

    public static String[] readRow(Reader input, char sep, int flags) throws IOException {
        int ti;
        int count;
        int tn;
        boolean collapse;
        char[] buf = new char[4096];
        String[] tmp = new String[64];
        boolean bl = collapse = (flags & 4) == 4;
        while ((tn = Csv.readRow(input, buf, buf.length, tmp, tmp.length, sep, flags)) == tmp.length) {
            tmp = new String[tmp.length * 2];
        }
        if (tn == -1) {
            return null;
        }
        if (collapse) {
            count = 0;
            for (ti = 0; ti < tn; ++ti) {
                if (tmp[ti].length() <= 0) continue;
                ++count;
            }
        } else {
            count = tn;
        }
        String[] arr = new String[count];
        count = 0;
        for (ti = 0; ti < tn; ++ti) {
            if (tmp[ti].length() <= 0) continue;
            arr[count++] = tmp[ti];
        }
        return arr;
    }

    public static int readRow(Reader input, char[] buf, int bn, String[] row, int rn, char sep, int flags) throws IOException {
        int i = 1;
        boolean inquotes = false;
        boolean trim = (flags & 1) == 1;
        boolean quotes = (flags & 2) != 2;
        char ch = '\u0000';
        int state = 1;
        int count = 0;
        int t = 0;
        int j = 0;
        int r = 0;
        while (r < rn && j < bn && i > 0) {
            i = input.read();
            ch = i > 0 ? (char)i : (char)'\u0000';
            switch (state) {
                case 1: {
                    if (ch == '\n' || ch == '\u0000') {
                        r = rn;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (trim) break;
                        buf[j++] = ch;
                        --bn;
                        t = j;
                        break;
                    }
                    if (quotes && ch == '\"') {
                        t = 0;
                        j = 0;
                        state = 2;
                        inquotes = true;
                        break;
                    }
                    state = 2;
                }
                case 2: {
                    if (inquotes) {
                        if (ch == '\u0000') {
                            throw new IOException("Unexpected end of input");
                        }
                        if (ch == '\"') {
                            state = 4;
                            break;
                        }
                    } else {
                        if (ch == sep || ch == '\n' || ch == '\u0000') {
                            row[r++] = new String(buf, 0, t);
                            count = r;
                            t = 0;
                            j = 0;
                            state = 1;
                            inquotes = false;
                            if (ch != '\n' && ch != '\u0000' || r >= rn) break;
                            row[r++] = null;
                            r = rn;
                            break;
                        }
                        if (quotes && ch == '\"') {
                            throw new IOException("Unexpected quote in element " + (r + 1));
                        }
                    }
                    buf[j++] = ch;
                    if (trim && Character.isWhitespace(ch)) break;
                    t = j;
                    break;
                }
                case 3: 
                case 4: {
                    if (ch == sep || ch == '\n' || ch == '\u0000') {
                        row[r++] = new String(buf, 0, t);
                        count = r;
                        t = 0;
                        j = 0;
                        state = 1;
                        inquotes = false;
                        if (ch != '\n' && ch != '\u0000' || r >= rn) break;
                        row[r++] = null;
                        r = rn;
                        break;
                    }
                    if (quotes && ch == '\"' && state != 3) {
                        buf[j++] = 34;
                        t = j;
                        state = 2;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        state = 3;
                        break;
                    }
                    throw new IOException("Bad end quote in element " + (r + 1));
                }
            }
        }
        if (j == bn) {
            throw new IOException("Not enough room in buf for element " + (r + 1));
        }
        if (r < rn) {
            if (inquotes && state != 4) {
                throw new IOException("Missing end quote in element " + (r + 1));
            }
            if (t > 0) {
                row[r++] = new String(buf, 0, t);
                count = r;
            }
            if (r < rn) {
                row[r++] = null;
            }
        }
        return count == 0 && i == -1 ? -1 : count;
    }

    public static String formatRow(char[] buf, int bn, String[] row, int rn, char sep) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int r = 0; r < rn && row[r] != null; ++r) {
            if (r > 0) {
                sb.append(sep);
            }
            boolean q = false;
            char[] s = row[r].toCharArray();
            int j = 0;
            buf[j++] = 34;
            for (int i = 0; i < s.length; ++i) {
                if (s[i] == '\"') {
                    q = true;
                    buf[j++] = 34;
                } else if (s[i] == sep) {
                    q = true;
                }
                buf[j++] = s[i];
            }
            if (q) {
                buf[j++] = 34;
                sb.append(buf, 0, j);
                continue;
            }
            sb.append(buf, 1, j - 1);
        }
        return sb.toString();
    }

    public static void printRow(Writer out, char[] buf, int bn, String[] row, int rn, char sep) throws IOException {
        out.write(Csv.formatRow(buf, bn, row, rn, sep));
        out.write(LINEBREAK);
        out.flush();
    }
}

