/*
 * Decompiled with CFR 0.152.
 */
package jespa.util;

import java.io.IOException;
import java.io.OutputStream;
import jespa.util.LogStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLogStream
extends LogStream {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";

    public Log4jLogStream(Logger logger, Level level) {
        super(new Log4jOutputStream(logger, level));
    }

    public void println(Object o) {
        try {
            this.out.write(o.toString().getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void println(String s) {
        try {
            this.out.write(s.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class Log4jOutputStream
    extends OutputStream {
        private Logger logger;
        private Level level;

        Log4jOutputStream(Logger logger, Level level) {
            this.logger = logger;
            this.level = level;
        }

        public void write(int i) throws IOException {
            byte[] b = new byte[]{(byte)(i & 0xFF)};
            this.write(b, 0, 1);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.logger.log((Priority)this.level, (Object)new String(b, off, len));
        }
    }
}

