/*
 * Decompiled with CFR 0.152.
 */
package jespa.util;

import java.io.IOException;

public class RFC822 {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";

    public static byte[][] parseHeader(String header) throws IOException {
        byte[] ascii = header.getBytes("US-ASCII");
        byte[][] entry = new byte[2][];
        int ei = 0;
        int si = 0;
        int ai = 0;
        int state = 10;
        block6: for (ai = 0; state > 0 && ai <= ascii.length; ++ai) {
            int ch = (char)(ai == ascii.length ? 0 : (char)ascii[ai]);
            switch (state) {
                case 10: {
                    if (ch == 58) {
                        throw new IOException("Invalid RFC822 header key");
                    }
                }
                case 20: {
                    if (ch == 32 || ch == 9) continue block6;
                    if (ch < 32) {
                        throw new IOException("Invalid RFC822 header");
                    }
                    ++state;
                }
                case 11: 
                case 21: {
                    si = ai;
                    ei = ai + 1;
                    ++state;
                    continue block6;
                }
                case 12: 
                case 22: {
                    if (state == 12) {
                        if (ch == 58) {
                            entry[0] = new byte[ei - si];
                            System.arraycopy(ascii, si, entry[0], 0, ei - si);
                            state = 20;
                            continue block6;
                        }
                    } else if (ch == 0) {
                        entry[1] = new byte[ei - si];
                        System.arraycopy(ascii, si, entry[1], 0, ei - si);
                        state = 0;
                        continue block6;
                    }
                    if (ch == 32 || ch == 9) continue block6;
                    if (ch < 32) {
                        throw new IOException("Invalid RFC822 header");
                    }
                    ei = ai + 1;
                    continue block6;
                }
                default: {
                    throw new IOException("Invalid RFC822 parse state: " + state);
                }
            }
        }
        return entry;
    }
}

