/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class H2DriverManagerDataSource
extends DriverManagerDataSource
implements InitializingBean,
DisposableBean {
    private static String rootRealPath = "";
    private static final String C_RootRealPath = "\\{root\\}";
    private String defaultDB;
    private boolean autoReset = true;
    private Connection conn;

    public static void setRoot(String root) {
        rootRealPath = root;
    }

    private static String getDBPathFromUrl(String url) {
        if (url == null || url.length() < 1 || url.indexOf("file:") < 0) {
            return null;
        }
        url = url.substring(url.indexOf("file:") + 5);
        return url;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.autoReset) {
            String dbPath = H2DriverManagerDataSource.getDBPathFromUrl(this.getUrl());
            try {
                File dataFile = new File(String.valueOf(dbPath) + ".data.db");
                File indexFile = new File(String.valueOf(dbPath) + ".index.db");
                File traceFile = new File(String.valueOf(dbPath) + ".trace.db");
                FileCopyUtils.copy((InputStream)new FileInputStream(String.valueOf(this.defaultDB) + ".data.db"), (OutputStream)new FileOutputStream(dataFile));
                FileCopyUtils.copy((InputStream)new FileInputStream(String.valueOf(this.defaultDB) + ".index.db"), (OutputStream)new FileOutputStream(indexFile));
                FileCopyUtils.copy((InputStream)new FileInputStream(String.valueOf(this.defaultDB) + ".trace.db"), (OutputStream)new FileOutputStream(traceFile));
            }
            catch (IOException e) {
                this.logger.error((Object)"Copy Default db file error");
            }
        }
        this.conn = this.getConnection();
        int i = 0;
        while (this.conn == null && i < 5) {
            this.conn = this.getConnection();
            ++i;
        }
    }

    public void destroy() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public void setUrl(String url) {
        if (!StringUtils.hasText((String)url)) {
            throw new IllegalArgumentException("url must not be empty");
        }
        url = url.replaceFirst(C_RootRealPath, rootRealPath);
        super.setUrl(url.trim());
    }

    public void setDefaultDB(String defaultDB) {
        if (!StringUtils.hasText((String)defaultDB)) {
            throw new IllegalArgumentException("url must not be empty");
        }
        this.defaultDB = defaultDB.replaceFirst(C_RootRealPath, rootRealPath).trim();
    }

    public boolean isAutoReset() {
        return this.autoReset;
    }

    public void setAutoReset(boolean autoReset) {
        this.autoReset = autoReset;
    }

    public String getDefaultDB() {
        return this.defaultDB;
    }
}

