/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.common.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.util.ExceptionUtils;

public class LogHandler {
    protected static Log createLogger(Class classType) {
        return LogFactory.getLog((Class)classType);
    }

    public static void errorLog(Log logger, String msg, Throwable t) {
        if (logger.isErrorEnabled()) {
            logger.error((Object)msg, t);
        }
    }

    public static void warnLog(Log logger, String msg, Throwable t) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)msg, t);
        }
    }

    public static void infoLog(Log logger, String msg, Throwable t) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)msg, t);
        }
    }

    public static void debugLog(Log logger, String msg, Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msg, t);
        }
    }

    public static void errorLog(Log logger, Class clazz, String msg) {
        LogHandler.errorLog(logger, " ===== " + clazz.getName() + " ===== \n" + msg, null);
    }

    public static void errorLog(Log logger, String msg) {
        LogHandler.errorLog(logger, msg, null);
    }

    public static void errorLog(Log logger, Throwable t) {
        LogHandler.errorLog(logger, ExceptionUtils.formatStackTrace(t), null);
    }

    public static void warnLog(Log logger, Class clazz, String msg) {
        LogHandler.warnLog(logger, " ===== " + clazz.getName() + " ===== \n" + msg, null);
    }

    public static void warnLog(Log logger, String msg) {
        LogHandler.warnLog(logger, msg, null);
    }

    public static void warnLog(Log logger, Throwable t) {
        LogHandler.warnLog(logger, ExceptionUtils.formatStackTrace(t), null);
    }

    public static void infoLog(Log logger, Class clazz, String msg) {
        LogHandler.infoLog(logger, " ===== " + clazz.getName() + " ===== \n" + msg, null);
    }

    public static void infoLog(Log logger, String msg) {
        LogHandler.infoLog(logger, msg, null);
    }

    public static void debugLog(Log logger, Class clazz, String msg) {
        LogHandler.debugLog(logger, " ===== " + clazz.getName() + " ===== \n" + msg, null);
    }

    public static void debugLog(Log logger, String msg) {
        LogHandler.debugLog(logger, msg, null);
    }
}

