/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ecside.core.Registry;
import org.ecside.core.TableCache;
import org.ecside.core.TableModelUtils;
import org.ecside.core.context.WebContext;
import org.ecside.table.state.State;

public abstract class AbstractRegistry
implements Registry {
    protected Map parameterMap;
    protected WebContext context;
    protected String tableId;
    protected String prefixWithTableId;
    protected String state;
    protected String stateAttr;
    protected boolean autoIncludeParameters;

    public void setParameterMap() {
        HashMap<String, String[]> tableParameterMap = new HashMap<String, String[]>();
        HashMap<String, String[]> userDefinedParameterMap = new HashMap<String, String[]>();
        Map params = this.context.getParameterMap();
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String[] paramValues;
            String paramName = (String)iter.next();
            if (paramName.equals("eti") || paramName.equals("eti_p") || paramName.equals("ec_i")) continue;
            if (paramName.startsWith(String.valueOf(this.prefixWithTableId) + "p") || paramName.startsWith(String.valueOf(this.prefixWithTableId) + "crd") || paramName.startsWith(String.valueOf(this.prefixWithTableId) + "s_") || paramName.startsWith(String.valueOf(this.prefixWithTableId) + "f_") || paramName.startsWith(String.valueOf(this.prefixWithTableId) + "ev") || paramName.startsWith(String.valueOf(this.prefixWithTableId) + "efn") || paramName.startsWith(String.valueOf(this.prefixWithTableId) + "a_")) {
                paramValues = TableModelUtils.getValueAsArray(params.get(paramName));
                tableParameterMap.put(paramName, paramValues);
                continue;
            }
            if (!this.autoIncludeParameters) continue;
            paramValues = TableModelUtils.getValueAsArray(params.get(paramName));
            userDefinedParameterMap.put(paramName, paramValues);
        }
        this.parameterMap = this.handleState(tableParameterMap);
        this.parameterMap.putAll(userDefinedParameterMap);
    }

    public Map handleState(Map tableParameterMap) {
        Map stateParameters;
        State state = TableCache.getInstance().getState(this.state);
        if (tableParameterMap.isEmpty() && (stateParameters = state.getParameters(this.context, this.tableId, this.stateAttr)) != null) {
            tableParameterMap = stateParameters;
        }
        this.handleStateInternal(state, tableParameterMap);
        return tableParameterMap;
    }

    public void addParameter(String name, Object value) {
        String[] paramValues = TableModelUtils.getValueAsArray(value);
        this.parameterMap.put(name, paramValues);
    }

    public String getParameter(String parameter) {
        String[] values = (String[])this.parameterMap.get(parameter);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public void removeParameter(String parameter) {
        this.parameterMap.remove(parameter);
    }

    protected abstract void handleStateInternal(State var1, Map var2);
}

