/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.context.WebContext;

public class RetrievalUtils {
    private static Log logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.core.RetrievalUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public static Object retrieve(WebContext context, String name) {
        return RetrievalUtils.retrieve(context, name, null);
    }

    public static Object retrieve(WebContext context, String name, String scope) {
        Object value;
        if (StringUtils.isNotBlank((String)scope)) {
            if (scope.equalsIgnoreCase("page")) {
                return context.getPageAttribute(name);
            }
            if (scope.equalsIgnoreCase("request")) {
                return context.getRequestAttribute(name);
            }
            if (scope.equalsIgnoreCase("session")) {
                return context.getSessionAttribute(name);
            }
            if (scope.equalsIgnoreCase("application")) {
                return context.getApplicationAttribute(name);
            }
        }
        if ((value = context.getPageAttribute(name)) == null) {
            value = context.getRequestAttribute(name);
        }
        if (value == null) {
            value = context.getSessionAttribute(name);
        }
        if (value == null) {
            value = context.getApplicationAttribute(name);
        }
        return value;
    }

    public static Collection retrieveCollection(WebContext context, Object collection) throws Exception {
        return RetrievalUtils.retrieveCollection(context, collection, null);
    }

    public static Collection retrieveCollection(WebContext context, Object collection, String scope) throws Exception {
        if (collection instanceof Collection) {
            return (Collection)collection;
        }
        if (collection instanceof Map) {
            return ((Map)collection).values();
        }
        if (collection instanceof String) {
            return RetrievalUtils.retrieveCollectionFromScope(context, String.valueOf(collection), scope);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Could not find the Collection.");
        }
        return Collections.EMPTY_LIST;
    }

    static Collection retrieveCollectionFromScope(WebContext context, String collection, String scope) throws Exception {
        Collection results = null;
        if (StringUtils.isBlank((String)collection) || "null".equals(collection)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The collection is not defined.");
            }
            return Collections.EMPTY_LIST;
        }
        results = StringUtils.contains((String)collection, (String)".") ? RetrievalUtils.retrieveNestedCollection(context, collection, scope) : RetrievalUtils.retrieveCollectionAsObject(context, collection, scope);
        if (results == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Could not find the Collection.");
            }
            return Collections.EMPTY_LIST;
        }
        return results;
    }

    static Collection retrieveNestedCollection(WebContext context, String collection, String scope) throws Exception {
        Object obj;
        block4: {
            String[] split = StringUtils.split((String)collection, (String)".");
            obj = RetrievalUtils.retrieve(context, split[0], scope);
            String collectionToFind = StringUtils.substringAfter((String)collection, (String)".");
            Object value = null;
            try {
                obj = value = PropertyUtils.getProperty((Object)obj, (String)collectionToFind);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)("Could not find the property [" + collectionToFind + "]. Either the bean or property is null"));
            }
        }
        if (!(obj instanceof Collection)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The object is not of type Collection.");
            }
            return Collections.EMPTY_LIST;
        }
        return (Collection)obj;
    }

    static Collection retrieveCollectionAsObject(WebContext context, String collection, String scope) throws Exception {
        Object obj = RetrievalUtils.retrieve(context, collection, scope);
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Map) {
            return ((Map)obj).values();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"The object is not of type Collection.");
        }
        return Collections.EMPTY_LIST;
    }
}

