/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.AutoGenerateColumns;
import org.ecside.core.TableModel;
import org.ecside.table.calc.Calc;
import org.ecside.table.callback.FilterRowsCallback;
import org.ecside.table.callback.RetrieveRowsCallback;
import org.ecside.table.callback.SortRowsCallback;
import org.ecside.table.cell.Cell;
import org.ecside.table.interceptor.ColumnInterceptor;
import org.ecside.table.interceptor.ExportInterceptor;
import org.ecside.table.interceptor.RowInterceptor;
import org.ecside.table.interceptor.TableInterceptor;
import org.ecside.table.state.State;

public class TableCache {
    private Log logger;
    public static TableCache tableCache = new TableCache();
    private Map cache;
    static /* synthetic */ Class class$0;

    private TableCache() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.core.TableCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    public static TableCache getInstance() {
        return tableCache;
    }

    private Object getCachedObject(String className) {
        Object cachedObject = null;
        try {
            cachedObject = this.cache.get(className);
            if (cachedObject == null) {
                Class<?> classForName = Class.forName(className);
                cachedObject = classForName.newInstance();
                this.cache.put(className, cachedObject);
            }
        }
        catch (Exception e) {
            String msg = "Could not create the object [" + className + "]. The class was not found or does not exist.";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
        return cachedObject;
    }

    public Cell getCell(String cell) {
        return (Cell)this.getCachedObject(cell);
    }

    public State getState(String state) {
        return (State)this.getCachedObject(state);
    }

    public RetrieveRowsCallback getRetrieveRowsCallback(TableModel model) {
        String retrieveRowsCallback = model.getTable().getRetrieveRowsCallback();
        return (RetrieveRowsCallback)this.getCachedObject(retrieveRowsCallback);
    }

    public FilterRowsCallback getFilterRowsCallback(TableModel model) {
        String filterRowsCallback = model.getTable().getFilterRowsCallback();
        return (FilterRowsCallback)this.getCachedObject(filterRowsCallback);
    }

    public SortRowsCallback getSortRowsCallback(TableModel model) {
        String sortRowsCallback = model.getTable().getSortRowsCallback();
        return (SortRowsCallback)this.getCachedObject(sortRowsCallback);
    }

    public Calc getCalc(String calc) {
        return (Calc)this.getCachedObject(calc);
    }

    public TableInterceptor getTableInterceptor(String tableInterceptor) {
        return (TableInterceptor)this.getCachedObject(tableInterceptor);
    }

    public RowInterceptor getRowInterceptor(String rowInterceptor) {
        return (RowInterceptor)this.getCachedObject(rowInterceptor);
    }

    public ColumnInterceptor getColumnInterceptor(String columnInterceptor) {
        return (ColumnInterceptor)this.getCachedObject(columnInterceptor);
    }

    public ExportInterceptor getExportInterceptor(String exportInterceptor) {
        return (ExportInterceptor)this.getCachedObject(exportInterceptor);
    }

    public AutoGenerateColumns getAutoGenerateColumns(String autoGenerateColumns) {
        return (AutoGenerateColumns)this.getCachedObject(autoGenerateColumns);
    }
}

