/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.Messages;
import org.ecside.core.Preferences;
import org.ecside.core.Registry;
import org.ecside.core.TableCache;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.TableRegistry;
import org.ecside.core.bean.Column;
import org.ecside.core.bean.Export;
import org.ecside.core.bean.Row;
import org.ecside.core.bean.Table;
import org.ecside.core.context.WebContext;
import org.ecside.preferences.TableProperties;
import org.ecside.table.handler.ColumnHandler;
import org.ecside.table.handler.ExportHandler;
import org.ecside.table.handler.RowHandler;
import org.ecside.table.handler.TableHandler;
import org.ecside.table.handler.ViewHandler;
import org.ecside.table.limit.Limit;
import org.ecside.table.limit.ModelLimitFactory;
import org.ecside.table.limit.TableLimit;

public final class TableModelImpl
implements TableModel {
    private Log logger;
    private WebContext context;
    private Preferences preferences;
    private Messages messages;
    private Registry registry;
    private TableHandler tableHandler;
    private RowHandler rowHandler;
    private ColumnHandler columnHandler;
    private ViewHandler viewHandler;
    private ExportHandler exportHandler;
    private Object currentRowBean;
    private Collection collectionOfBeans;
    private Collection collectionOfFilteredBeans;
    private Collection collectionOfPageBeans;
    private Limit limit;
    private Locale locale;
    private boolean hasExcuteQueryResult;
    List propertyNameList;
    static /* synthetic */ Class class$0;

    public TableModelImpl(WebContext context) {
        this(context, null);
    }

    public TableModelImpl(WebContext context, String locale) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.core.TableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.tableHandler = new TableHandler(this);
        this.rowHandler = new RowHandler(this);
        this.columnHandler = new ColumnHandler(this);
        this.viewHandler = new ViewHandler(this);
        this.exportHandler = new ExportHandler(this);
        this.hasExcuteQueryResult = false;
        this.propertyNameList = new ArrayList();
        this.context = context;
        TableProperties preferences = new TableProperties();
        preferences.init(context, TableModelUtils.getPreferencesLocation(context));
        this.preferences = preferences;
        this.locale = TableModelUtils.getLocale(context, preferences, locale);
        Messages messages = TableModelUtils.getMessages(this);
        messages.init(context, this.locale);
        this.messages = messages;
    }

    public WebContext getContext() {
        return this.context;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Table getTableInstance() {
        return new Table(this);
    }

    public Export getExportInstance() {
        return new Export(this);
    }

    public Row getRowInstance() {
        return new Row(this);
    }

    public Column getColumnInstance() {
        return new Column(this);
    }

    public void addTable(Table table) {
        this.tableHandler.addTable(table);
        this.registry = new TableRegistry(this);
        ModelLimitFactory limitFactory = new ModelLimitFactory(this);
        this.limit = new TableLimit(limitFactory);
    }

    public void addExport(Export export) {
        this.exportHandler.addExport(export);
    }

    public void addRow(Row row) {
        this.rowHandler.addRow(row);
    }

    public void addColumn(Column column) {
        this.columnHandler.addAutoGenerateColumn(column);
    }

    public void addColumns(String autoGenerateColumns) {
        autoGenerateColumns = TableModelUtils.getAutoGenerateColumnsPreference(this, autoGenerateColumns);
        TableCache.getInstance().getAutoGenerateColumns(autoGenerateColumns).addColumns(this);
    }

    public void addParameter(String name, Object value) {
        this.registry.addParameter(name, value);
    }

    public TableHandler getTableHandler() {
        return this.tableHandler;
    }

    public RowHandler getRowHandler() {
        return this.rowHandler;
    }

    public ColumnHandler getColumnHandler() {
        return this.columnHandler;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public ExportHandler getExportHandler() {
        return this.exportHandler;
    }

    public Object getCurrentRowBean() {
        return this.currentRowBean;
    }

    public void setCurrentRowBean(Object bean) {
        int rowcount = this.rowHandler.increaseRowCount();
        this.currentRowBean = bean;
        this.context.setPageAttribute("ROWCOUNT", String.valueOf(rowcount));
        int globalRowcount = rowcount + this.limit.getRowStart();
        this.context.setPageAttribute("GLOBALROWCOUNT", String.valueOf(globalRowcount));
        this.context.setPageAttribute("TOTALROWCOUNT", String.valueOf(globalRowcount));
        this.context.setPageAttribute(this.tableHandler.getTable().getVar(), bean);
    }

    public Collection getCollectionOfBeans() {
        return this.collectionOfBeans;
    }

    public void setCollectionOfBeans(Collection collectionOfBeans) {
        this.collectionOfBeans = collectionOfBeans;
    }

    public Collection getCollectionOfFilteredBeans() {
        return this.collectionOfFilteredBeans;
    }

    public void setCollectionOfFilteredBeans(Collection collectionOfFilteredBeans) {
        this.collectionOfFilteredBeans = collectionOfFilteredBeans;
    }

    public Collection getCollectionOfPageBeans() {
        return this.collectionOfPageBeans;
    }

    public void setCollectionOfPageBeans(Collection collectionOfPageBeans) {
        this.collectionOfPageBeans = collectionOfPageBeans;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void queryResultExecute() throws Exception {
        if (this.hasExcuteQueryResult) {
            return;
        }
        Integer totalRows = this.getTableHandler().getTotalRows();
        int defaultRowsDisplayed = this.getTable().getRowsDisplayed();
        int totalRowsNum = 0;
        totalRowsNum = totalRows != null ? totalRows : 0;
        if (defaultRowsDisplayed < 0) {
            defaultRowsDisplayed = totalRowsNum;
        }
        this.context.setPageAttribute("GLOBALROWCOUNT", String.valueOf(totalRowsNum));
        this.limit.setRowAttributes(totalRowsNum, defaultRowsDisplayed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.limit.toString());
        }
        this.viewHandler.setView();
        this.hasExcuteQueryResult = true;
    }

    public Collection execute() throws Exception {
        Collection rows = TableModelUtils.retrieveRows(this);
        if (!(rows instanceof List)) {
            rows = new ArrayList(rows);
        }
        this.collectionOfBeans = rows;
        rows = TableModelUtils.filterRows(this, rows);
        this.collectionOfFilteredBeans = rows = TableModelUtils.sortRows(this, rows);
        Integer totalRows = this.getTableHandler().getTotalRows();
        int defaultRowsDisplayed = this.getTable().getRowsDisplayed();
        int totalRowsNum = 0;
        totalRowsNum = totalRows != null ? totalRows.intValue() : rows.size();
        if (defaultRowsDisplayed < 0) {
            defaultRowsDisplayed = totalRowsNum;
        }
        this.context.setPageAttribute("GLOBALROWCOUNT", String.valueOf(totalRowsNum));
        this.limit.setRowAttributes(totalRowsNum, defaultRowsDisplayed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.limit.toString());
        }
        this.collectionOfPageBeans = rows = TableModelUtils.getCurrentRows(this, rows);
        this.viewHandler.setView();
        return rows;
    }

    public void setColumnValues() throws Exception {
        List columns = this.columnHandler.getColumns();
        Iterator iter = columns.iterator();
        String[] cellValues = (String[])this.getTable().getAttribute("CELL_VALUES");
        String[] editEvents = (String[])this.getTable().getAttribute("EDIT_EVENTS");
        String[] editTemplates = (String[])this.getTable().getAttribute("EDIT_TEMPLATES");
        String[] editables = (String[])this.getTable().getAttribute("EDITABLES");
        int i = 0;
        while (iter.hasNext()) {
            String propertyValueString;
            Column column = (Column)iter.next();
            if (!"true".equals(column.getAttribute("isAutoGenerateColumn"))) continue;
            String property = column.getProperty();
            Object propertyValue = TableModelUtils.getColumnPropertyValue(this.currentRowBean, property);
            column.setValue(propertyValue);
            column.setPropertyValue(propertyValue);
            if (cellValues != null && i < cellValues.length && StringUtils.isNotBlank((String)cellValues[i])) {
                column.setCellValue(cellValues[i].trim());
            }
            if (editEvents != null && i < editEvents.length && StringUtils.isNotBlank((String)editEvents[i])) {
                column.setEditEvent(editEvents[i].trim());
            }
            if (editTemplates != null && i < editTemplates.length && StringUtils.isNotBlank((String)editTemplates[i])) {
                column.setEditTemplate(editTemplates[i].trim());
            }
            if (editables != null && i < editables.length && StringUtils.isNotBlank((String)editables[i])) {
                column.setEditable(Boolean.valueOf(editables[i].trim()));
            }
            if ((propertyValueString = "" + propertyValue).length() > 4) {
                column.setAttribute("attributes", " title=\"" + propertyValue + "\" ");
            }
            this.columnHandler.modifyColumnAttributes(column);
            this.viewHandler.addColumnValueToView(column);
            ++i;
        }
    }

    public Object getViewData() throws Exception {
        Object viewData = this.viewHandler.getView().afterBody(this);
        if (this.limit.isExported()) {
            this.context.setRequestAttribute("viewData", viewData);
            this.context.setRequestAttribute("viewResolver", this.exportHandler.getCurrentExport().getViewResolver());
            this.context.setRequestAttribute("efn", this.exportHandler.getCurrentExport().getFileName());
            if (!this.exportHandler.getCurrentExport().getView().equals("print")) {
                return "";
            }
        }
        return viewData;
    }

    public Object assemble() throws Exception {
        Iterator iterator;
        Iterator iter = iterator = this.execute().iterator();
        while (iter.hasNext()) {
            Object bean = iterator.next();
            this.setCurrentRowBean(bean);
            this.getRowHandler().modifyRowAttributes();
            this.setColumnValues();
        }
        return this.getViewData();
    }

    public void addPropertyName(String propertyName) {
        this.propertyNameList.add(propertyName);
    }

    public String getPropertyName(int idx) {
        return (String)this.propertyNameList.get(idx);
    }

    public List getPropertyNameList() {
        return this.propertyNameList;
    }

    public Table getTable() {
        return this.getTableHandler().getTable();
    }
}

