/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.core.bean;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GirdExpression {
    private Context cx = Context.enter();
    private Scriptable scope = this.cx.initStandardObjects();
    private Scriptable scriptObject = this.cx.newObject(this.scope);
    private String argumentNames;
    private StringBuffer functionCode = new StringBuffer();
    private Function functionCore;

    public GirdExpression() {
    }

    public GirdExpression(String argumentNames) {
        this.setArgumentNames(argumentNames);
    }

    public void setArgument(String argumentName, Object argumentValue) {
        this.scriptObject.put(argumentName, this.scriptObject, argumentValue);
    }

    public void build(String expression) {
        this.build(this.argumentNames, expression);
    }

    public void build(String argumentNames, String expression) {
        this.argumentNames = argumentNames;
        this.functionCode.append("function expressionFunction(").append(argumentNames).append(") { ");
        if (expression.toLowerCase().indexOf("return ") < 0) {
            this.functionCode.append(" return ( ").append(expression).append(" ); }");
        } else {
            this.functionCode.append(expression).append(" }");
        }
        this.functionCore = this.cx.compileFunction(this.scope, this.functionCode.toString(), "exfunction", 1, null);
    }

    public Object call() {
        return this.functionCore.call(this.cx, this.scope, this.scope, new Object[]{this.scriptObject});
    }

    public String getArgumentNames() {
        return this.argumentNames;
    }

    public void setArgumentNames(String argumentNames) {
        this.argumentNames = argumentNames;
    }

    public static void testJSFunction() {
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        String expression = "function test(col) { return (10+ col.a + col.b + col.c )/3; }";
        Function testFunction1 = cx.compileFunction((Scriptable)scope, expression, "cell", 1, null);
        Scriptable col = cx.newObject((Scriptable)scope);
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < 20000) {
            col.put("a", col, (Object)new Integer(i));
            col.put("b", col, (Object)new Integer(i + 1));
            col.put("c", col, (Object)new Integer(i + 2));
            Object result = testFunction1.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{col});
            System.out.println(result);
            ++i;
        }
        System.out.println("how long : " + (System.currentTimeMillis() - t));
    }

    public static void main(String[] args) {
        GirdExpression.testJSFunction();
    }

    public Scriptable getScriptObject() {
        return this.scriptObject;
    }
}

