/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.core.bean;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;

final class TableDefaults {
    TableDefaults() {
    }

    static String getTableId(String tableId) {
        if (StringUtils.isNotEmpty((String)tableId)) {
            return tableId;
        }
        return "ec";
    }

    static String getVar(String var, String tableId) {
        if (StringUtils.isNotEmpty((String)var)) {
            return var;
        }
        return tableId;
    }

    static String getStyleClass(TableModel model, String styleClass) {
        if (StringUtils.isBlank((String)styleClass)) {
            return model.getPreferences().getPreference("table.styleClass");
        }
        return styleClass;
    }

    static String getBorder(TableModel model, String border) {
        if (StringUtils.isBlank((String)border)) {
            return model.getPreferences().getPreference("table.border");
        }
        return border;
    }

    static Boolean isBufferView(TableModel model, Boolean bufferView) {
        if (bufferView == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.bufferView"));
        }
        return bufferView;
    }

    static String getCellpadding(TableModel model, String cellpadding) {
        if (StringUtils.isBlank((String)cellpadding)) {
            return model.getPreferences().getPreference("table.cellpadding");
        }
        return cellpadding;
    }

    static String getCellspacing(TableModel model, String cellspacing) {
        if (StringUtils.isBlank((String)cellspacing)) {
            return model.getPreferences().getPreference("table.cellspacing");
        }
        return cellspacing;
    }

    static int getRowsDisplayed(TableModel model, int rowsDisplayed) {
        if (rowsDisplayed == 0) {
            return new Integer(model.getPreferences().getPreference("table.rowsDisplayed"));
        }
        return rowsDisplayed;
    }

    static Boolean isSortable(TableModel model, Boolean sortable) {
        if (sortable == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.sortable"));
        }
        return sortable;
    }

    static Boolean isClassic(TableModel model, Boolean classic) {
        if (classic == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.classic"));
        }
        return classic;
    }

    static Boolean isGenerateScript(TableModel model, Boolean generateScript) {
        if (generateScript == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.generateScript"));
        }
        return generateScript;
    }

    static Boolean isUseAjax(TableModel model, Boolean useAjax) {
        if (useAjax == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.useAjax"));
        }
        return useAjax;
    }

    static Boolean isDoPreload(TableModel model, Boolean doPreload) {
        if (doPreload == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.doPreload"));
        }
        return doPreload;
    }

    static Boolean isFilterable(TableModel model, Boolean filterable) {
        if (filterable == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.filterable"));
        }
        return filterable;
    }

    static Boolean isShowTitle(TableModel model, Boolean showTitle) {
        if (showTitle == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.showTitle"));
        }
        return showTitle;
    }

    static Boolean isShowTooltips(TableModel model, Boolean showTooltips) {
        if (showTooltips == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.showTooltips"));
        }
        return showTooltips;
    }

    static String retrieveImagePath(TableModel model) {
        String resourceValue = model.getMessages().getMessage("table.imagePath");
        if (resourceValue != null) {
            return resourceValue;
        }
        return model.getPreferences().getPreference("table.imagePath");
    }

    static String getTitle(TableModel model, String title) {
        String resourceValue;
        if (TableModelUtils.isResourceBundleProperty(title) && (resourceValue = model.getMessages().getMessage(title)) != null) {
            return resourceValue;
        }
        return title;
    }

    static String getWidth(TableModel model, String width) {
        if (StringUtils.isBlank((String)width)) {
            return model.getPreferences().getPreference("table.width");
        }
        return width;
    }

    static Boolean getBatchUpdate(TableModel model, Boolean batchUpdate) {
        if (batchUpdate == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.batchUpdate"));
        }
        return batchUpdate;
    }

    static Boolean getAutoIncludeParameters(TableModel model, Boolean autoIncludeParameters) {
        if (autoIncludeParameters == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.autoIncludeParameters"));
        }
        return autoIncludeParameters;
    }

    static String getFilterRowsCallback(TableModel model, String filterRowsCallback) {
        String result;
        if (StringUtils.isNotBlank((String)filterRowsCallback)) {
            result = model.getPreferences().getPreference("table.filterRowsCallback." + filterRowsCallback);
            if (StringUtils.isBlank((String)result)) {
                result = filterRowsCallback;
            }
        } else {
            result = model.getPreferences().getPreference("table.filterRowsCallback.default");
        }
        return result;
    }

    static String getRetrieveRowsCallback(TableModel model, String retrieveRowsCallback) {
        String result;
        if (StringUtils.isNotBlank((String)retrieveRowsCallback)) {
            result = model.getPreferences().getPreference("table.retrieveRowsCallback." + retrieveRowsCallback);
            if (StringUtils.isBlank((String)result)) {
                result = retrieveRowsCallback;
            }
        } else {
            result = model.getPreferences().getPreference("table.retrieveRowsCallback.default");
        }
        return result;
    }

    static String getSortRowsCallback(TableModel model, String sortRowsCallback) {
        String result;
        if (StringUtils.isNotBlank((String)sortRowsCallback)) {
            result = model.getPreferences().getPreference("table.sortRowsCallback." + sortRowsCallback);
            if (StringUtils.isBlank((String)result)) {
                result = sortRowsCallback;
            }
        } else {
            result = model.getPreferences().getPreference("table.sortRowsCallback.default");
        }
        return result;
    }

    static String getState(TableModel model, String state) {
        String result;
        if (StringUtils.isNotBlank((String)state)) {
            result = model.getPreferences().getPreference("table.state." + state);
            if (StringUtils.isBlank((String)result)) {
                result = state;
            }
        } else {
            result = model.getPreferences().getPreference("table.state.default");
        }
        return result;
    }

    static String getStateAttr(TableModel model, String stateAttr) {
        if (StringUtils.isBlank((String)stateAttr)) {
            return model.getPreferences().getPreference("table.stateAttr");
        }
        return stateAttr;
    }

    static String getView(String view) {
        if (StringUtils.isBlank((String)view)) {
            return "html";
        }
        return view;
    }

    static String getMethod(TableModel model, String method) {
        if (StringUtils.isBlank((String)method)) {
            return model.getPreferences().getPreference("table.method");
        }
        return method;
    }

    static String getTheme(TableModel model, String theme) {
        if (StringUtils.isEmpty((String)theme)) {
            return model.getPreferences().getPreference("table.theme");
        }
        return theme;
    }

    static String getToolbarLocation(TableModel model, String toolbarLocation) {
        if (StringUtils.isEmpty((String)toolbarLocation)) {
            return model.getPreferences().getPreference("table.toolbarLocation");
        }
        return toolbarLocation;
    }

    static String getAlwaysShowExtend(TableModel model, String alwaysShowExtend) {
        if (StringUtils.isEmpty((String)alwaysShowExtend)) {
            return model.getPreferences().getPreference("table.alwaysShowExtend");
        }
        return alwaysShowExtend;
    }

    static String getToolbarContent(TableModel model, String toolbarContent) {
        if (StringUtils.isEmpty((String)toolbarContent)) {
            return model.getPreferences().getPreference("table.toolbarContent");
        }
        return toolbarContent;
    }

    static String getPageSizeList(TableModel model, String pageSizeList) {
        String defaultList = model.getPreferences().getPreference("table.pageSizeList");
        if (StringUtils.isEmpty((String)pageSizeList)) {
            return defaultList;
        }
        if (pageSizeList.indexOf(",") < 0 && pageSizeList.trim().toLowerCase().startsWith("max:")) {
            pageSizeList = String.valueOf(pageSizeList) + "," + defaultList;
        }
        return pageSizeList;
    }

    static Boolean getResizeColWidth(TableModel model, Boolean resizeColWidth) {
        if (resizeColWidth == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.resizeColWidth"));
        }
        return resizeColWidth;
    }

    static int getMinColWidth(TableModel model, int minColWidth) {
        if (minColWidth < 1) {
            return Integer.parseInt(model.getPreferences().getPreference("table.minColWidth"));
        }
        return minColWidth;
    }

    static String getNearPageNum(TableModel model, String nearPageNum) {
        if (StringUtils.isBlank((String)nearPageNum)) {
            nearPageNum = model.getPreferences().getPreference("table.nearPageNum");
        }
        try {
            new Integer(nearPageNum).intValue();
        }
        catch (Exception e) {
            nearPageNum = model.getPreferences().getPreference("table.nearPageNum");
        }
        return nearPageNum;
    }

    static String getMaxRowsExported(TableModel model, String maxRowsExported) {
        if (StringUtils.isBlank((String)maxRowsExported)) {
            maxRowsExported = model.getPreferences().getPreference("export.maxRowsExported");
        }
        try {
            new Integer(maxRowsExported).intValue();
        }
        catch (Exception e) {
            maxRowsExported = model.getPreferences().getPreference("export.maxRowsExported");
        }
        return maxRowsExported;
    }

    static Boolean isEditable(TableModel model, Boolean editable) {
        if (editable == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.editable"));
        }
        return editable;
    }
}

