/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.core.context;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ecside.core.context.ContextUtils;
import org.ecside.core.context.WebContext;

public class HttpServletRequestContext
implements WebContext {
    private HttpServletRequest request;
    private Map parameterMap;
    private Locale locale;

    public HttpServletRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    public Object getApplicationInitParameter(String name) {
        return this.request.getSession().getServletContext().getInitParameter(name);
    }

    public Object getApplicationAttribute(String name) {
        return this.request.getSession().getServletContext().getAttribute(name);
    }

    public void setApplicationAttribute(String name, Object value) {
        this.request.getSession().getServletContext().setAttribute(name, value);
    }

    public void removeApplicationAttribute(String name) {
        this.request.getSession().getServletContext().removeAttribute(name);
    }

    public Object getPageAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public void setPageAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public void removePageAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public String getParameter(String name) {
        String[] values;
        if (this.parameterMap != null && (values = ContextUtils.getValueAsArray(this.parameterMap.get(name))) != null && values.length > 0) {
            return values[0];
        }
        return this.request.getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap != null) {
            return this.parameterMap;
        }
        return this.request.getParameterMap();
    }

    public void setParameterMap(Map parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Object getRequestAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public void setRequestAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public void removeRequestAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Object getSessionAttribute(String name) {
        return this.request.getSession().getAttribute(name);
    }

    public void setSessionAttribute(String name, Object value) {
        this.request.getSession().setAttribute(name, value);
    }

    public void removeSessionAttribute(String name) {
        this.request.getSession().removeAttribute(name);
    }

    public Writer getWriter() {
        return new StringWriter();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return this.request.getLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getRealPath(String path) {
        return this.request.getSession().getServletContext().getRealPath(path);
    }

    public Object getBackingObject() {
        return this.request;
    }

    public Object getContextObject() {
        return this.getBackingObject();
    }
}

