/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.core.context;

import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.ecside.core.context.WebContext;

public final class JspPageContext
implements WebContext {
    private PageContext pageContext;
    private Map parameterMap;
    private Locale locale;

    public JspPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Object getApplicationInitParameter(String name) {
        return this.pageContext.getServletContext().getInitParameter(name);
    }

    public Object getApplicationAttribute(String name) {
        return this.pageContext.getServletContext().getAttribute(name);
    }

    public void setApplicationAttribute(String name, Object value) {
        this.pageContext.getServletContext().setAttribute(name, value);
    }

    public void removeApplicationAttribute(String name) {
        this.pageContext.getServletContext().removeAttribute(name);
    }

    public Object getPageAttribute(String name) {
        return this.pageContext.getAttribute(name);
    }

    public void setPageAttribute(String name, Object value) {
        this.pageContext.setAttribute(name, value);
    }

    public void removePageAttribute(String name) {
        this.pageContext.removeAttribute(name);
    }

    public String getParameter(String name) {
        return this.pageContext.getRequest().getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap != null) {
            return this.parameterMap;
        }
        return this.pageContext.getRequest().getParameterMap();
    }

    public void setParameterMap(Map parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Object getRequestAttribute(String name) {
        return this.pageContext.getRequest().getAttribute(name);
    }

    public void setRequestAttribute(String name, Object value) {
        this.pageContext.getRequest().setAttribute(name, value);
    }

    public void removeRequestAttribute(String name) {
        this.pageContext.getRequest().removeAttribute(name);
    }

    public Object getSessionAttribute(String name) {
        return this.pageContext.getSession().getAttribute(name);
    }

    public void setSessionAttribute(String name, Object value) {
        this.pageContext.getSession().setAttribute(name, value);
    }

    public void removeSessionAttribute(String name) {
        this.pageContext.getSession().removeAttribute(name);
    }

    public Writer getWriter() {
        return this.pageContext.getOut();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return this.pageContext.getRequest().getLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getContextPath() {
        ServletRequest request = this.pageContext.getRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getContextPath();
        }
        throw new UnsupportedOperationException("There is no context path associated with the request.");
    }

    public String getRealPath(String path) {
        if (this.pageContext.getRequest() instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.pageContext.getRequest()).getSession().getServletContext().getRealPath(path);
        }
        throw new UnsupportedOperationException("There is no real path associated with the request.");
    }

    public Object getBackingObject() {
        return this.pageContext;
    }

    public Object getContextObject() {
        return this.getBackingObject();
    }
}

