/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.easyda;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.common.log.LogHandler;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class BaseDAO {
    private Log logger;
    private DataSource dataSource;
    protected int maxBatch;
    static /* synthetic */ Class class$0;

    public BaseDAO() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.easyda.BaseDAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.maxBatch = 255;
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getMaxBatch() {
        return this.maxBatch;
    }

    public void setMaxBatch(int maxBatch) {
        this.maxBatch = maxBatch;
    }

    public Connection getConnection() {
        return DataSourceUtils.getConnection((DataSource)this.getDataSource());
    }

    public void closeConnection(Connection con) {
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
    }

    public void close(ResultSet rest, Statement stmt, Connection conn) {
        try {
            this.close(rest);
        }
        catch (SQLException e) {
            LogHandler.errorLog(this.logger, e);
        }
        this.close(stmt, conn);
    }

    public void close(Statement stmt, Connection conn) {
        try {
            this.close(stmt);
        }
        catch (SQLException e) {
            LogHandler.errorLog(this.logger, e);
        }
        this.close(conn);
    }

    public void close(ResultSet rest) throws SQLException {
        if (rest != null) {
            rest.close();
        }
    }

    public void close(Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
    }

    public void close(Connection conn) {
        if (conn != null) {
            this.closeConnection(conn);
        }
    }
}

