/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.easyda;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ecside.easyda.DataAccessInterceptor;
import org.ecside.easyda.DataAccessModel;
import org.ecside.easyda.DataExportModel;
import org.ecside.util.RequestUtils;
import org.ecside.util.ServletUtils;

public class DataAccessHandler {
    public void exportList(DataExportModel dataAccessModel, String sqlName, String type, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (dataAccessModel == null) {
            return;
        }
        DataAccessInterceptor dataAccessInterceptor = dataAccessModel.getInterceptor(sqlName);
        Map parameterMap = ServletUtils.getParameterMap(request);
        if (dataAccessInterceptor != null) {
            dataAccessInterceptor.before(parameterMap, request, response);
        }
        dataAccessModel.doExport(sqlName, type, parameterMap, (OutputStream)response.getOutputStream());
        if (dataAccessInterceptor != null) {
            dataAccessInterceptor.after(parameterMap, request, response);
        }
    }

    public void dataAccess(DataAccessModel dataAccessModel, String sqlName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object result;
        if (dataAccessModel == null) {
            return;
        }
        DataAccessInterceptor dataAccessInterceptor = dataAccessModel.getInterceptor(sqlName);
        Map parameterMap = ServletUtils.getParameterMap(request);
        if (dataAccessInterceptor != null) {
            dataAccessInterceptor.before(parameterMap, request, response);
        }
        if ((result = dataAccessModel.executeSql(sqlName, parameterMap)) instanceof List) {
            request.setAttribute("recordList", result);
        } else if (result instanceof Map) {
            request.setAttribute("record", result);
        } else if (result instanceof Integer) {
            if ((Integer)result > 0) {
                request.setAttribute("UPDATE_RESULT_CODE", (Object)RequestUtils.successfulInfo(request));
            } else {
                request.setAttribute("UPDATE_RESULT_CODE", (Object)RequestUtils.failedInfo(request));
            }
        }
        if (dataAccessInterceptor != null) {
            dataAccessInterceptor.after(parameterMap, request, response);
        }
    }
}

