/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.easyda;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.common.log.LogHandler;
import org.ecside.easyda.BaseDAO;
import org.ecside.easyda.DataAccessInterceptor;
import org.ecside.easyda.DataAccessUtil;
import org.ecside.easydataaccess.EasyDataAccessUtil;
import org.ecside.easydataaccess.SqlParameter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class DataAccessModel
extends BaseDAO
implements InitializingBean {
    private Log logger;
    protected Map sqls;
    protected Map sqlSnippets;
    protected Map querySqls;
    protected Map updateSqls;
    protected Map callSqls;
    protected Map attributes;
    protected Map interceptors;
    static /* synthetic */ Class class$0;

    public DataAccessModel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.easyda.DataAccessModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.interceptors = new HashMap();
    }

    public void registerInterceptors() {
    }

    public void addInterceptor(DataAccessInterceptor dataAccessInterceptor) {
        this.interceptors.put(dataAccessInterceptor.getSqlName(), dataAccessInterceptor);
    }

    public DataAccessInterceptor getInterceptor(String sqlName) {
        return (DataAccessInterceptor)this.interceptors.get(sqlName);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.sqls == null) {
            return;
        }
        this.querySqls = new HashMap();
        this.updateSqls = new HashMap();
        this.callSqls = new HashMap();
        this.sqlSnippets = new HashMap();
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        Iterator iter = this.sqls.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String orgSql = StringUtils.trimWhitespace((String)((String)this.sqls.get(key)));
            if (orgSql == null) continue;
            String newSql = EasyDataAccessUtil.parseEasySql(orgSql);
            this.sqlSnippets.put(key, EasyDataAccessUtil.createSqlSnippets(newSql));
            StringBuffer newSqlBf = new StringBuffer(newSql);
            this.sqls.put(key, newSqlBf);
            if (StringUtils.startsWithIgnoreCase((String)newSql, (String)"select ")) {
                this.querySqls.put(key, newSqlBf);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)newSql, (String)"update ") || StringUtils.startsWithIgnoreCase((String)newSql, (String)"insert ") || StringUtils.startsWithIgnoreCase((String)newSql, (String)"delete ")) {
                this.updateSqls.put(key, newSqlBf);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)newSql, (String)"{") && StringUtils.endsWithIgnoreCase((String)newSql, (String)"}")) {
                this.callSqls.put(key, newSqlBf);
                continue;
            }
            this.attributes.put(key, orgSql);
        }
        this.registerInterceptors();
    }

    public Object executeSql(String name, Map parameterMap) {
        Object result = null;
        result = this.isQuerySql(name) ? this.executeQuery(name, parameterMap) : (this.isUpdateSql(name) ? this.executeUpdate(name, parameterMap) : (this.isCallSql(name) ? this.executeCall(name, parameterMap) : this.executeUpdate(name, parameterMap)));
        return result;
    }

    public List executeQuery(String name, Map parameterMap) {
        String sql = ((StringBuffer)this.querySqls.get(name)).toString();
        List sqlSnippetList = (List)this.sqlSnippets.get(name);
        return this.executeQuery(parameterMap, sql, sqlSnippetList);
    }

    public String executeQueryFunction(String name, Map parameterMap) {
        String sql = ((StringBuffer)this.querySqls.get(name)).toString();
        List sqlSnippetList = (List)this.sqlSnippets.get(name);
        return this.executeQueryFunction(parameterMap, sql, sqlSnippetList);
    }

    public Integer executeUpdate(String name, Map parameterMap) {
        String sql = ((StringBuffer)this.updateSqls.get(name)).toString();
        List sqlSnippetList = (List)this.sqlSnippets.get(name);
        return this.executeUpdate(parameterMap, sql, sqlSnippetList);
    }

    public Map executeCall(String name, Map parameterMap) {
        String sql = ((StringBuffer)this.callSqls.get(name)).toString();
        List sqlSnippetList = (List)this.sqlSnippets.get(name);
        return this.executeCall(parameterMap, sql, sqlSnippetList);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List executeQuery(Map map, String sql, List sqlSnippetList) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rest = null;
        ArrayList recordList = null;
        try {
            try {
                conn = this.getConnection();
                pstmt = EasyDataAccessUtil.createPreparedStatement(conn, sql, sqlSnippetList, map);
                rest = pstmt.executeQuery();
                String[] columnName = DataAccessUtil.getColumnNames(rest);
                map.put("FIELD_NAMES", columnName);
                recordList = new ArrayList();
                HashMap record = null;
                while (rest.next()) {
                    record = new HashMap();
                    DataAccessUtil.buildRecordMap(rest, columnName, record);
                    recordList.add(record);
                }
            }
            catch (Exception e) {
                LogHandler.errorLog(this.logger, e);
                recordList = null;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.close(rest, pstmt, conn);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        this.close(rest, pstmt, conn);
        return recordList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeQueryFunction(Map map, String sql, List sqlSnippetList) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rest = null;
        String record = null;
        try {
            try {
                conn = this.getConnection();
                pstmt = EasyDataAccessUtil.createPreparedStatement(conn, sql, sqlSnippetList, map);
                rest = pstmt.executeQuery();
                if (rest.next()) {
                    record = rest.getString(1);
                }
            }
            catch (Exception e) {
                LogHandler.errorLog(this.logger, e);
                record = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.close(rest, pstmt, conn);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        this.close(rest, pstmt, conn);
        return record;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer executeUpdate(Map map, String sql, List sqlSnippetList) {
        int opresult = -1;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                conn = this.getConnection();
                pstmt = EasyDataAccessUtil.createPreparedStatement(conn, sql, sqlSnippetList, map);
                opresult = pstmt.executeUpdate();
            }
            catch (Exception e) {
                LogHandler.errorLog(this.logger, e);
                opresult = -1;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.close(pstmt, conn);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.close(pstmt, conn);
        return new Integer(opresult);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map executeCall(Map map, String sql, List sqlSnippetList) {
        boolean opresult = false;
        ArrayList paraList = new ArrayList();
        HashMap<String, String> result = new HashMap<String, String>();
        Connection conn = null;
        Statement pstmt = null;
        CallableStatement cstmt = null;
        try {
            try {
                conn = this.getConnection();
                cstmt = EasyDataAccessUtil.createPreparedCallStatement(conn, sql, sqlSnippetList, map, paraList);
                opresult = cstmt.execute();
                if (!opresult) {
                    int i = 0;
                    while (i < paraList.size()) {
                        SqlParameter sqlParameter = (SqlParameter)paraList.get(i);
                        if ("out".equals(sqlParameter.getType())) {
                            result.put(sqlParameter.getName(), cstmt.getString(sqlParameter.getIndex()));
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                LogHandler.errorLog(this.logger, e);
                opresult = false;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.close(pstmt, conn);
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        this.close(pstmt, conn);
        return result;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public String getSql(String name) {
        StringBuffer sql = (StringBuffer)this.sqls.get(name);
        return sql != null ? sql.toString() : null;
    }

    public String getQuerySql(String name) {
        StringBuffer sql = (StringBuffer)this.querySqls.get(name);
        return sql != null ? sql.toString() : null;
    }

    public String getUpdateSql(String name) {
        StringBuffer sql = (StringBuffer)this.updateSqls.get(name);
        return sql != null ? sql.toString() : null;
    }

    public String getCallSql(String name) {
        StringBuffer sql = (StringBuffer)this.callSqls.get(name);
        return sql != null ? sql.toString() : null;
    }

    public boolean isQuerySql(String name) {
        return this.querySqls.get(name) != null;
    }

    public boolean isUpdateSql(String name) {
        return this.updateSqls.get(name) != null;
    }

    public boolean isCallSql(String name) {
        return this.callSqls.get(name) != null;
    }

    public Map getSqls() {
        return this.sqls;
    }

    public void setSqls(Map sqls) {
        this.sqls = sqls;
    }

    public Map getInterceptors() {
        return this.interceptors;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public Map getCallSqls() {
        return this.callSqls;
    }

    public void setCallSqls(Map callSqls) {
        this.callSqls = callSqls;
    }
}

