/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.easyda;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import jxl.Workbook;
import jxl.biff.FontRecord;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.common.log.LogHandler;
import org.ecside.easyda.DataAccessModel;
import org.ecside.easyda.DataAccessUtil;
import org.ecside.easyda.DataHtmlBuilder;
import org.ecside.easydataaccess.EasyDataAccessUtil;
import org.ecside.util.ExportViewUtils;

public class DataExportModel
extends DataAccessModel {
    Log logger;
    public static final int WIDTH_MULT = 240;
    public static final int MIN_CHARS = 8;
    public static final short DEFAULT_FONT_HEIGHT = 8;
    public static final double NON_NUMERIC = -0.99999;
    public static final String DEFAULT_MONEY_FORMAT = "$###,###,##0.00";
    public static final String DEFAULT_PERCENT_FORMAT = "##0.0%";
    public static final String NBSP = "&nbsp;";
    public static final int colWidth = 15;
    protected static final String CONFIG_DELIMITER = ",";
    protected static final String CSV_DELIMITER = ",";
    protected static final String TXT_DELIMITER = "\t";
    protected String columnTitles;
    protected String[] titlesColl;
    protected String format;
    protected String[] formatColl;
    protected Map mappingItems;
    static /* synthetic */ Class class$0;

    public DataExportModel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.easyda.DataExportModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
    }

    public void afterPropertiesSet() throws Exception {
        this.titlesColl = StringUtils.isNotBlank((String)this.columnTitles) ? this.columnTitles.split(",") : new String[0];
        this.formatColl = StringUtils.isNotBlank((String)this.format) ? this.format.split(",") : new String[0];
        super.afterPropertiesSet();
    }

    public void doExport(String sqlName, String type, Map parameterMap, OutputStream outputStream) {
        String sql = ((StringBuffer)this.querySqls.get(sqlName)).toString();
        List sqlSnippetList = (List)this.sqlSnippets.get(sqlName);
        if ("xls".equalsIgnoreCase(type)) {
            this.beforeExportXLS();
            this.doExportXLS(parameterMap, sql, sqlSnippetList, outputStream);
            this.afterExportXLS();
        } else if ("csv".equalsIgnoreCase(type)) {
            this.beforeExportCSV();
            this.doExportCSV(parameterMap, sql, sqlSnippetList, outputStream);
            this.afterExportCSV();
        } else if ("txt".equalsIgnoreCase(type)) {
            this.beforeExportTXT();
            this.doExportTXT(parameterMap, sql, sqlSnippetList, outputStream);
            this.afterExportTXT();
        } else {
            this.beforeExportTXT();
            this.doExportTXT(parameterMap, sql, sqlSnippetList, outputStream);
            this.afterExportTXT();
        }
    }

    public void doExportCSV(Map map, String sql, List sqlSnippetList, OutputStream outputStream) {
        this.doExportText(map, sql, sqlSnippetList, outputStream, ",");
    }

    public void doExportTXT(Map map, String sql, List sqlSnippetList, OutputStream outputStream) {
        this.doExportText(map, sql, sqlSnippetList, outputStream, TXT_DELIMITER);
    }

    public void beforeExportXLS() {
    }

    public void afterExportXLS() {
    }

    public void beforeExportCSV() {
    }

    public void afterExportCSV() {
    }

    public void beforeExportTXT() {
    }

    public void afterExportTXT() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doExportText(Map map, String sql, List sqlSnippetList, OutputStream outputStream, String delimiter) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rest = null;
        try {
            try {
                conn = this.getConnection();
                pstmt = EasyDataAccessUtil.createPreparedStatement(conn, sql, sqlSnippetList, map);
                rest = pstmt.executeQuery();
                String[] columnNames = DataAccessUtil.getColumnNames(rest);
                map.put("FIELD_NAMES", columnNames);
                DataAccessUtil.outputText(rest, outputStream, delimiter, columnNames, this.titlesColl, this.mappingItems);
            }
            catch (SQLException e) {
                LogHandler.errorLog(this.logger, e);
            }
            catch (Exception e) {
                LogHandler.errorLog(this.logger, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.close(rest, pstmt, conn);
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        this.close(rest, pstmt, conn);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doExportXLS(Map map, String sql, List sqlSnippetList, OutputStream outputStream) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rest = null;
        short cellnum = 0;
        int rownum = 0;
        try {
            try {
                conn = this.getConnection();
                pstmt = EasyDataAccessUtil.createPreparedStatement(conn, sql, sqlSnippetList, map);
                rest = pstmt.executeQuery();
                String[] columnNames = DataAccessUtil.getColumnNames(rest);
                map.put("FIELD_NAMES", columnNames);
                WritableWorkbook wb = Workbook.createWorkbook((OutputStream)outputStream);
                WritableSheet sheet = wb.createSheet("Export Workbook", 0);
                rownum += this.createXLSHeader(sheet, rownum);
                block6: while (true) {
                    if (!rest.next()) {
                        wb.write();
                        wb.close();
                    }
                    cellnum = 0;
                    int i = 0;
                    while (true) {
                        if (i >= columnNames.length) {
                            ++rownum;
                            continue block6;
                        }
                        String value = ExportViewUtils.parseXLS(rest.getString(columnNames[i]));
                        if (i < this.formatColl.length && "num".equalsIgnoreCase(this.formatColl[i])) {
                            this.writeToCellFormatted(sheet, cellnum, rownum, value, null);
                        } else {
                            this.writeToCellAsText(sheet, cellnum, rownum, value, null);
                        }
                        cellnum = (short)(cellnum + 1);
                        ++i;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                LogHandler.errorLog(this.logger, e);
            }
            catch (Exception e) {
                LogHandler.errorLog(this.logger, e);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.close(rest, pstmt, conn);
            throw throwable;
        }
        {
            Object var15_19 = null;
        }
        this.close(rest, pstmt, conn);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doExportHTML(Map map, String sql, List sqlSnippetList, OutputStream outputStream, DataHtmlBuilder dataHtmlBuilder) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rest = null;
        try {
            try {
                conn = this.getConnection();
                pstmt = EasyDataAccessUtil.createPreparedStatement(conn, sql, sqlSnippetList, map);
                rest = pstmt.executeQuery();
                String[] columnNames = DataAccessUtil.getColumnNames(rest);
                map.put("FIELD_NAMES", columnNames);
                dataHtmlBuilder.setWrite(new PrintWriter(outputStream, true));
                dataHtmlBuilder.setColumnNames(columnNames);
                dataHtmlBuilder.tableStart();
                dataHtmlBuilder.tbodyStart();
                while (true) {
                    if (!rest.next()) {
                        dataHtmlBuilder.tbodyEnd();
                        dataHtmlBuilder.tableEnd();
                    }
                    dataHtmlBuilder.tr(rest);
                    dataHtmlBuilder.cells(rest);
                    dataHtmlBuilder.trEnd();
                }
            }
            catch (SQLException e) {
                LogHandler.errorLog(this.logger, e);
            }
            catch (Exception e) {
                LogHandler.errorLog(this.logger, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.close(rest, pstmt, conn);
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        this.close(rest, pstmt, conn);
    }

    public static short createTextHeader(String[] titlesColl, OutputStream outputStream, String delimiter) throws WriteException, IOException {
        if (titlesColl == null || titlesColl.length < 1) {
            return 0;
        }
        int i = 0;
        while (i < titlesColl.length) {
            String value = titlesColl[i];
            value = value == null ? delimiter : String.valueOf(value.trim()) + delimiter;
            outputStream.write(value.getBytes());
            ++i;
        }
        outputStream.write("\r\n".getBytes());
        return 1;
    }

    public static short createCSVHeader(String[] titles, OutputStream outputStream) throws WriteException, IOException {
        if (titles == null || titles.length < 1) {
            return 0;
        }
        int i = 0;
        while (i < titles.length) {
            String value = titles[i];
            value = ExportViewUtils.parseCSV(value);
            outputStream.write(value.getBytes());
            if (i < titles.length - 1) {
                outputStream.write(44);
            }
            ++i;
        }
        outputStream.write("\r\n".getBytes());
        return 1;
    }

    public short createXLSHeader(WritableSheet sheet, int rownum) throws WriteException {
        if (this.titlesColl == null || this.titlesColl.length < 1) {
            return 0;
        }
        WritableCellFormat cellFormat = new WritableCellFormat();
        WritableFont arial10font = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        cellFormat.setBackground(Colour.GRAY_25);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.GRAY_50);
        cellFormat.setFont((FontRecord)arial10font);
        int i = 0;
        while (i < this.titlesColl.length) {
            this.writeToCellAsText(sheet, (short)i, rownum, this.titlesColl[i], cellFormat);
            ++i;
        }
        return 1;
    }

    private void writeToCellAsText(WritableSheet sheet, short cellnum, int rownum, String value, WritableCellFormat styleModifier) throws RowsExceededException, WriteException {
        if (value.trim().equals(NBSP)) {
            value = "";
        }
        Label label = new Label((int)cellnum, rownum, value);
        if (styleModifier != null) {
            label.setCellFormat((CellFormat)styleModifier);
        }
        sheet.addCell((WritableCell)label);
    }

    private void writeToCellFormatted(WritableSheet sheet, short cellnum, int rownum, String value, WritableCellFormat styleModifier) throws RowsExceededException, WriteException {
        double numeric = -0.99999;
        try {
            numeric = Double.parseDouble(value);
        }
        catch (Exception e) {
            numeric = -0.99999;
        }
        if (value.startsWith("$") || value.endsWith("%") || value.startsWith("($")) {
            value = StringUtils.replace((String)value, (String)"$", (String)"");
            value = StringUtils.replace((String)value, (String)"%", (String)"");
            value = StringUtils.replace((String)value, (String)",", (String)"");
            value = StringUtils.replace((String)value, (String)"(", (String)"-");
            value = StringUtils.replace((String)value, (String)")", (String)"");
            try {
                numeric = Double.parseDouble(value);
            }
            catch (Exception e) {
                numeric = -0.99999;
            }
        } else if (Math.abs(numeric - -0.99999) >= 1.0E-7) {
            Number number = new Number((int)cellnum, rownum, numeric);
            if (styleModifier != null) {
                number.setCellFormat((CellFormat)styleModifier);
            }
            sheet.addCell((WritableCell)number);
        } else {
            if (value.trim().equals(NBSP)) {
                value = "";
            }
            Label label = new Label((int)cellnum, rownum, value);
            if (styleModifier != null) {
                label.setCellFormat((CellFormat)styleModifier);
            }
            sheet.addCell((WritableCell)label);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getColumnTitles() {
        return this.columnTitles;
    }

    public void setColumnTitles(String columnTitles) {
        this.columnTitles = columnTitles;
    }

    public Map getMappingItems() {
        return this.mappingItems;
    }

    public void setMappingItems(Map mappingItems) {
        this.mappingItems = mappingItems;
    }
}

