/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.easydataaccess;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectionUtils {
    public static final ThreadLocal statementMap = new ThreadLocal();

    public static void initStatementMap(Connection conn) {
        String key = String.valueOf(conn);
        Map map = (Map)statementMap.get();
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            statementMap.set(map);
        }
        if (map.get(key) == null) {
            map.put(key, new ArrayList());
        }
    }

    public static void putStatement(Connection conn, Statement statement) {
        Map map = (Map)statementMap.get();
        List list = (List)map.get(conn.toString());
        list.add(statement);
    }

    public static void closeAllStatement(Connection conn) {
        Map map = (Map)statementMap.get();
        List list = (List)map.get(conn.toString());
        Iterator itor = list.iterator();
        while (itor.hasNext()) {
            Statement stm = (Statement)itor.next();
            try {
                stm.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Statement createStatement(Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static Statement createStatement(Connection conn, int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement = conn.createStatement(resultSetType, resultSetConcurrency);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static Statement createStatement(Connection conn, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement statement = conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static CallableStatement prepareCall(Connection conn, String sql) throws SQLException {
        CallableStatement statement = conn.prepareCall(sql);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static CallableStatement prepareCall(Connection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement statement = conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static CallableStatement prepareCall(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement statement = conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(sql);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(sql, autoGeneratedKeys);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(sql, columnIndexes);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, String[] columnNames) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(sql, columnNames);
        ConnectionUtils.putStatement(conn, statement);
        return statement;
    }
}

